/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.eclipse.rap.ui.internal.servlet.EngineConfigWrapper;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.engine.ApplicationContext;
import org.eclipse.rwt.internal.engine.ApplicationContextUtil;
import org.eclipse.rwt.internal.engine.RWTDelegate;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    public static final String DEFAULT_SERVLET = "rap";
    public static final String ID_HTTP_CONTEXT = "org.eclipse.rap.httpcontext";
    private final Map servletAliases;
    private final String resourceAlias;
    private HttpContextExtensionService httpCtxExtService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HttpServiceTracker(BundleContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz.getName(), null);
        this.servletAliases = new LinkedHashMap();
        this.resourceAlias = "rwt-resources";
    }

    public Object addingService(ServiceReference reference) {
        HttpService result = this.getHttpService(reference);
        HttpContext httpContext = this.getHttpContext(reference, result);
        ApplicationContext applicationContext = HttpServiceTracker.createAndInitializeRWTContext();
        this.registerServlets(reference, result, httpContext, applicationContext);
        this.registerResourceDir(result, httpContext, applicationContext);
        return result;
    }

    public void removedService(ServiceReference reference, Object service) {
        HttpService httpService = (HttpService)service;
        this.deregisterResourceDir(httpService);
        this.deregisterServlets(reference, httpService);
        super.removedService(reference, service);
    }

    public void addServletAlias(String name, Filter filter) {
        this.servletAliases.put(name, filter);
    }

    public void open() {
        this.openWhenHttpContextServiceHasBeenStarted();
    }

    private void openWhenHttpContextServiceHasBeenStarted() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.http.registry.HttpContextExtensionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String service = clazz.getName();
        ServiceTracker httpContextTracker = new ServiceTracker(this.context, service, null){

            public Object addingService(ServiceReference reference) {
                Object result = super.addingService(reference);
                HttpServiceTracker.this.httpCtxExtService = HttpServiceTracker.this.createHttpCtxExtService(reference);
                HttpServiceTracker.super.open();
                return result;
            }

            public void removedService(ServiceReference reference, Object service) {
                HttpServiceTracker.this.httpCtxExtService = null;
                super.removedService(reference, service);
            }
        };
        httpContextTracker.open();
    }

    private void registerServlets(ServiceReference reference, HttpService httpService, HttpContext httpContext, ApplicationContext rwtContext) {
        this.ensureDefaultAlias();
        Iterator aliases = this.servletAliases.keySet().iterator();
        while (aliases.hasNext()) {
            String alias = (String)aliases.next();
            Filter serviceFilter = (Filter)this.servletAliases.get(alias);
            if (serviceFilter != null && !serviceFilter.match(reference)) continue;
            this.registerServlet(alias, httpService, httpContext, rwtContext);
        }
    }

    private void deregisterServlets(ServiceReference reference, HttpService httpService) {
        Iterator aliases = this.servletAliases.keySet().iterator();
        while (aliases.hasNext()) {
            String alias = (String)aliases.next();
            Filter serviceFilter = (Filter)this.servletAliases.get(alias);
            if (serviceFilter != null && !serviceFilter.match(reference)) continue;
            this.deregisterAlias(alias, httpService);
        }
    }

    private void registerServlet(String name, HttpService httpService, HttpContext httpContext, ApplicationContext rwtContext) {
        try {
            RWTDelegate handler = new RWTDelegate();
            httpService.registerServlet("/" + name, (Servlet)handler, null, httpContext);
            ServletContext servletContext = handler.getServletContext();
            ApplicationContextUtil.registerApplicationContext((ServletContext)servletContext, (ApplicationContext)rwtContext);
        }
        catch (Exception exception) {
            HttpServiceTracker.logError("Failed to register servlet " + name, exception);
        }
    }

    private void registerResourceDir(HttpService httpService, HttpContext httpContext, ApplicationContext rwtContext) {
        if (httpService != null) {
            String contextRoot = HttpServiceTracker.getContextRoot(rwtContext);
            String location = String.valueOf(contextRoot) + "/" + "rwt-resources";
            try {
                httpService.registerResources("/" + this.resourceAlias, location, httpContext);
            }
            catch (Exception exception) {
                HttpServiceTracker.logError("Failed to register resource alias", exception);
            }
        }
    }

    private void deregisterResourceDir(HttpService httpService) {
        this.deregisterAlias(this.resourceAlias, httpService);
    }

    private void deregisterAlias(String alias, HttpService httpService) {
        try {
            httpService.unregister("/" + alias);
        }
        catch (Exception exception) {
            HttpServiceTracker.logError("Failed to unregister servlet " + alias, exception);
        }
    }

    private void ensureDefaultAlias() {
        if (this.servletAliases.size() == 0) {
            this.servletAliases.put(DEFAULT_SERVLET, null);
        }
    }

    private HttpService getHttpService(ServiceReference reference) {
        return (HttpService)this.context.getService(reference);
    }

    private HttpContext getHttpContext(ServiceReference reference, HttpService httpService) {
        HttpContext httpContext = this.httpCtxExtService.getHttpContext(reference, ID_HTTP_CONTEXT);
        if (httpContext == null) {
            httpContext = httpService.createDefaultHttpContext();
        }
        return new HttpContextWrapper(httpContext);
    }

    private HttpContextExtensionService createHttpCtxExtService(ServiceReference reference) {
        return (HttpContextExtensionService)this.context.getService(reference);
    }

    private static ApplicationContext createAndInitializeRWTContext() {
        ApplicationContext result = ApplicationContextUtil.createApplicationContext();
        ApplicationContextUtil.runWithInstance((ApplicationContext)result, (Runnable)new Runnable(){

            public void run() {
                new EngineConfigWrapper();
            }
        });
        return result;
    }

    private static String getContextRoot(ApplicationContext rwtContext) {
        final String[] result = new String[1];
        ApplicationContextUtil.runWithInstance((ApplicationContext)rwtContext, (Runnable)new Runnable(){

            public void run() {
                IEngineConfig engineConfig = RWTFactory.getConfigurationReader().getEngineConfig();
                String contextRoot = engineConfig.getServerContextDir().toString();
                result[0] = new Path(contextRoot).toString();
            }
        });
        return result[0];
    }

    private static void logError(String message, Exception exception) {
        Status status = new Status(4, "org.eclipse.rap.ui", 0, message, (Throwable)exception);
        WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
    }

    private static final class HttpContextWrapper
    implements HttpContext {
        private final HttpContext context;

        private HttpContextWrapper(HttpContext context) {
            Assert.isNotNull((Object)context);
            this.context = context;
        }

        public String getMimeType(String name) {
            return this.context.getMimeType(name);
        }

        public URL getResource(String name) {
            URL result = null;
            try {
                File file = new File(name);
                if (file.exists() && !file.isDirectory()) {
                    result = new URL("file", "", name);
                }
            }
            catch (MalformedURLException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            return result;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
            return true;
        }
    }
}

