/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeItemLCA
extends AbstractWidgetLCA {
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_CHECKED = "checked";
    static final String PROP_EXPANDED = "expanded";
    static final String PROP_SELECTION = "selection";
    static final String PROP_BACKGROUND = "background";
    static final String PROP_FOREGROUND = "foreground";
    static final String PROP_FONT = "font";
    static final String PROP_CELL_BACKGROUNDS = "backgrounds";
    static final String PROP_CELL_FOREGROUNDS = "foregrounds";
    static final String PROP_CELL_FONTS = "fonts";
    static final String PROP_GRAYED = "grayed";
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_MATERIALIZED = "materialized";
    static final String PROP_VARIANT = "variant";
    private static final Integer DEFAULT_ITEM_COUNT = new Integer(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void preserveValues(Widget widget) {
        TreeItem treeItem = (TreeItem)widget;
        Tree tree = treeItem.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeAdapter treeAdapter = (ITreeAdapter)tree.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)treeItem.getAdapter((Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetColorAdapter colorAdapter = (IWidgetColorAdapter)treeItem.getAdapter((Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)treeItem.getAdapter((Class)clazz4);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)treeItem);
        boolean selection = TreeItemLCA.isSelected(treeItem);
        adapter.preserve(PROP_SELECTION, (Object)selection);
        if (treeAdapter.isCached(treeItem)) {
            adapter.preserve(PROP_ITEM_COUNT, (Object)new Integer(treeItem.getItemCount()));
            TreeItemLCA.preserveFont(treeItem);
            adapter.preserve(PROP_CHECKED, (Object)treeItem.getChecked());
            adapter.preserve(PROP_EXPANDED, (Object)treeItem.getExpanded());
            adapter.preserve(PROP_TEXTS, (Object)TreeItemLCA.getTexts(treeItem));
            adapter.preserve(PROP_IMAGES, (Object)TreeItemLCA.getImages(treeItem));
            adapter.preserve(PROP_BACKGROUND, (Object)colorAdapter.getUserBackgound());
            adapter.preserve(PROP_FOREGROUND, (Object)colorAdapter.getUserForegound());
            adapter.preserve(PROP_FONT, (Object)fontAdapter.getUserFont());
            adapter.preserve(PROP_CELL_BACKGROUNDS, (Object)itemAdapter.getCellBackgrounds());
            adapter.preserve(PROP_CELL_FOREGROUNDS, (Object)itemAdapter.getCellForegrounds());
            adapter.preserve(PROP_CELL_FONTS, (Object)itemAdapter.getCellFonts());
            adapter.preserve(PROP_GRAYED, (Object)treeItem.getGrayed());
        }
        adapter.preserve(PROP_MATERIALIZED, (Object)treeAdapter.isCached(treeItem));
        adapter.preserve(PROP_VARIANT, (Object)WidgetUtil.getVariant((Widget)treeItem));
    }

    public void readData(Widget widget) {
        final TreeItem treeItem = (TreeItem)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_CHECKED);
        if (value != null) {
            treeItem.setChecked(Boolean.valueOf(value).booleanValue());
        }
        if (WidgetLCAUtil.wasEventSent((Widget)treeItem, "org.eclipse.swt.events.treeExpanded")) {
            TreeItemLCA.processTreeExpandedEvent(treeItem);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    treeItem.setExpanded(true);
                }
            });
        }
        if (WidgetLCAUtil.wasEventSent((Widget)treeItem, "org.eclipse.swt.events.treeCollapsed")) {
            TreeItemLCA.processTreeCollapsedEvent(treeItem);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    treeItem.setExpanded(false);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        Integer index;
        Tree parent;
        TreeItem treeItem = (TreeItem)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        if (treeItem.getParentItem() == null) {
            parent = treeItem.getParent();
            index = new Integer(treeItem.getParent().indexOf(treeItem));
        } else {
            parent = treeItem.getParentItem();
            index = new Integer(treeItem.getParentItem().indexOf(treeItem));
        }
        Object[] args = new Object[]{parent, index, WidgetUtil.getId((Widget)widget)};
        writer.callStatic("org.eclipse.rwt.widgets.TreeItem.createItem", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        ITreeAdapter adapter;
        TreeItem treeItem = (TreeItem)widget;
        Tree tree = treeItem.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ITreeAdapter)tree.getAdapter((Class)clazz)).isCached(treeItem)) {
            TreeItemLCA.writeItemCount(treeItem);
            TreeItemLCA.writeImages(treeItem);
            TreeItemLCA.writeTexts(treeItem);
            TreeItemLCA.writeBackground(treeItem);
            TreeItemLCA.writeForeground(treeItem);
            TreeItemLCA.writeFont(treeItem);
            TreeItemLCA.writeCellBackgrounds(treeItem);
            TreeItemLCA.writeCellForegrounds(treeItem);
            TreeItemLCA.writeCellFonts(treeItem);
            TreeItemLCA.writeSelection(treeItem);
            TreeItemLCA.writeExpanded(treeItem);
            TreeItemLCA.writeChecked(treeItem);
            TreeItemLCA.writeGrayed(treeItem);
        }
        TreeItemLCA.writeVariant(treeItem);
    }

    public void renderDispose(Widget widget) throws IOException {
        ITreeItemAdapter itemAdapter;
        TreeItem item = (TreeItem)widget;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz)).isParentDisposed()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.call("dispose", null);
        }
    }

    private static void writeItemCount(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Integer newValue = new Integer(item.getItemCount());
        writer.set(PROP_ITEM_COUNT, PROP_ITEM_COUNT, newValue, DEFAULT_ITEM_COUNT);
    }

    private static void writeVariant(TreeItem item) throws IOException {
        String variant = WidgetUtil.getVariant((Widget)item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_VARIANT, variant, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_VARIANT, new Object[]{"variant_" + variant});
        }
    }

    private static void writeImages(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Image[] images = TreeItemLCA.getImages(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_IMAGES, images)) {
            String[] imagePaths = new String[images.length];
            int i = 0;
            while (i < imagePaths.length) {
                imagePaths[i] = ImageFactory.getImagePath((Image)images[i]);
                ++i;
            }
            writer.set(PROP_IMAGES, new Object[]{imagePaths});
        }
    }

    private static void preserveFont(TreeItem treeItem) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)treeItem.getAdapter((Class)clazz);
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.preserveFont((Widget)treeItem, font);
    }

    private static void writeExpanded(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getExpanded();
        writer.set(PROP_EXPANDED, PROP_EXPANDED, newValue, Boolean.FALSE);
    }

    private static void writeChecked(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getChecked();
        writer.set(PROP_CHECKED, PROP_CHECKED, newValue, Boolean.FALSE);
    }

    private static void writeSelection(TreeItem item) throws IOException {
        Boolean defValue;
        Boolean newValue = TreeItemLCA.isSelected(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_SELECTION, newValue, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item.getParent());
            String jsFunction = TreeItemLCA.isSelected(item) ? "selectItem" : "deselectItem";
            writer.call(jsFunction, new Object[]{item});
            if (TreeItemLCA.isFocused(item)) {
                writer.set("focusItem", new Object[]{item});
            }
        }
    }

    private static void writeFont(TreeItem treeItem) throws IOException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = treeItem.getAdapter((Class)clazz);
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)adapter;
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.writeFont((Widget)treeItem, font);
    }

    private static void writeCellFonts(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Font[] fonts = itemAdapter.getCellFonts();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_CELL_FONTS, fonts, null)) {
            String[] css = null;
            if (fonts != null) {
                css = new String[fonts.length];
                int i = 0;
                while (i < fonts.length) {
                    css[i] = TreeItemLCA.toCss(fonts[i]);
                    ++i;
                }
            }
            writer.set("cellFonts", new Object[]{css});
        }
    }

    private static void writeBackground(TreeItem item) throws IOException {
        IWidgetColorAdapter colorAdapter;
        Color background;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_BACKGROUND, background = (colorAdapter = (IWidgetColorAdapter)item.getAdapter((Class)clazz)).getUserBackgound(), null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_BACKGROUND, background);
        }
    }

    private static void writeForeground(TreeItem item) throws IOException {
        IWidgetColorAdapter colorAdapter;
        Color foreground;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_FOREGROUND, foreground = (colorAdapter = (IWidgetColorAdapter)item.getAdapter((Class)clazz)).getUserForegound(), null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_FOREGROUND, foreground);
        }
    }

    private static void writeCellBackgrounds(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Color[] backgrounds = itemAdapter.getCellBackgrounds();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_CELL_BACKGROUNDS, "cellBackgrounds", backgrounds, null);
    }

    private static void writeCellForegrounds(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Color[] foregrounds = itemAdapter.getCellForegrounds();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_CELL_FOREGROUNDS, "cellForegrounds", foregrounds, null);
    }

    private static void writeTexts(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        String[] texts = TreeItemLCA.getTexts(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_TEXTS, texts)) {
            int i = 0;
            while (i < texts.length) {
                texts[i] = WidgetLCAUtil.escapeText(texts[i], false);
                texts[i] = texts[i].replaceAll(" ", "&nbsp;");
                ++i;
            }
            writer.set(PROP_TEXTS, new Object[]{texts});
        }
    }

    private static String[] getTexts(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        String[] texts = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            texts[i] = item.getText(i);
            ++i;
        }
        return texts;
    }

    private static Image[] getImages(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        Image[] images = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            images[i] = item.getImage(i);
            ++i;
        }
        return images;
    }

    private static int getColumnCount(TreeItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static void writeGrayed(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getGrayed();
        writer.set(PROP_GRAYED, PROP_GRAYED, newValue, Boolean.FALSE);
    }

    private static boolean isFocused(TreeItem item) {
        Tree tree = item.getParent();
        return tree.getSelectionCount() > 0 && tree.getSelection()[0] == item;
    }

    private static boolean isSelected(TreeItem item) {
        boolean result = false;
        Tree tree = item.getParent();
        TreeItem[] selectedItems = tree.getSelection();
        int i = 0;
        while (!result && i < selectedItems.length) {
            if (item == selectedItems[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static String toCss(Font font) {
        StringBuffer result = new StringBuffer();
        if (font != null) {
            FontData fontData = FontUtil.getData((Font)font);
            if ((fontData.getStyle() & 2) != 0) {
                result.append("italic ");
            }
            if ((fontData.getStyle() & 1) != 0) {
                result.append("bold ");
            }
            result.append(fontData.getHeight());
            result.append("px ");
            String escapedName = fontData.getName().replaceAll("\"", "");
            result.append(escapedName);
        } else {
            result.append("");
        }
        return result.toString();
    }

    private static void processTreeExpandedEvent(TreeItem treeItem) {
        if (TreeEvent.hasListener((Adaptable)treeItem.getParent())) {
            TreeEvent event = new TreeEvent((Widget)treeItem.getParent(), (Widget)treeItem, 17);
            event.processEvent();
        }
    }

    private static void processTreeCollapsedEvent(TreeItem treeItem) {
        if (TreeEvent.hasListener((Adaptable)treeItem.getParent())) {
            TreeEvent event = new TreeEvent((Widget)treeItem.getParent(), (Widget)treeItem, 18);
            event.processEvent();
        }
    }
}

