/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public abstract class Resource {
    final Device device;
    private boolean disposed;

    Resource(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        Device result;
        if (this.disposed) {
            SWT.error(44);
        }
        if ((result = this.device) == null) {
            result = Display.getCurrent();
        }
        return result;
    }

    public void dispose() {
        if (this.device == null) {
            String msg = "A factory-created resource cannot be disposed.";
            throw new IllegalStateException(msg);
        }
        this.destroy();
        this.disposed = true;
    }

    void destroy() {
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    static Device checkDevice(Device device) {
        Device result = device;
        if (result == null) {
            result = Display.getCurrent();
        }
        if (result == null) {
            SWT.error(4);
        }
        return result;
    }
}

