/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.Scope;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.ILifeCycle;

public class LifeCycleFactory {
    private static final String ATTR_SESSION_LIFE_CYCLE;
    private LifeCycle applicationScopedLifeCycle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.LifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_SESSION_LIFE_CYCLE = String.valueOf(clazz.getName()) + "#sessionLifeCycle";
    }

    public ILifeCycle getLifeCycle() {
        ILifeCycle result = this.applicationScopedLifeCycle != null ? this.applicationScopedLifeCycle : LifeCycleFactory.getSessionLifeCycle();
        if (result == null) {
            result = this.loadLifeCycle();
        }
        return result;
    }

    public void destroy() {
        this.applicationScopedLifeCycle = null;
    }

    private ILifeCycle loadLifeCycle() {
        LifeCycle result = this.instantiateLifeCycle();
        if (Scope.APPLICATION.equals(result.getScope())) {
            this.applicationScopedLifeCycle = result;
        } else {
            LifeCycleFactory.setSessionLifeCycle(result);
        }
        return result;
    }

    private LifeCycle instantiateLifeCycle() {
        String className = LifeCycleFactory.getLifeCycleClassName();
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (LifeCycle)ClassUtil.newInstance(classLoader, className);
    }

    private static void setSessionLifeCycle(ILifeCycle result) {
        ContextProvider.getSession().setAttribute(ATTR_SESSION_LIFE_CYCLE, result);
    }

    private static ILifeCycle getSessionLifeCycle() {
        return (ILifeCycle)ContextProvider.getSession().getAttribute(ATTR_SESSION_LIFE_CYCLE);
    }

    private static String getLifeCycleClassName() {
        IConfiguration configuration = RWTFactory.getConfigurationReader().getConfiguration();
        return configuration.getLifeCycle();
    }
}

