/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin.callback;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.AbstractServiceCallbackAssociator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.IExportableServiceCallbackAssociator;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

@Component(immediate=true)
public class ExportableServiceCallbackAssociator
extends AbstractServiceCallbackAssociator
implements RemoteServiceAdminListener,
IExportableServiceCallbackAssociator {
    private Map<ServiceReference<?>, CallbackAssociation> callbackAssociations;

    @Override
    @Reference
    protected void bindContainerManager(IContainerManager cm) {
        super.bindContainerManager(cm);
    }

    @Override
    protected void unbindContainerManager(IContainerManager cm) {
        super.unbindContainerManager(cm);
    }

    @Override
    @Reference
    protected void bindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        super.bindRemoteServiceAdmin(rsa);
    }

    @Override
    protected void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        super.unbindRemoteServiceAdmin(rsa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> associateCallback(ServiceReference<?> exportableServiceReference, Class<?> callbackClass) {
        CallbackAssociation es = null;
        Map<ServiceReference<?>, CallbackAssociation> map = this.callbackAssociations;
        synchronized (map) {
            es = this.callbackAssociations.put(exportableServiceReference, new CallbackAssociation(callbackClass));
        }
        return es == null ? null : es.callbackClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getAssociatedCallback(ServiceReference<?> exportedServiceReference) {
        CallbackAssociation es = null;
        Map<ServiceReference<?>, CallbackAssociation> map = this.callbackAssociations;
        synchronized (map) {
            es = this.callbackAssociations.get(exportedServiceReference);
        }
        return es == null ? null : es.callbackClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> unassociateCallback(ServiceReference<?> exportedServiceReference) {
        CallbackAssociation es = null;
        Map<ServiceReference<?>, CallbackAssociation> map = this.callbackAssociations;
        synchronized (map) {
            es = this.callbackAssociations.remove(exportedServiceReference);
        }
        return es == null ? null : es.callbackClass;
    }

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        super.activate(bundleContext);
        this.callbackAssociations = new HashMap();
    }

    @Override
    @Deactivate
    protected void deactivate() {
        if (this.callbackAssociations != null) {
            this.callbackAssociations.clear();
            this.callbackAssociations = null;
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        ServiceReference svcRef;
        RemoteServiceAdmin.ExportReference exportRef;
        int type = event.getType();
        Throwable t = event.getException();
        if (t == null && (exportRef = (RemoteServiceAdmin.ExportReference)event.getExportReference()) != null && (svcRef = exportRef.getExportedService()) != null) {
            CallbackAssociation es = null;
            Map<ServiceReference<?>, CallbackAssociation> map = this.callbackAssociations;
            synchronized (map) {
                if (type == 2) {
                    es = this.callbackAssociations.get(svcRef);
                } else if (type == 3) {
                    es = this.callbackAssociations.remove(svcRef);
                }
            }
            if (es != null) {
                if (type == 2) {
                    es.exportViaContainer(exportRef.getContainerID());
                } else if (type == 3) {
                    es.unexportViaContainer();
                }
            }
        }
    }

    protected class CallbackAssociation {
        protected Class<?> callbackClass;
        protected IContainer exportingContainer;
        protected RemoteServiceAdmin.ImportRegistration importRegistration;
        protected CallbackAssociationRemoteServiceListener listener;

        protected CallbackAssociation(Class<?> callbackClass) {
            this.callbackClass = callbackClass;
            this.listener = new CallbackAssociationRemoteServiceListener();
        }

        protected IRemoteServiceContainerAdapter getRSAdapter() {
            if (this.exportingContainer != null) {
                return (IRemoteServiceContainerAdapter)this.exportingContainer.getAdapter(IRemoteServiceContainerAdapter.class);
            }
            return null;
        }

        protected synchronized void exportViaContainer(ID containerID) {
            this.exportingContainer = ExportableServiceCallbackAssociator.this.getContainerManager().getContainer(containerID);
            IRemoteServiceContainerAdapter ca = this.getRSAdapter();
            if (ca != null) {
                ca.addRemoteServiceListener((IRemoteServiceListener)this.listener);
            }
        }

        protected synchronized void unexportViaContainer() {
            IRemoteServiceContainerAdapter ca = this.getRSAdapter();
            if (ca != null) {
                ca.removeRemoteServiceListener((IRemoteServiceListener)this.listener);
            }
            this.exportingContainer = null;
        }

        protected Map<String, Object> createImportProperties(IRemoteServiceReference rsRef) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            IRemoteServiceID rsID = rsRef.getID();
            ID rcID = rsID.getContainerID();
            result.put("ecf.endpoint.id", rcID.getName());
            result.put("ecf.endpoint.id.ns", rcID.getNamespace().getName());
            result.put("objectClass", new String[]{this.callbackClass.getName()});
            result.put("ecf.endpoint.connecttarget.id", this.exportingContainer.getID().getName());
            result.put("ecf.endpoint.idfilter.ids", new String[]{rcID.getName()});
            result.put("ecf.rsvc.id", rsID.getContainerRelativeID());
            result.put("service.imported", "true");
            result.put("ecf.exported.async.interfaces", "*");
            String[] stringArray = rsRef.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.startsWith("ecf.x.rsa.")) {
                    result.put(key.substring("ecf.x.rsa.".length()), rsRef.getProperty(key));
                }
                ++n2;
            }
            return result;
        }

        public class CallbackAssociationRemoteServiceListener
        implements IRemoteServiceListener {
            public void handleServiceEvent(IRemoteServiceEvent event) {
                if (Arrays.asList(event.getClazzes()).contains(CallbackAssociation.this.callbackClass.getName())) {
                    if (event instanceof IRemoteServiceRegisteredEvent) {
                        if (CallbackAssociation.this.importRegistration == null) {
                            try {
                                CallbackAssociation.this.importRegistration = (RemoteServiceAdmin.ImportRegistration)ExportableServiceCallbackAssociator.this.getRSA().importService((org.osgi.service.remoteserviceadmin.EndpointDescription)new EndpointDescription(CallbackAssociation.this.createImportProperties(event.getReference())));
                                if (CallbackAssociation.this.importRegistration == null) {
                                    throw new RuntimeException("Callback import registration returned is null");
                                }
                                Throwable t = CallbackAssociation.this.importRegistration.getException();
                                if (t != null) {
                                    throw new RuntimeException("Exception importing callback service", t);
                                }
                            }
                            catch (Exception e) {
                                CallbackAssociation.this.importRegistration = null;
                                ExportableServiceCallbackAssociator.this.logException("Exception in callback rsa import", e);
                            }
                        }
                    } else if (event instanceof IRemoteServiceUnregisteredEvent && CallbackAssociation.this.importRegistration != null) {
                        try {
                            CallbackAssociation.this.importRegistration.close();
                            CallbackAssociation.this.importRegistration = null;
                        }
                        catch (Exception e) {
                            ExportableServiceCallbackAssociator.this.logException("Exception in callback rsa import", e);
                        }
                    }
                }
            }
        }
    }
}

