/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.host;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.status.SerializableStatus;
import org.eclipse.ecf.mgmt.framework.BundleMTO;
import org.eclipse.ecf.mgmt.framework.FrameworkMTO;
import org.eclipse.ecf.mgmt.framework.ServiceReferenceMTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.log.LogService;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public abstract class AbstractManager
implements IAdaptable {
    private BundleContext bundleContext;
    private LogService logService;
    private IAdapterManager adapterManager;
    private RemoteServiceAdmin remoteServiceAdmin;

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    protected LogService getLogService() {
        return this.logService;
    }

    protected void bindLogService(LogService logService) {
        this.logService = logService;
    }

    protected void unbindLogService(LogService logService) {
        this.logService = null;
    }

    protected IAdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected void bindAdapterManager(IAdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected void unbindAdapterManager(IAdapterManager adapterManager) {
        this.adapterManager = null;
    }

    protected void activate(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    protected void deactivate() throws Exception {
        this.bundleContext = null;
    }

    protected void bindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.remoteServiceAdmin = rsa;
    }

    protected void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.remoteServiceAdmin = null;
    }

    protected IStatus createErrorStatus(String message, Throwable t) {
        this.logError(message, t);
        return new SerializableStatus(4, this.getContext().getBundle().getSymbolicName(), message, t);
    }

    protected IStatus createErrorStatus(String message) {
        return this.createErrorStatus(message, null);
    }

    protected void logError(String message, Throwable t) {
        LogService log = this.getLogService();
        if (log != null) {
            log.log(1, message, t);
        }
        System.err.println(message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    protected List<Bundle> getAllBundles() {
        return Arrays.asList(this.getContext().getBundles());
    }

    protected <T> List<T> select(List<T> source, final Predicate<T> filter) {
        return source.stream().filter(new Predicate<T>(){

            @Override
            public boolean test(T ins) {
                return filter == null ? true : filter.test(ins);
            }
        }).collect(Collectors.toList());
    }

    protected <T, R> List<R> selectAndMap(List<T> source, Predicate<T> filter, Function<T, R> map) {
        return this.select(source, filter).stream().map(map).collect(Collectors.toList());
    }

    protected Bundle getBundle0(long bundleId) {
        return this.getContext().getBundle(bundleId);
    }

    protected Bundle getBundle0(String symbolicName) {
        List<Bundle> results = this.select(this.getAllBundles(), b -> b.getSymbolicName().equals(symbolicName));
        return results.size() == 0 ? null : results.get(0);
    }

    protected Bundle getFrameworkBundle() {
        return this.getBundle0(0L);
    }

    protected FrameworkDTO getFrameworkDTO() {
        return (FrameworkDTO)this.getFrameworkBundle().adapt(FrameworkDTO.class);
    }

    protected int getServiceReferenceExportImportState(long serviceId) {
        ServiceReference sRef;
        RemoteServiceAdmin rsa = this.remoteServiceAdmin;
        if (rsa == null) {
            return 0;
        }
        ServiceReference ref = null;
        for (ExportReference eRef : rsa.getExportedServices()) {
            sRef = eRef.getExportedService();
            if (sRef == null || (Long)sRef.getProperty("service.id") != serviceId) continue;
            ref = sRef;
            break;
        }
        if (ref == null) {
            for (ImportReference iRef : rsa.getImportedEndpoints()) {
                sRef = iRef.getImportedService();
                if (sRef == null || (Long)sRef.getProperty("service.id") != serviceId) continue;
                ref = sRef;
                break;
            }
            return ref == null ? 0 : 2;
        }
        return ref == null ? 0 : 1;
    }

    protected FrameworkMTO createFrameworkMTO() {
        List<BundleMTO> bundleMTOs = this.selectAndMap(this.getAllBundles(), null, b -> BundleMTO.createMTO((Bundle)b));
        FrameworkDTO frameworkDTO = this.getFrameworkDTO();
        List<ServiceReferenceMTO> srMTOs = this.selectAndMap(frameworkDTO.services, null, srDTO -> ServiceReferenceMTO.createMTO((ServiceReferenceDTO)srDTO, (int)this.getServiceReferenceExportImportState(srDTO.id)));
        return new FrameworkMTO(bundleMTOs.toArray(new BundleMTO[bundleMTOs.size()]), frameworkDTO.properties, srMTOs.toArray(new ServiceReferenceMTO[srMTOs.size()]));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = this.getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

