/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.remoteservice.AbstractRemoteService;
import org.eclipse.ecf.remoteservice.IRegistrationListener;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.RemoteServiceFilterImpl;
import org.eclipse.ecf.remoteservice.RemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.RemoteServiceRegistryImpl;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.ecf.remoteservice.util.RemoteFilterImpl;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteServiceContainerAdapterImpl
implements IRemoteServiceContainerAdapter {
    private IExecutor executor;
    private IContainer container;
    private IRemoteServiceCallPolicy remoteServiceCallPolicy;
    private IConnectContext connectContext;
    protected RemoteServiceRegistryImpl registry;
    protected final List<IRemoteServiceListener> listeners;
    protected final Map<IRemoteServiceReference, List<AbstractRemoteService>> refToImplMap;

    public RemoteServiceContainerAdapterImpl(IContainer container, IExecutor executor) {
        Assert.isNotNull((Object)container);
        this.container = container;
        this.listeners = new ArrayList<IRemoteServiceListener>();
        this.refToImplMap = new HashMap<IRemoteServiceReference, List<AbstractRemoteService>>();
        this.setRegistry(new RemoteServiceRegistryImpl());
        this.setExecutor(executor);
    }

    public RemoteServiceContainerAdapterImpl(IContainer container) {
        this(container, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.refToImplMap;
        synchronized (object) {
            this.refToImplMap.clear();
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
        if (this.registry != null) {
            this.registry.unpublishServices();
            this.registry = null;
        }
        this.connectContext = null;
        this.remoteServiceCallPolicy = null;
        this.container = null;
        this.executor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteServiceListener(IRemoteServiceListener listener) {
        List<IRemoteServiceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        List<IRemoteServiceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        this.remoteServiceCallPolicy = policy;
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        Trace.entering((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/entering", this.getClass(), (String)"registerRemoteService", (Object[])new Object[]{clazzes, service, properties});
        if (service == null) {
            throw new NullPointerException("service cannot be null");
        }
        int size = clazzes.length;
        if (size == 0) {
            throw new IllegalArgumentException("service classes list is empty");
        }
        String[] copy = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            copy[i] = new String(clazzes[i].getBytes());
            ++i;
        }
        clazzes = copy;
        String invalidService = RemoteServiceContainerAdapterImpl.checkServiceClass(clazzes, service);
        if (invalidService != null) {
            throw new IllegalArgumentException("Service=" + invalidService + " is invalid");
        }
        RemoteServiceRegistryImpl reg = this.getRegistry();
        if (reg == null) {
            throw new NullPointerException("registry cannot be null");
        }
        RemoteServiceRegistrationImpl registration = this.createRegistration();
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.registry;
        synchronized (remoteServiceRegistryImpl) {
            registration.publish(reg, service, clazzes, properties);
        }
        this.fireRemoteServiceListeners(this.createRegisteredEvent(registration));
        Trace.exiting((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/exiting", this.getClass(), (String)"registerRemoteService", (Object)registration);
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        Trace.entering((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/entering", this.getClass(), (String)"getRemoteServiceReferences", (Object[])new Object[]{target, idFilter, clazz, filter});
        RemoteServiceRegistryImpl reg = this.getRegistry();
        if (reg == null) {
            return null;
        }
        if (target != null) {
            this.connectToRemoteServiceTarget(target);
        }
        RemoteFilterImpl remoteFilter = filter == null ? null : new RemoteFilterImpl(filter);
        ID localContainerID = this.getLocalContainerID();
        ArrayList<IRemoteServiceReference> references = new ArrayList<IRemoteServiceReference>();
        if (idFilter == null || Arrays.asList(idFilter).contains(localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = reg;
            synchronized (remoteServiceRegistryImpl) {
                IRemoteServiceReference[] rs = this.registry.lookupServiceReferences(clazz, remoteFilter);
                if (rs != null) {
                    int j = 0;
                    while (j < rs.length) {
                        references.add(rs[j]);
                        ++j;
                    }
                }
            }
        }
        IRemoteServiceReference[] result = references.toArray(new IRemoteServiceReference[references.size()]);
        Trace.exiting((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/exiting", this.getClass(), (String)"getRemoteServiceReferences", (Object)result);
        return result.length == 0 ? null : result;
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final ID[] idFilter, final String clazz, final String filter) {
        IExecutor exec = this.getExecutor();
        if (exec == null) {
            throw new NullPointerException("Executor is null.  Cannot asynchronously get remote service references");
        }
        return exec.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceContainerAdapterImpl.this.getRemoteServiceReferences(target, idFilter, clazz, filter);
            }
        }, null);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        try {
            return this.getRemoteServiceReferences(null, idFilter, clazz, filter);
        }
        catch (ContainerConnectException containerConnectException) {
            return null;
        }
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.getRemoteServiceReferences(target, null, clazz, filter);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID[] idFilter, final String clazz, final String filter) {
        IExecutor exec = this.getExecutor();
        if (exec == null) {
            throw new NullPointerException("Executor is null.  Cannot asynchronously get remote service references");
        }
        return this.executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceContainerAdapterImpl.this.getRemoteServiceReferences(idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final String clazz, final String filter) {
        IExecutor exec = this.getExecutor();
        if (exec == null) {
            throw new NullPointerException("Executor is null.  Cannot asynchronously get remote service references");
        }
        return this.executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceContainerAdapterImpl.this.getRemoteServiceReferences(target, clazz, filter);
            }
        }, null);
    }

    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        IRemoteServiceReference[] result = this.getRemoteServiceReferences((ID[])null, clazz, filter);
        if (result == null) {
            return null;
        }
        return result.length == 0 ? null : result;
    }

    public Namespace getRemoteServiceNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.remoteservice");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceID getRemoteServiceID(ID containerID, long containerRelativeID) {
        if (containerID == null) {
            return null;
        }
        RemoteServiceRegistryImpl reg = this.getRegistry();
        if (reg == null) {
            return null;
        }
        ID localContainerID = this.getLocalContainerID();
        if (containerID.equals((Object)localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = reg;
            synchronized (remoteServiceRegistryImpl) {
                RemoteServiceRegistrationImpl registration = reg.findRegistrationForServiceId(containerRelativeID);
                if (registration != null) {
                    return registration.getID();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceID) {
        ID containerID = serviceID.getContainerID();
        if (containerID == null) {
            return null;
        }
        RemoteServiceRegistryImpl reg = this.getRegistry();
        if (reg == null) {
            return null;
        }
        RemoteServiceRegistrationImpl registration = null;
        ID localContainerID = this.getLocalContainerID();
        if (containerID.equals((Object)localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = reg;
            synchronized (remoteServiceRegistryImpl) {
                registration = reg.findRegistrationForServiceId(serviceID.getContainerRelativeID());
                if (registration != null) {
                    return registration.getReference();
                }
            }
        }
        return registration == null ? null : registration.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Trace.entering((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/entering", this.getClass(), (String)"getRemoteService", (Object)reference);
        RemoteServiceRegistrationImpl registration = this.getRemoteServiceRegistrationImpl(reference);
        if (registration == null) {
            return null;
        }
        AbstractRemoteService remoteService = this.createRemoteService(registration);
        if (remoteService == null) {
            return null;
        }
        Map<IRemoteServiceReference, List<AbstractRemoteService>> map = this.refToImplMap;
        synchronized (map) {
            List<AbstractRemoteService> remoteServiceImplList = this.refToImplMap.get(reference);
            if (remoteServiceImplList == null) {
                remoteServiceImplList = new ArrayList<AbstractRemoteService>();
            }
            remoteServiceImplList.add(remoteService);
            this.refToImplMap.put(reference, remoteServiceImplList);
        }
        Trace.exiting((String)"org.eclipse.ecf.remoteservice", (String)"org.eclipse.ecf.remoteservice/debug/methods/exiting", this.getClass(), (String)"getRemoteService", (Object)remoteService);
        return remoteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetRemoteService(IRemoteServiceReference ref) {
        if (ref == null) {
            return false;
        }
        IRemoteServiceID serviceID = ref.getID();
        if (serviceID == null) {
            return false;
        }
        Map<IRemoteServiceReference, List<AbstractRemoteService>> map = this.refToImplMap;
        synchronized (map) {
            block8: {
                List<AbstractRemoteService> remoteServiceImplList = this.refToImplMap.remove(ref);
                if (remoteServiceImplList == null) break block8;
                Iterator<AbstractRemoteService> i = remoteServiceImplList.iterator();
                while (i.hasNext()) {
                    AbstractRemoteService rsImpl = i.next();
                    if (rsImpl != null) {
                        rsImpl.dispose();
                    }
                    i.remove();
                }
                return true;
            }
        }
        return false;
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return new RemoteServiceFilterImpl(filter);
    }

    protected IRemoteServiceCallPolicy getRemoteServiceCallPolicy() {
        return this.remoteServiceCallPolicy;
    }

    protected IConnectContext getConnectContext() {
        return this.connectContext;
    }

    protected void setExecutor(IExecutor executor) {
        this.executor = executor;
    }

    protected IExecutor getExecutor() {
        return this.executor;
    }

    protected IContainer getContainer() {
        return this.container;
    }

    protected ID getLocalContainerID() {
        return this.getContainer().getID();
    }

    protected RemoteServiceRegistryImpl getRegistry() {
        return this.registry;
    }

    protected void setRegistry(RemoteServiceRegistryImpl registry) {
        this.registry = registry;
    }

    protected AbstractRemoteService createRemoteService(RemoteServiceRegistrationImpl registration) {
        return null;
    }

    protected IRemoteServiceRegisteredEvent createRegisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceRegisteredEvent(){

            public ID getLocalContainerID() {
                return RemoteServiceContainerAdapterImpl.this.getLocalContainerID();
            }

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceRegisteredEvent[");
                buf.append("localContainerID=").append(this.getLocalContainerID());
                buf.append(";containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceListeners(IRemoteServiceEvent event) {
        ArrayList<IRemoteServiceListener> entries;
        List<IRemoteServiceListener> list = this.listeners;
        synchronized (list) {
            entries = new ArrayList<IRemoteServiceListener>(this.listeners);
        }
        for (IRemoteServiceListener l : entries) {
            l.handleServiceEvent(event);
        }
    }

    protected RemoteServiceRegistrationImpl createRegistration() {
        return new RemoteServiceRegistrationImpl(new IRegistrationListener(){

            public void unregister(RemoteServiceRegistrationImpl registration) {
                RemoteServiceContainerAdapterImpl.this.handleServiceUnregister(registration);
            }
        });
    }

    protected IRemoteServiceUnregisteredEvent createUnregisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceUnregisteredEvent(){

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getLocalContainerID() {
                return RemoteServiceContainerAdapterImpl.this.getLocalContainerID();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceUnregisteredEvent[");
                buf.append("localContainerID=").append(this.getLocalContainerID());
                buf.append(";containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    protected void handleServiceUnregister(RemoteServiceRegistrationImpl registration) {
        this.fireRemoteServiceListeners(this.createUnregisteredEvent(registration));
    }

    protected RemoteServiceRegistrationImpl getRemoteServiceRegistrationImpl(IRemoteServiceReference reference) {
        if (reference instanceof RemoteServiceReferenceImpl) {
            RemoteServiceReferenceImpl ref = (RemoteServiceReferenceImpl)reference;
            if (!ref.isActive()) {
                return null;
            }
            return ref.getRegistration();
        }
        return null;
    }

    protected void connectToRemoteServiceTarget(ID target) throws ContainerConnectException {
    }

    protected static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        while (i < clazzes.length) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!RemoteServiceContainerAdapterImpl.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!RemoteServiceContainerAdapterImpl.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || RemoteServiceContainerAdapterImpl.extensiveCheckServiceClass(clazz, superClazz);
    }
}

