/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class TopologyManagerImpl
extends AbstractTopologyManager
implements EndpointEventListener {
    public static final int STARTUP_WAIT_TIME = Integer.getInteger("org.eclipse.ecf.osgi.services.remoteserviceadmin.startupWaitTime", 20000);

    public TopologyManagerImpl(BundleContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFrameworkUUID() {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String result = this.getContext().getProperty("org.osgi.framework.uuid");
            if (result == null) {
                UUID newUUID = UUID.randomUUID();
                result = newUUID.toString();
                System.setProperty("org.osgi.framework.uuid", newUUID.toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    protected void handleEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleECFEndpointAdded((EndpointDescription)endpoint);
    }

    protected void handleEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleECFEndpointRemoved((EndpointDescription)endpoint);
    }

    protected void handleEvent(ServiceEvent event, Map listeners) {
        super.handleEvent(event, listeners);
    }

    protected void handleRemoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        RemoteServiceAdmin.RemoteServiceAdminEvent rsaEvent = (RemoteServiceAdmin.RemoteServiceAdminEvent)event;
        int eventType = event.getType();
        EndpointDescription endpointDescription = rsaEvent.getEndpointDescription();
        switch (eventType) {
            case 2: {
                this.advertiseEndpointDescription(endpointDescription);
                break;
            }
            case 3: {
                this.unadvertiseEndpointDescription(endpointDescription);
                break;
            }
            case 6: {
                this.logError("handleRemoteAdminEvent.EXPORT_ERROR", "Export error with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 7: {
                this.logWarning("handleRemoteAdminEvent.EXPORT_WARNING", "Export warning with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 10: {
                this.advertiseModifyEndpointDescription(endpointDescription);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.logError("handleRemoteAdminEvent.IMPORT_ERROR", "Import error with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 8: {
                this.logWarning("handleRemoteAdminEvent.IMPORT_WARNING", "Import warning with event=" + (Object)((Object)rsaEvent));
                break;
            }
            default: {
                this.logWarning("handleRemoteAdminEvent", "RemoteServiceAdminEvent=" + (Object)((Object)rsaEvent) + " received with unrecognized type");
            }
        }
    }

    public void endpointChanged(EndpointEvent event, String matchedFilter) {
        int eventType = event.getType();
        org.osgi.service.remoteserviceadmin.EndpointDescription ed = event.getEndpoint();
        switch (eventType) {
            case 1: {
                this.handleEndpointAdded(ed, matchedFilter);
                break;
            }
            case 2: {
                this.handleEndpointRemoved(ed, matchedFilter);
                break;
            }
            case 4: {
                this.handleEndpointModified(ed, matchedFilter);
                break;
            }
            case 8: {
                this.handleEndpointModifiedEndmatch(ed, matchedFilter);
            }
        }
    }

    protected void handleEndpointModifiedEndmatch(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected void handleEndpointModified(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleECFEndpointModified((EndpointDescription)endpoint);
    }

    protected void exportRegisteredServices(final String exportRegisteredSvcsFilter) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    final CountDownLatch latch = new CountDownLatch(1);
                    BundleTracker bt = new BundleTracker(TopologyManagerImpl.this.getContext(), 47, new BundleTrackerCustomizer(){

                        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                            if (bundle.getSymbolicName().equals("org.eclipse.ecf.osgi.services.remoteserviceadmin")) {
                                if (bundle.getState() == 32) {
                                    latch.countDown();
                                    return null;
                                }
                                return bundle;
                            }
                            return null;
                        }

                        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
                            if (event.getType() == 2) {
                                latch.countDown();
                            }
                        }

                        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
                        }
                    });
                    bt.open();
                    if (!latch.await(STARTUP_WAIT_TIME, TimeUnit.MILLISECONDS)) {
                        bt.close();
                        throw new TimeoutException("RemoteServiceAdmin did not become active in " + STARTUP_WAIT_TIME + "ms");
                    }
                    bt.close();
                    ServiceReference[] existingServiceRefs = TopologyManagerImpl.this.getContext().getAllServiceReferences(null, exportRegisteredSvcsFilter);
                    if (existingServiceRefs != null && existingServiceRefs.length > 0) {
                        int i = 0;
                        while (i < existingServiceRefs.length) {
                            TopologyManagerImpl.this.handleServiceRegistering(existingServiceRefs[i]);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    TopologyManagerImpl.this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
                }
            }
        }, "BasicTopologyManagerPreRegSrvExporter").start();
    }
}

