/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.view;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.table.filters.TableFilter;
import org.polarsys.reqcycle.traceability.table.model.LinkRow;
import org.polarsys.reqcycle.traceability.table.model.TableController;
import org.polarsys.reqcycle.traceability.table.providers.LinkLabelProvider;
import org.polarsys.reqcycle.traceability.table.providers.TraceabilityLazyContentProvider;
import org.polarsys.reqcycle.traceability.types.ui.IStylePredicateProvider;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.traceability.ui.services.ILocateService;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityTableView
extends ViewPart {
    private static final Logger LOG = Logger.getLogger(TraceabilityTableView.class.getName());
    private static final String VIEW_ID = "org.polarsys.reqcycle.traceability.table.partdescriptor.traceability.table";
    @Inject
    protected ITraceabilityEngine engine;
    @Inject
    protected IStylePredicateProvider styleProvider;
    protected TableViewer viewer;
    protected TableController tableControl;
    protected Text filterText;
    protected Refresher refresher = new Refresher();
    private ILocateService locateService = (ILocateService)ZigguratInject.make(ILocateService.class);
    private IReachableManager managerService = (IReachableManager)ZigguratInject.make(IReachableManager.class);

    public TraceabilityTableView() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    @Inject
    void reactOnNewTraceaLinkCreation(@Optional @UIEventTopic(value="TOPIC_REQCYCLE_TRACEABILITY/NEW") Reachable object) {
        this.refresher.scheduleRefresh();
    }

    @Inject
    void reactOnTraceaLinkRemoval(@Optional @UIEventTopic(value="TOPIC_REQCYCLE_TRACEABILITY/REMOVE") Reachable object) {
        this.refresher.scheduleRefresh();
    }

    @Inject
    void reactOnTraceabilityFileChanges(@Optional @UIEventTopic(value="TOPIC_REQCYCLE_TRACEABILITY/SAVE") Reachable object) {
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.filterText = new Text(composite, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.viewer = new TableViewer(composite, 268503810);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        TraceabilityLazyContentProvider<LinkRow> provider = TraceabilityLazyContentProvider.create(LinkRow.class, this.viewer);
        this.viewer.setContentProvider(provider);
        this.tableControl = new TableController(this.viewer);
        ZigguratInject.inject((Object[])new Object[]{this.tableControl});
        this.viewer.setUseHashlookup(true);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createModel();
        this.hookMenu(table);
        this.hookActions();
        this.hookListeners();
        this.tableControl.displayAllLinks();
    }

    private void hookListeners() {
        TableFilter filter = new TableFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.filterText.addModifyListener((ModifyListener)new ModifyListenerImplementation(filter));
    }

    private void hookMenu(Table table) {
        MenuManager popupMenu = new MenuManager(null, VIEW_ID);
        Menu menu = popupMenu.createContextMenu((Control)table);
        table.setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(popupMenu, (ISelectionProvider)this.viewer);
        popupMenu.add((IAction)new Action("Show Properties view", ResourceManager.getPluginImageDescriptor((String)"org.polarsys.reqcycle.traceability.table", (String)"icons/properties-1.gif")){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void createModel() {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        this.addDoubleClickListener(viewerColumn);
        this.createTableViewerColumn(viewerColumn, "Link type", 50, 0).setLabelProvider((CellLabelProvider)new LinkLabelProvider(this.styleProvider){

            public String getText(Object element) {
                if (element instanceof LinkRow) {
                    LinkRow lr = (LinkRow)element;
                    TType kind = lr.getLink().getKind();
                    StringBuilder builder = new StringBuilder(kind.getLabel());
                    TType superKind = kind.getSuperType();
                    if (superKind != null) {
                        builder.append(String.format(" [Transverse : %s]", superKind.getLabel()));
                    }
                    return builder.toString();
                }
                return super.getText(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        this.createTableViewerColumn(viewerColumn, "Upstream", 200, 1).setLabelProvider((CellLabelProvider)new LinkLabelProvider(this.styleProvider){

            public String getText(Object element) {
                LinkRow lr;
                Set set;
                if (element instanceof LinkRow && (set = (lr = (LinkRow)element).getLink().getSources()) != null && set.size() >= 1) {
                    Reachable reachable = (Reachable)Iterables.get((Iterable)set, (int)0);
                    return TraceabilityUtils.getText((Reachable)reachable);
                }
                return super.getText(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        this.createTableViewerColumn(viewerColumn, "Downstream", 200, 2).setLabelProvider((CellLabelProvider)new LinkLabelProvider(this.styleProvider){

            public String getText(Object element) {
                LinkRow lr;
                Set set;
                if (element instanceof LinkRow && (set = (lr = (LinkRow)element).getLink().getTargets()) != null && set.size() >= 1) {
                    Reachable reachable = (Reachable)Iterables.get((Iterable)set, (int)0);
                    return TraceabilityUtils.getText((Reachable)reachable);
                }
                return super.getText(element);
            }
        });
    }

    private void addDoubleClickListener(TableViewerColumn viewerColumn) {
        final ArrayList index = Lists.newArrayList();
        viewerColumn.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object firstElement;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!index.isEmpty() && (firstElement = selection.getFirstElement()) instanceof LinkRow) {
                        Link link = ((LinkRow)firstElement).getLink();
                        switch ((Integer)index.get(0)) {
                            case 0: {
                                link.getId();
                                index.clear();
                                break;
                            }
                            case 1: {
                                TraceabilityTableView.this.setSelection(link.getSources());
                                index.clear();
                                break;
                            }
                            case 2: {
                                TraceabilityTableView.this.setSelection(link.getTargets());
                                index.clear();
                                break;
                            }
                        }
                    }
                }
            }
        });
        this.viewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = TraceabilityTableView.this.viewer.getTable().getItem(pt);
                if (item == null) {
                    return;
                }
                int i = 0;
                while (i < 3) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        index.clear();
                        index.add(i);
                    }
                    ++i;
                }
            }
        });
    }

    private void setSelection(Set<Reachable> reachables) {
        ArrayList reqsToSelect = Lists.newArrayList();
        ArrayList otherObjectsToSelect = Lists.newArrayList();
        for (Reachable source : reachables) {
            if ("reqcycle".equals(source.getScheme())) {
                reqsToSelect.add(source);
                continue;
            }
            otherObjectsToSelect.add(source);
        }
        if (!reqsToSelect.isEmpty()) {
            IWorkbenchPart view;
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.reqcycle.repository.ui.views.requirements");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            IViewReference viewRef = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("org.polarsys.reqcycle.repository.ui.views.requirements");
            if (viewRef != null && (view = viewRef.getPart(false)) != null) {
                Viewer reqViewer = (Viewer)view.getAdapter(Viewer.class);
                reqViewer.setSelection((ISelection)new StructuredSelection((List)reqsToSelect), true);
            }
        }
        if (!otherObjectsToSelect.isEmpty()) {
            for (Reachable obj : otherObjectsToSelect) {
                try {
                    this.locateService.open(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void hookActions() {
        IActionBars bars = ((PartSite)this.getSite()).getActionBars();
        RefreshAction refreshViewAction = new RefreshAction(this.refresher);
        bars.getToolBarManager().add((IAction)refreshViewAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private TableViewerColumn createTableViewerColumn(TableViewerColumn viewerColumn, String title, int bound, int colNumber) {
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    public TableController getController() {
        return this.tableControl;
    }

    private final class ModifyListenerImplementation
    implements ModifyListener {
        Timer t = new Timer();
        TimerTask tt;
        TableFilter filter;

        ModifyListenerImplementation(TableFilter filter) {
            this.filter = filter;
        }

        public void modifyText(ModifyEvent e) {
            if (this.tt != null) {
                this.tt.cancel();
                this.t.purge();
                this.tt = null;
            }
            this.tt = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String searchText = ((ModifyListenerImplementation)(this).ModifyListenerImplementation.this).TraceabilityTableView.this.filterText.getText();
                            (this).ModifyListenerImplementation.this.filter.setSearchText(searchText);
                            ((ModifyListenerImplementation)(this).ModifyListenerImplementation.this).TraceabilityTableView.this.tableControl.refreshViewerData();
                            ((ModifyListenerImplementation)(this).ModifyListenerImplementation.this).TraceabilityTableView.this.tableControl.refreshViewerVisuals();
                        }
                    });
                }
            };
            this.t.schedule(this.tt, 800L);
        }
    }

    private final class RefreshAction
    extends Action {
        private Refresher refresher;

        public RefreshAction(Refresher refresher) {
            this.refresher = refresher;
            this.setText("Refresh");
            this.setToolTipText("Refresh Links list");
        }

        public void run() {
            this.refresher.scheduleRefresh();
        }
    }

    private final class Refresher {
        Timer t = new Timer();
        TimerTask tt;

        private Refresher() {
        }

        public void scheduleRefresh() {
            if (this.tt != null) {
                this.tt.cancel();
                this.t.purge();
                this.tt = null;
            }
            this.tt = new TimerTask(){

                @Override
                public void run() {
                    Shell shell;
                    IWorkbenchPartSite site = TraceabilityTableView.this.getSite();
                    if (site != null && (shell = site.getShell()) != null) {
                        Display display = shell.getDisplay();
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((Refresher)(this).Refresher.this).TraceabilityTableView.this.tableControl.refreshViewerData();
                                ((Refresher)(this).Refresher.this).TraceabilityTableView.this.tableControl.refreshViewerVisuals();
                            }
                        });
                    }
                }
            };
            this.t.schedule(this.tt, 1000L);
        }
    }
}

