/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.operations.traceability;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.polarsys.reqcycle.operations.IOperation;
import org.polarsys.reqcycle.operations.IParameter;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Filter;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.LinkState;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IBusinessObject;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityOperations {
    @Inject
    ITraceabilityEngine engine;
    @Inject
    IReachableManager manager;
    @Inject
    ITraceabilityAttributesManager traceabilityAttributesManager;

    public TraceabilityOperations() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    @IOperation(value="Is the current requirement has broken traceability links")
    public IOperation.Result<Boolean> hasBrokenLinks(Requirement req, @IParameter(value="Downstream analysis") Boolean downstream, @IParameter(value="Upstream analysis") Boolean upstream) {
        final List<Link> brokenLinks = this.getBrokenLinks(req, downstream, upstream);
        return new IOperation.Result<Boolean>(){

            public Collection<Object> getObjectsToListen() {
                ArrayList result = Lists.newArrayList();
                for (Link l : brokenLinks) {
                    result.add(l.getTargets().iterator().next());
                }
                return result;
            }

            public Boolean getResult() {
                if (brokenLinks.size() > 0) {
                    return true;
                }
                return false;
            }

            public Class<Boolean> getResultType() {
                return Boolean.class;
            }
        };
    }

    public List<Link> getBrokenLinks(Requirement req, boolean downstream, boolean upstream) {
        ArrayList result = Lists.newArrayList();
        if (upstream) {
            Iterator<Pair<Link, Reachable>> upwardTraceability = this.getTraceability(req, ITraceabilityEngine.DIRECTION.UPWARD, Request.DEPTH.ONE, null);
            result.addAll(this.getBrokenLinks(upwardTraceability));
        }
        if (downstream) {
            Iterator<Pair<Link, Reachable>> downwardTraceability = this.getTraceability(req, ITraceabilityEngine.DIRECTION.DOWNWARD, Request.DEPTH.ONE, null);
            result.addAll(this.getBrokenLinks(downwardTraceability));
        }
        return result;
    }

    public Collection<? extends Link> getBrokenLinks(Iterator<Pair<Link, Reachable>> traceability) {
        ArrayList result = Lists.newArrayList();
        while (traceability.hasNext()) {
            Pair<Link, Reachable> pair = traceability.next();
            Link l = (Link)pair.getFirst();
            for (Reachable r : l.getTargets()) {
                try {
                    ReachableObject object = this.manager.getHandlerFromReachable(r).getFromReachable(r);
                    IBusinessObject bO = (IBusinessObject)object.getAdapter(IBusinessObject.class);
                    if (bO == null || bO.exists()) continue;
                    result.add(l);
                }
                catch (IReachableHandlerException iReachableHandlerException) {}
            }
        }
        return result;
    }

    public Iterator<Pair<Link, Reachable>> getTraceability(Requirement req, ITraceabilityEngine.DIRECTION direction, Request.DEPTH depth, Filter filter) {
        try {
            Request request = this.getTraceabilityRequest(req, direction, depth, filter);
            try {
                return this.engine.getTraceability(new Request[]{request});
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        }
        catch (IReachableHandlerException e1) {
            e1.printStackTrace();
        }
        return Iterators.emptyIterator();
    }

    private Request getTraceabilityRequest(Requirement req, ITraceabilityEngine.DIRECTION direction, Request.DEPTH depth, Filter filter) throws IReachableHandlerException {
        Request request = new Request().setDepth(depth).setDirection(direction);
        if (filter != null) {
            request.setFilter(filter);
        }
        request.setScope(Scopes.getWorkspaceScope());
        request.addSource(this.manager.getHandlerFromObject((Object)req).getFromObject((Object)req).getReachable());
        return request;
    }

    @IOperation(value="Is the current requirement traced downward")
    public IOperation.Result<Boolean> isTracedDownward(Requirement req, @IParameter(value="traceability type") String traceabilityType) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.DOWNWARD, traceabilityType, null, null);
    }

    @IOperation(value="Is the current requirement traced upward")
    public IOperation.Result<Boolean> isTracedUpward(Requirement req, @IParameter(value="traceability type") String traceabilityType) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.UPWARD, traceabilityType, null, null);
    }

    @IOperation(value="Is the current requirement traced downward with given link state")
    public IOperation.Result<Boolean> isTracedDownwardWithLinkState(Requirement req, @IParameter(value="traceability type") String traceabilityType, @IParameter(value="traceability state") String traceabilityState) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.DOWNWARD, traceabilityType, "state", traceabilityState);
    }

    @IOperation(value="Is the current requirement traced upward with given link state")
    public IOperation.Result<Boolean> isTracedUpwardWithLinkState(Requirement req, @IParameter(value="traceability type") String traceabilityType, @IParameter(value="traceability state") String traceabilityState) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.UPWARD, traceabilityType, "state", traceabilityState);
    }

    @IOperation(value="Is the current requirement traced downard with given link attribute value")
    public IOperation.Result<Boolean> isTracedDownwardWithLinkAttributeValue(Requirement req, @IParameter(value="traceability type") String traceabilityType, @IParameter(value="traceability attribute") String traceabilityAttribute, @IParameter(value="traceability attribute value") String traceabilityAttributeValue) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.DOWNWARD, traceabilityType, traceabilityAttribute, traceabilityAttributeValue);
    }

    @IOperation(value="Is the current requirement traced upward with given link attribute value")
    public IOperation.Result<Boolean> isTracedUpwardWithLinkAttributeValue(Requirement req, @IParameter(value="traceability type") String traceabilityType, @IParameter(value="traceability attribute") String traceabilityAttribute, @IParameter(value="traceability attribute value") String traceabilityAttributeValue) {
        return this.isReqTracedWithLinkAttributeValue(req, ITraceabilityEngine.DIRECTION.UPWARD, traceabilityType, traceabilityAttribute, traceabilityAttributeValue);
    }

    private IOperation.Result<Boolean> isReqTracedWithLinkAttributeValue(Requirement req, ITraceabilityEngine.DIRECTION direction, final String traceabilityType, final String traceabilityAttribute, final String traceabilityAttributeValue) {
        final HashSet objectsToListen = Sets.newHashSet();
        objectsToListen.add(req);
        Filter f = new Filter(){

            public boolean apply(Pair<Link, Reachable> pair) {
                boolean noTraceabilityGiven = traceabilityType == null || traceabilityType.length() == 0;
                boolean matchesTraceabilityLink = ((Link)pair.getFirst()).getKind().getLabel().equals(traceabilityType);
                if (noTraceabilityGiven) {
                    return false;
                }
                if (!matchesTraceabilityLink) {
                    return false;
                }
                if (traceabilityAttribute == null || traceabilityAttribute.length() == 0) {
                    return true;
                }
                if (traceabilityAttribute.equals("state")) {
                    return ((Link)pair.getFirst()).getState().equals((Object)LinkState.valueOf((String)traceabilityAttributeValue));
                }
                ImmutableMap attributes = Maps.uniqueIndex((Iterable)TraceabilityOperations.this.traceabilityAttributesManager.getAttributes(((Link)pair.getFirst()).getId()), (Function)new Function<ITraceabilityAttributesManager.EditableAttribute, String>(){

                    public String apply(ITraceabilityAttributesManager.EditableAttribute arg0) {
                        return arg0.getName();
                    }
                });
                for (Map.Entry att : attributes.entrySet()) {
                    Object attValue = ((ITraceabilityAttributesManager.EditableAttribute)att.getValue()).getValue();
                    if (!((String)att.getKey()).equals(traceabilityAttribute) || !(traceabilityAttributeValue == null || traceabilityAttributeValue.length() == 0 ? attValue == null || attValue.toString().length() == 0 : attValue.equals(traceabilityAttributeValue))) continue;
                    return true;
                }
                return false;
            }
        };
        ArrayList list = Lists.newArrayList(this.getTraceability(req, direction, Request.DEPTH.ONE, f));
        for (Pair p : list) {
            Reachable next = null;
            next = direction.equals((Object)ITraceabilityEngine.DIRECTION.DOWNWARD) ? (Reachable)((Link)p.getFirst()).getSources().iterator().next() : (Reachable)((Link)p.getFirst()).getTargets().iterator().next();
            objectsToListen.add(next);
            objectsToListen.add(p.getSecond());
            objectsToListen.add(((Link)p.getFirst()).getId());
        }
        final boolean cov = !list.isEmpty();
        return new IOperation.Result<Boolean>(){

            public Collection<Object> getObjectsToListen() {
                return objectsToListen;
            }

            public Boolean getResult() {
                return cov;
            }

            public Class<Boolean> getResultType() {
                return Boolean.class;
            }
        };
    }

    @IOperation(value="get the coverage rate the element (for a section)")
    public IOperation.Result<Float> getCoverageRate(Section selection, final @IParameter(value="traceability type") String traceabilityType, @IParameter(value="Workspace Scope") Boolean workspace) {
        if (selection instanceof Requirement) {
            return new IOperation.Result<Float>(){

                public Collection<Object> getObjectsToListen() {
                    return Lists.newArrayList();
                }

                public Float getResult() {
                    return Float.valueOf(0.0f);
                }

                public Class<Float> getResultType() {
                    return Float.class;
                }
            };
        }
        Iterable requirements = Iterables.filter((Iterable)selection.getChildren(), Requirement.class);
        final HashSet objectsToListen = Sets.newHashSet();
        try {
            Request request = new Request().setDepth(Request.DEPTH.ONE).setDirection(ITraceabilityEngine.DIRECTION.DOWNWARD).setFilter(new Filter(){

                public boolean apply(Pair<Link, Reachable> pair) {
                    return ((Link)pair.getFirst()).getKind().getLabel().equals(traceabilityType);
                }
            });
            if (workspace.booleanValue()) {
                request.setScope(Scopes.getWorkspaceScope());
            } else {
                request.setScope(Scopes.getProjectScope((IResource)WorkspaceSynchronizer.getFile((Resource)selection.eResource())));
            }
            for (Requirement r : requirements) {
                request.addSource(this.manager.getHandlerFromObject((Object)r).getFromObject((Object)r).getReachable());
                objectsToListen.add(r);
            }
            try {
                ArrayList list = Lists.newArrayList((Iterator)this.engine.getTraceability(new Request[]{request}));
                HashMap map = Maps.newHashMap();
                for (Pair p : list) {
                    Reachable next = (Reachable)((Link)p.getFirst()).getSources().iterator().next();
                    Integer i = (Integer)map.get(next);
                    if (i == null) {
                        map.put(next, 1);
                    } else {
                        i = i + 1;
                        map.put(next, i);
                    }
                    objectsToListen.add(next);
                    objectsToListen.add(p.getSecond());
                    objectsToListen.add(((Link)p.getFirst()).getId());
                }
                float total = Lists.newArrayList((Iterable)requirements).size();
                float nb = 0.0f;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null || (Integer)entry.getValue() <= 0) continue;
                    nb += 1.0f;
                }
                final float rate = nb / total * 100.0f;
                return new IOperation.Result<Float>(){

                    public Collection<Object> getObjectsToListen() {
                        return objectsToListen;
                    }

                    public Float getResult() {
                        return Float.valueOf(rate);
                    }

                    public Class<Float> getResultType() {
                        return Float.class;
                    }
                };
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        }
        catch (IReachableHandlerException e1) {
            e1.printStackTrace();
        }
        return new IOperation.Result<Float>(){

            public Collection<Object> getObjectsToListen() {
                return null;
            }

            public Float getResult() {
                return Float.valueOf(0.0f);
            }

            public Class<Float> getResultType() {
                return Float.class;
            }
        };
    }
}

