/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.AdvancedTikaHSSFListener;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.CellsGroup;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SpreadSheetElement;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.StylizedCell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRow;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRowScore;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.Table;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Doc2ModelExcelParser
extends AbstractParser {
    private static final long serialVersionUID = -167556379616415313L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-excel"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        NPOIFSFileSystem npoifs = new NPOIFSFileSystem(stream);
        AdvancedTikaHSSFListener formatListener = new AdvancedTikaHSSFListener(Locale.getDefault());
        List<SpreadSheetElement> spreadSheetElements = formatListener.processFile(npoifs, false);
        XHTMLContentHandler xhandler = new XHTMLContentHandler(handler, metadata);
        xhandler.startDocument();
        xhandler.startElement("div");
        for (SpreadSheetElement elt : spreadSheetElements) {
            if (!(elt instanceof Table)) continue;
            Table table = (Table)elt;
            xhandler.startElement("table");
            xhandler.startElement("tbody");
            SubRow mainHeader = table.getHeader();
            HashSet<Integer> headerSet = new HashSet<Integer>();
            for (CellsGroup header : mainHeader) {
                int column = header.getFirstColumn();
                Iterator<StylizedCell> iterator = header.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    headerSet.add(column);
                    ++column;
                }
            }
            HashMap<Integer, String> rowMap = new HashMap<Integer, String>();
            for (SubRow row : table) {
                SubRowScore ss = (SubRowScore)row;
                xhandler.startElement("tr");
                if (ss.getSubRowType() == SubRowScore.SubRowFunction.Header) {
                    for (StylizedCell c : ss.getCells()) {
                        xhandler.startElement("td");
                        xhandler.characters(c.getText());
                        xhandler.endElement("td");
                    }
                } else if (ss.getSubRowType() == SubRowScore.SubRowFunction.DataContent) {
                    for (CellsGroup cellgrp : ss) {
                        int column = cellgrp.getFirstColumn();
                        for (StylizedCell cell : cellgrp) {
                            rowMap.put(column, cell.getText());
                            ++column;
                        }
                    }
                    Iterator rowIter = rowMap.entrySet().iterator();
                    Integer lastCol = -1;
                    Integer nextCol = -1;
                    String lastValue = "";
                    if (rowIter.hasNext()) {
                        lastCol = (Integer)rowIter.next().getKey();
                        lastValue = (String)rowMap.get(lastCol);
                        if (rowIter.hasNext()) {
                            nextCol = (Integer)rowIter.next().getKey();
                        }
                        for (Integer col : headerSet) {
                            if (col.compareTo(lastCol) <= 0 || nextCol == -1 || col.compareTo(nextCol) >= 0) {
                                if (col.compareTo(nextCol) >= 0) {
                                    lastCol = nextCol;
                                    lastValue = (String)rowMap.get(nextCol);
                                    nextCol = rowIter.hasNext() ? (Integer)rowIter.next().getKey() : Integer.valueOf(-1);
                                } else if (nextCol != -1) {
                                    lastValue = (String)rowMap.get(lastCol);
                                }
                            }
                            xhandler.startElement("td");
                            xhandler.characters(lastValue);
                            xhandler.endElement("td");
                        }
                    }
                }
                xhandler.endElement("tr");
            }
            xhandler.endElement("tbody");
            xhandler.endElement("table");
        }
        xhandler.endElement("div");
    }
}

