/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.prefs.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.reqcycle.utils.configuration.Activator;

public class ReqcyclePrefsExportWizard
extends Wizard
implements IExportWizard {
    protected IPath outputPath;
    protected boolean includeReqSources = false;

    public void addPages() {
        this.addPage((IWizardPage)new WizardPage("Export ReqCycle preferences"){

            public void createControl(Composite parent) {
                this.setPageComplete(false);
                Composite mainComposite = new Composite(parent, 0);
                mainComposite.setLayout((Layout)new FillLayout(256));
                Composite topComposite = new Composite(mainComposite, 0);
                topComposite.setLayout((Layout)new GridLayout(1, false));
                Group topGroup = new Group(topComposite, 0);
                topGroup.setLayout((Layout)new GridLayout(3, false));
                topGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                topGroup.setText("Export Information");
                Label lblDestination = new Label((Composite)topGroup, 0);
                lblDestination.setText("Destination :");
                final Text textOutput = new Text((Composite)topGroup, 2048);
                textOutput.setEnabled(false);
                textOutput.setEditable(false);
                textOutput.setTouchEnabled(true);
                textOutput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                if (ReqcyclePrefsExportWizard.this.outputPath != null) {
                    textOutput.setText(ReqcyclePrefsExportWizard.this.outputPath.toString());
                }
                Button btnSaveAs = new Button((Composite)topGroup, 0);
                btnSaveAs.setText("Save As");
                btnSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Object[] paths;
                        ContainerSelectionDialog d = new ContainerSelectionDialog(this.getShell(), null, true, "Export preferences to folder :");
                        if (d.open() == 0 && (paths = d.getResult()).length > 0) {
                            (this).ReqcyclePrefsExportWizard.this.outputPath = (IPath)paths[0];
                            textOutput.setText((this).ReqcyclePrefsExportWizard.this.outputPath.toString());
                            this.setPageComplete(true);
                        }
                    }
                });
                final Button reqSourcesButton = new Button((Composite)topGroup, 32);
                reqSourcesButton.setText("Export requirement sources");
                reqSourcesButton.setSelection(ReqcyclePrefsExportWizard.this.includeReqSources);
                reqSourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ReqcyclePrefsExportWizard.this.includeReqSources = reqSourcesButton.getSelection();
                    }
                });
                this.setControl((Control)mainComposite);
            }
        });
    }

    public boolean performFinish() {
        IPath prefsFolderPath = Activator.getDefault().getStateLocation();
        File prefsFolder = new File(prefsFolderPath.toOSString());
        IResource outputFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(this.outputPath);
        if (outputFolder instanceof IContainer) {
            try {
                IFile outputZip = ((IContainer)outputFolder).getFile((IPath)new Path("reqcycle-conf.zip"));
                if (outputZip.exists()) {
                    outputZip.delete(true, null);
                }
                FileOutputStream out = new FileOutputStream(outputZip.getLocation().toOSString());
                ZipOutputStream zos = new ZipOutputStream(out);
                File[] fileArray = prefsFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if ((this.includeReqSources || !f.getName().startsWith("org.polarsys.reqcycle.repositories")) && f.isFile()) {
                        zos.putNextEntry(new ZipEntry(f.getName()));
                        FileInputStream is = new FileInputStream(f);
                        IOUtils.copy((InputStream)is, (OutputStream)zos);
                        ((InputStream)is).close();
                        zos.closeEntry();
                    }
                    ++n2;
                }
                zos.close();
                outputFolder.refreshLocal(1, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IContainer) {
            this.outputPath = ((IContainer)selection.getFirstElement()).getFullPath();
        }
    }
}

