/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.reqcycle.ocl.ui.SettingBean;
import org.polarsys.reqcycle.ocl.utils.OCLUtilities;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.IUpdatablePage;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IEnumerator;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.ocl.ZigguratOCLPlugin;

public class OCLPage
extends WizardPage
implements IChangeListener,
IUpdatablePage {
    private SettingBean bean;
    private TableViewer tvTypes;
    private Table tTypes;
    private TableViewerColumn tvcTypesNames;
    private TableViewerColumn tvcTypesTypes;
    private TableViewer tvAttributes;
    private Table tAttributes;
    private TableViewerColumn tvcAttributesNames;
    private TableViewerColumn tvcAttributesTypes;
    private Collection<IType> inputTypes = new ArrayList<IType>();
    private Collection<IAttribute> inputAttributes = new ArrayList<IAttribute>();
    protected IDataModel selectedModel;
    protected IRequirementType selectedType;
    private Text tFile;
    private Button browseButton;
    private BaseCSResource resource;
    private DataBindingContext bindingContext;
    protected static ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    };
    protected static ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            Object o;
            if (selection.length == 1 && (o = selection[0]) instanceof IFile && "ocl".equals(((IFile)o).getFileExtension())) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.polarsys.reqcycle.ocl", "Select a single OCL file");
        }
    };
    protected static ILabelProvider labelProvider = new WorkbenchLabelProvider(){

        public Color getForeground(Object element) {
            return Display.getDefault().getSystemColor(2);
        }

        public Color getBackground(Object element) {
            return Display.getDefault().getSystemColor(1);
        }
    };

    public OCLPage(SettingBean bean) {
        super("OCL queries");
        this.setDescription("An OCL file, from which operations will be used from model analysis, has to be provided. You can check whether all the operations needed by ReqCycle have been implemented, or if some are missing");
        this.setTitle("Connector OCL: Mapping page");
        this.bean = bean;
    }

    public void createControl(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout(3, false));
        Label fileLabel = new Label(containerComposite, 0);
        fileLabel.setText("Complete OCL file :");
        this.tFile = new Text(containerComposite, 2056);
        this.tFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tFile.setEnabled(false);
        this.browseButton = new Button(containerComposite, 0);
        this.browseButton.setText("Browse");
        Label lblSeparator = new Label(containerComposite, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.createTypesUi(containerComposite);
        this.createAttribuesUi(containerComposite);
        this.hookListeners();
        this.bindingContext = this.initDataBindings();
        AbstractSettingPage.observeBean((DataBindingContext)this.bindingContext, (IChangeListener)this);
        this.setControl((Control)containerComposite);
        if (this.bean.getDataModel() != null) {
            this.tvTypes.setInput((Object)this.bean.getDataModel().getTypes());
        }
    }

    private void createTypesUi(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0, false, false, 3, 1));
        label.setText("Requirement types");
        Composite viewerComposite = new Composite(parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumnLayout typesTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)typesTVLayout);
        this.tvTypes = new TableViewer(viewerComposite, 2048);
        this.tvTypes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tTypes = this.tvTypes.getTable();
        this.tTypes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tTypes.setHeaderVisible(true);
        this.tTypes.setLinesVisible(true);
        this.tvcTypesNames = this.createTableViewerColumn(this.tvTypes, "Name", 0);
        this.tvcTypesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRequirementType) {
                    return ((IRequirementType)element).getName();
                }
                return super.getText(element);
            }
        });
        typesTVLayout.setColumnData((Widget)this.tvcTypesNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvcTypesTypes = this.createTableViewerColumn(this.tvTypes, "Operation check", 0);
        this.tvcTypesTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRequirementType) {
                    if (OCLPage.this.resource == null) {
                        return "An ocl file has to be selected and must compile";
                    }
                    IStatus testPresentForDataType = OCLUtilities.isOperationPresent((IRequirementType)element, OCLPage.this.resource);
                    return testPresentForDataType.getMessage();
                }
                return "No need for an operation";
            }
        });
        typesTVLayout.setColumnData((Widget)this.tvcTypesTypes.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 200, true));
        this.updateDataTypes();
        this.tvTypes.setInput(this.inputTypes);
    }

    public boolean isPageComplete() {
        if (this.resource == null) {
            return false;
        }
        try {
            ZigguratOCLPlugin.compileOCL((BaseCSResource)this.resource);
        }
        catch (Exception e) {
            this.setErrorMessage("Could not compile ocl file : " + e.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void createAttribuesUi(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0, false, false, 3, 1));
        label.setText("Requirement attributes");
        Composite viewerComposite = new Composite(parent, 0);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumnLayout attributeTVLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)attributeTVLayout);
        this.tvAttributes = new TableViewer(viewerComposite);
        this.tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tAttributes = this.tvAttributes.getTable();
        this.tAttributes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tAttributes.setHeaderVisible(true);
        this.tAttributes.setLinesVisible(true);
        this.tvcAttributesNames = this.createTableViewerColumn(this.tvAttributes, "Name", 0);
        this.tvcAttributesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAttribute) {
                    return ((IAttribute)element).getName();
                }
                if (element instanceof IEnumerator) {
                    return ((IEnumerator)element).getName();
                }
                return super.getText(element);
            }
        });
        attributeTVLayout.setColumnData((Widget)this.tvcAttributesNames.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvcAttributesTypes = this.createTableViewerColumn(this.tvAttributes, "Operation check", 0);
        this.tvcAttributesTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAttribute) {
                    if (OCLPage.this.resource == null) {
                        return "An ocl file has to be selected and must compile";
                    }
                    IAttribute attribute = (IAttribute)element;
                    IStatus testPresentForDataType = OCLUtilities.isOperationPresent(attribute, OCLPage.this.resource);
                    return testPresentForDataType.getMessage();
                }
                if (element instanceof IEnumerator) {
                    return "-";
                }
                return super.getText(element);
            }
        });
        attributeTVLayout.setColumnData((Widget)this.tvcAttributesTypes.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        this.tvAttributes.setInput(this.inputAttributes);
    }

    public void hookListeners() {
        this.tvTypes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                OCLPage.this.inputAttributes.clear();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IRequirementType) {
                    OCLPage.this.selectedType = (IRequirementType)obj;
                    Collection attributes = OCLPage.this.selectedType.getAttributes();
                    Iterable filtered = Iterables.filter((Iterable)attributes, (Predicate)new Predicate<IAttribute>(){

                        public boolean apply(IAttribute arg0) {
                            return !(arg0 instanceof IAttribute) || !"uri".equals(arg0.getName());
                        }
                    });
                    Iterables.addAll((Collection)OCLPage.this.inputAttributes, (Iterable)filtered);
                }
                OCLPage.this.tvAttributes.refresh();
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
                WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(Display.getCurrent().getActiveShell(), labelProvider, (ITreeContentProvider)contentProvider);
                dialog.addFilter(filter);
                dialog.setAllowMultiple(false);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setValidator(validator);
                int open = dialog.open();
                if (open == 0) {
                    IFile iFile = dialog.getSelectedFiles()[0];
                    String location = iFile.getFullPath().toOSString();
                    URI oclURI = URI.createPlatformResourceURI((String)location, (boolean)true);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    OCLPage.this.resource = OCLUtilities.loadOCLResource((ResourceSet)resourceSet, oclURI);
                    OCLPage.this.tFile.setText(location);
                    OCLPage.this.tvTypes.refresh();
                    OCLPage.this.tvAttributes.refresh();
                    OCLPage.this.getWizard().getContainer().updateMessage();
                    OCLPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextFileURITextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.tFile);
        IObservableValue uriBeanObserveValue = PojoProperties.value((String)"oclUri").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeTextFileURITextObserveWidget, uriBeanObserveValue, null, null);
        return bindingContext;
    }

    public TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void updateDataTypes() {
        IDataModel dataPackage = this.bean.getDataModel();
        if (dataPackage != null) {
            Collection dataTypes = dataPackage.getTypes();
            this.inputTypes.clear();
            this.inputTypes.addAll(dataTypes);
        }
    }

    public void handleChange(ChangeEvent event) {
        this.bindingContext.updateModels();
        this.bindingContext.updateTargets();
        this.updateDataTypes();
        if (this.tvTypes != null) {
            this.tvTypes.refresh();
        }
        this.getWizard().getContainer().updateButtons();
        this.getWizard().getContainer().updateMessage();
    }

    public void hasChanged() {
        if (this.tvTypes != null) {
            if (this.bean.getDataModel() != null) {
                this.tvTypes.setInput((Object)this.bean.getDataModel().getTypes());
            } else {
                this.tvTypes.setInput((Object)Lists.newArrayList());
            }
        }
    }
}

