/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.ui.impl;

import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.RelationBasedType;
import org.polarsys.reqcycle.traceability.types.RelationUtils;
import org.polarsys.reqcycle.traceability.types.configuration.predicates.ReqCycleDynamicPackage;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.DecorationPredicate;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.RelationsPredicatesMapping;
import org.polarsys.reqcycle.traceability.types.ui.IStylePredicateProvider;

public class StylePredicateProvider
implements IStylePredicateProvider {
    @Inject
    ITypesConfigurationProvider provider;

    public <T> T getResourcetForRelation(Link link, IBehavior<T> behav) {
        Configuration defaultConfiguration = this.provider.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            return null;
        }
        if (!(link.getKind() instanceof RelationBasedType)) {
            return null;
        }
        Relation r = RelationUtils.getRelation((String)link.getKind().getLabel(), (Configuration)defaultConfiguration);
        if (r == null) {
            return null;
        }
        RelationsPredicatesMapping mapping = this.getMapping(r, defaultConfiguration);
        if (mapping == null) {
            return null;
        }
        EObject eobject = ReqCycleDynamicPackage.getEObject(link);
        for (DecorationPredicate p : mapping.getDecorations()) {
            if (!p.getPredicate().match((Object)eobject)) continue;
            return behav.handleRegistry(p);
        }
        return null;
    }

    private RelationsPredicatesMapping getMapping(Relation rel, Configuration conf) {
        for (RelationsPredicatesMapping m : conf.getParent().getMappings()) {
            if (m.getRelation() == null || !m.getRelation().equals(rel)) continue;
            return m;
        }
        return null;
    }

    @Override
    public Color getColorForRelation(Link link) {
        return this.getResourcetForRelation(link, new IBehavior<Color>(){

            @Override
            public Color handleRegistry(DecorationPredicate t) {
                Color result = JFaceResources.getColorRegistry().get(t.getColor());
                if (result == null) {
                    JFaceResources.getColorRegistry().put(t.getColor(), StringConverter.asRGB((String)t.getColor()));
                    result = JFaceResources.getColorRegistry().get(t.getColor());
                }
                return result;
            }
        });
    }

    @Override
    public Font getFontForRelation(Link link) {
        return this.getResourcetForRelation(link, new IBehavior<Font>(){

            @Override
            public Font handleRegistry(DecorationPredicate t) {
                Font result = JFaceResources.getFontRegistry().get(t.getStyle());
                if (result == null) {
                    JFaceResources.getFontRegistry().put(t.getStyle(), StringConverter.asFontDataArray((String)t.getStyle()));
                    result = JFaceResources.getFontRegistry().get(t.getStyle());
                }
                return result;
            }
        });
    }

    private static interface IBehavior<T> {
        public T handleRegistry(DecorationPredicate var1);
    }
}

