/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.providers;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.polarsys.reqcycle.predicates.core.IPredicateEvaluator;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.ui.providers.PredicatesItemProviderAdapterFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.CaseStyle;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.model.Styling.StylingPredicate;
import org.polarsys.reqcycle.styling.ui.dialogs.IconRegistry;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StylingLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
EventHandler,
IPredicateEvaluator.IRefresh {
    @Inject
    IStylingManager manager;
    @Inject
    IEventBroker broker;
    @Inject
    IReachableManager rManager;
    @Inject
    IPredicateEvaluator predicateEvaluator;
    private Collection<ILabelProviderListener> listeners = Lists.newArrayList();

    public StylingLabelProvider() {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.broker.subscribe("STYLINGTOPIC/LISTENER", (EventHandler)this);
        this.predicateEvaluator.addRefresh((IPredicateEvaluator.IRefresh)this);
    }

    public void notifyChanged(Object[] objects) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, objects));
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public String getText(Object element) {
        if (element instanceof IPredicate) {
            return ((IPredicate)element).getDisplayName();
        }
        if (element instanceof Scope) {
            return ((Scope)element).getName();
        }
        return this.getText(element, String.class);
    }

    protected StyledString applyStyle(Object element, CaseStyle styling) {
        return styling.getStyledString(element);
    }

    protected StylingModel getStylingModel() {
        String selectedModel = this.doGetModel();
        EList list = this.manager.getStyling().getModels();
        for (StylingModel styling : list) {
            if (!styling.getModeName().equals(selectedModel)) continue;
            return styling;
        }
        return null;
    }

    protected String doGetModel() {
        return this.manager.getPreferredStyleModel();
    }

    public Image getImage(Object object) {
        if (object instanceof IPredicate) {
            PredicatesItemProviderAdapterFactory factory = new PredicatesItemProviderAdapterFactory();
            return new AdapterFactoryLabelProvider((AdapterFactory)factory).getImage(object);
        }
        StylingModel model = this.getStylingModel();
        if (model != null) {
            EList list = model.getStyles();
            for (CaseStyle styling : list) {
                StylingPredicate sp = (StylingPredicate)styling;
                if (!this.predicateEvaluator.match(sp.getPredicate(), object)) continue;
                return IconRegistry.getImage(sp.getIcon().getImage());
            }
            if (model.getDefault() != null && model.getDefault().getIcon() != null) {
                return IconRegistry.getImage(model.getDefault().getIcon().getImage());
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IPredicate) {
            return new StyledString(((IPredicate)element).getDisplayName());
        }
        if (element instanceof Scope) {
            return new StyledString(((Scope)element).getName());
        }
        return this.getText(element, StyledString.class);
    }

    public <T> T getText(Object element, Class<T> theClass) {
        StylingModel model;
        EObject eobject;
        if (element instanceof EObject && !this.containsAdapter(eobject = (EObject)element)) {
            eobject.eAdapters().add((Object)new StylingAdapter());
        }
        if ((model = this.getStylingModel()) != null) {
            EList list = model.getStyles();
            for (CaseStyle styling : list) {
                StylingPredicate sp = (StylingPredicate)styling;
                if (sp.getPredicate() == null || !this.predicateEvaluator.match(sp.getPredicate(), element)) continue;
                if (StyledString.class.equals(theClass)) {
                    StyledString styledString = this.applyStyle(element, styling);
                    if (styledString.length() != 0) {
                        return (T)this.applyStyle(element, styling);
                    }
                    return this.getDefaultText(element, theClass);
                }
                StyledString s = this.applyStyle(element, styling);
                if (s.length() != 0) {
                    return (T)s.getString();
                }
                return this.getDefaultText(element, theClass);
            }
            if (model.getDefault() != null) {
                StyledString styledString = this.applyStyle(element, (CaseStyle)model.getDefault());
                if (styledString.length() != 0) {
                    return (T)this.applyStyle(element, (CaseStyle)model.getDefault());
                }
                return this.getDefaultText(element, theClass);
            }
        } else {
            return this.getDefaultText(element, theClass);
        }
        return this.toT(element.toString(), theClass);
    }

    protected <T> T getDefaultText(Object element, Class<T> theClass) {
        if (element instanceof Requirement) {
            Requirement req = (Requirement)element;
            String label = "id=" + req.getId() + "][" + "text=" + req.getText();
            return this.toT(" [ " + label + "]", theClass);
        }
        if (element instanceof Section) {
            String label = String.valueOf(((Section)element).getId()) + "][" + ((Section)element).getText();
            return this.toT(" [ " + label + "]", theClass);
        }
        return this.toT(element.toString(), theClass);
    }

    protected boolean containsAdapter(EObject eobject) {
        for (Adapter a : eobject.eAdapters()) {
            if (!(a instanceof StylingAdapter)) continue;
            return true;
        }
        return false;
    }

    public <T> T toT(String string, Class<T> theClass) {
        if (String.class.equals(theClass)) {
            return (T)string;
        }
        if (StyledString.class.equals(theClass)) {
            StyledString styled = new StyledString(string);
            return (T)styled;
        }
        return null;
    }

    void handleModification(Notification notification) {
        Object[] listObject = new Object[]{notification.getNotifier()};
        this.notifyChanged(listObject);
    }

    public void handleEvent(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof Reachable) {
            Reachable reachable = (Reachable)data;
            this.notifyChanged(new Object[]{reachable});
        } else if (data instanceof Collection) {
            this.notifyChanged(((Collection)data).toArray());
        }
    }

    public void hasChanged(final Reachable[] reachables) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StylingLabelProvider.this.notifyChanged(reachables);
            }
        });
    }

    protected class StylingAdapter
    extends AdapterImpl {
        protected StylingAdapter() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            StylingLabelProvider.this.handleModification(msg);
        }
    }
}

