/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.grunt.internal.launch.ui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.js.common.build.system.BuildSystemVisitor;
import org.eclipse.wst.jsdt.js.common.build.system.launch.ui.GenericBuildSystemTab;
import org.eclipse.wst.jsdt.js.common.build.system.util.ASTUtil;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.grunt.GruntPlugin;
import org.eclipse.wst.jsdt.js.grunt.internal.Messages;
import org.eclipse.wst.jsdt.js.grunt.internal.ui.ImageResource;
import org.eclipse.wst.jsdt.js.grunt.util.GruntVisitor;

public class GruntLaunchTab
extends GenericBuildSystemTab {
    public boolean isValid(ILaunchConfiguration launchConfig) {
        String task;
        File file;
        String buildFilePath;
        block5: {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            buildFilePath = this.buildFileText.getText();
            file = WorkbenchResourceUtil.getFile((String)buildFilePath);
            if (file == null) {
                this.setErrorMessage(Messages.GruntLaunchTab_ErrorNotExist);
                return false;
            }
            task = this.tasksCommbo.getText();
            if (!task.isEmpty()) break block5;
            return true;
        }
        try {
            String rootTask = task.split(":")[0];
            IFile ifile = WorkbenchResourceUtil.getFileForLocation((String)file.getAbsolutePath());
            List<String> availTasks = Arrays.asList(this.getTaskNames(ASTUtil.getTasks((String)buildFilePath, (BuildSystemVisitor)new GruntVisitor(ifile))));
            if (!availTasks.contains(rootTask)) {
                this.setWarningMessage(Messages.GruntLaunchTab_WarningTaskNotExist);
            }
        }
        catch (JavaScriptModelException e) {
            GruntPlugin.logError(e, e.getMessage());
        }
        return true;
    }

    public Image getImage() {
        return ImageResource.getImage("grunt_16.png");
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        String buildFileLocation = "";
        try {
            buildFileLocation = lc.getAttribute("org.eclipse.wst.jsdt.js.grunt.BUILD_FILE", null);
            this.buildFileText.setText(buildFileLocation != null ? buildFileLocation : "");
            File file = WorkbenchResourceUtil.getFile((String)buildFileLocation);
            IFile ifile = null;
            if (file != null) {
                ifile = WorkbenchResourceUtil.getFileForLocation((String)file.getAbsolutePath());
            }
            String task = lc.getAttribute("org.eclipse.wst.jsdt.js.grunt.COMMAND", null);
            Set tasks = ASTUtil.getTasks((String)buildFileLocation, (BuildSystemVisitor)new GruntVisitor(ifile));
            List<String> tasknames = Arrays.asList(this.getTaskNames(tasks));
            this.updateTasks(this.getTaskNames(tasks));
            if (task != null && !task.isEmpty()) {
                this.tasksCommbo.setText(task);
            } else if (tasknames.contains("default")) {
                this.tasksCommbo.setText("default");
            } else {
                this.tasksCommbo.setText("");
            }
            String params = lc.getAttribute("org.eclipse.wst.jsdt.js.grunt.PARAMETERS", null);
            if (params != null) {
                this.parametersText.setText(params);
            } else {
                this.parametersText.setText("");
            }
        }
        catch (CoreException e) {
            GruntPlugin.logError(e, e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        IFile buildFile = this.getBuildFile();
        if (buildFile != null) {
            IProject project = buildFile.getProject();
            wc.setAttribute("org.eclipse.wst.jsdt.js.grunt.BUILD_FILE", buildFile.getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.grunt.PROJECT", project.getName());
            wc.setAttribute("org.eclipse.wst.jsdt.js.grunt.DIR", buildFile.getParent().getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.grunt.COMMAND", this.tasksCommbo.getText());
            wc.setAttribute("org.eclipse.wst.jsdt.js.grunt.PARAMETERS", this.parametersText.getText());
        }
    }

    protected String[] getTasksFromFile(IFile file) throws JavaScriptModelException {
        Set tasks = ASTUtil.getTasks((String)file.getLocation().toOSString(), (BuildSystemVisitor)new GruntVisitor(file));
        return this.getTaskNames(tasks);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy arg0) {
    }
}

