/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.bower.internal.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.wst.jsdt.js.bower.BowerPlugin;
import org.eclipse.wst.jsdt.js.cli.core.CLI;
import org.eclipse.wst.jsdt.js.cli.core.CLICommand;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;

public class BowerLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String arg1, ILaunch arg2, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.wst.jsdt.js.bower.PROJECT", null);
        String dirPath = configuration.getAttribute("org.eclipse.wst.jsdt.js.bower.DIR", null);
        String commandName = configuration.getAttribute("org.eclipse.wst.jsdt.js.bower.COMMAND", null);
        IProject project = WorkbenchResourceUtil.getProject((String)projectName);
        if (project != null && project.exists()) {
            IPath dir = dirPath == null ? project.getLocation() : new Path(dirPath);
            CLICommand command = this.generateCommand(commandName);
            this.launchBower(project, dir, command, monitor);
        }
    }

    private void launchBower(IProject project, IPath dir, CLICommand command, IProgressMonitor monitor) {
        try {
            new CLI(project, dir, command).execute(monitor);
        }
        catch (CoreException e) {
            BowerPlugin.logError(e);
        }
    }

    private CLICommand generateCommand(String commandName) {
        return new CLICommand("bower", commandName, null, null);
    }
}

