/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceContainerTypeDelegate;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.debug.core.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.util.MementoFormat;

public class SourceNameMapperContainer
implements ISourceContainer {
    private static final String TYPE_ID = "org.eclipse.wst.jsdt.chromium.debug.core.SourceNameMapperContainer.type";
    private final ISourceContainer targetContainer;
    private final String prefix;

    public SourceNameMapperContainer(String prefix, ISourceContainer targetContainer) {
        this.targetContainer = targetContainer;
        this.prefix = prefix;
    }

    public void dispose() {
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ISourceContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        if (!name.startsWith(this.prefix)) {
            return new Object[0];
        }
        String shortName = name.substring(this.prefix.length());
        return this.targetContainer.findSourceElements(shortName);
    }

    public String getName() {
        return NLS.bind((String)Messages.SourceNameMapperContainer_NAME, (Object)this.prefix);
    }

    public ISourceContainer[] getSourceContainers() {
        return new ISourceContainer[]{this.targetContainer};
    }

    public ISourceContainerType getType() {
        return DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(TYPE_ID);
    }

    public void init(ISourceLookupDirector director) {
    }

    public boolean isComposite() {
        return true;
    }

    private String getMemento() throws CoreException {
        StringBuilder builder = new StringBuilder();
        MementoFormat.encodeComponent(this.prefix, builder);
        MementoFormat.encodeComponent(this.targetContainer.getType().getId(), builder);
        MementoFormat.encodeComponent(this.targetContainer.getType().getMemento(this.targetContainer), builder);
        return builder.toString();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public static class TypeDelegate
    implements ISourceContainerTypeDelegate {
        public ISourceContainer createSourceContainer(String memento) throws CoreException {
            String subContainerMemento;
            String typeId;
            String prefix;
            MementoFormat.Parser parser = new MementoFormat.Parser(memento);
            try {
                prefix = parser.nextComponent();
                typeId = parser.nextComponent();
                subContainerMemento = parser.nextComponent();
            }
            catch (MementoFormat.ParserException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to parse memento", (Throwable)e));
            }
            ISourceContainerType subContainerType = DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(typeId);
            ISourceContainer subContainer = subContainerType.createSourceContainer(subContainerMemento);
            return new SourceNameMapperContainer(prefix, subContainer);
        }

        public String getMemento(ISourceContainer container) throws CoreException {
            SourceNameMapperContainer chromeContainer = (SourceNameMapperContainer)container;
            return chromeContainer.getMemento();
        }
    }
}

