/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIContentContainer<T>
implements IUiContentProvider {
    protected final T m_binding;
    private final String m_errorPrefix;
    protected final List<IUiContentProvider> m_providers = Lists.newArrayList();

    public UIContentContainer(T binding, String errorPrefix) {
        this.m_binding = binding;
        this.m_errorPrefix = errorPrefix;
    }

    public T getBinding() {
        return this.m_binding;
    }

    public List<IUiContentProvider> getProviders() {
        return this.m_providers;
    }

    @Override
    public void setCompleteListener(ICompleteListener listener) {
        for (IUiContentProvider provider : this.m_providers) {
            provider.setCompleteListener(listener);
        }
    }

    @Override
    public String getErrorMessage() {
        for (IUiContentProvider provider : this.m_providers) {
            String errorMessage = provider.getErrorMessage();
            if (errorMessage == null) continue;
            return String.valueOf(this.m_errorPrefix) + errorMessage;
        }
        return null;
    }

    @Override
    public int getNumberOfControls() {
        int columns = 0;
        for (IUiContentProvider provider : this.m_providers) {
            columns = Math.max(columns, provider.getNumberOfControls());
        }
        return columns;
    }

    @Override
    public void createContent(Composite parent, int columns) {
        for (IUiContentProvider provider : this.m_providers) {
            provider.createContent(parent, columns);
        }
    }

    @Override
    public void updateFromObject() throws Exception {
        for (IUiContentProvider provider : this.m_providers) {
            provider.updateFromObject();
        }
    }

    @Override
    public void saveToObject() throws Exception {
        for (IUiContentProvider provider : this.m_providers) {
            provider.saveToObject();
        }
    }
}

