/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.mapping.ResourceModelLabelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class SVNChangeSetLabelProvider
extends ResourceModelLabelProvider {
    private Image changeSetImage;

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
    }

    public String getText(Object element) {
        if (element instanceof ActiveChangeSet && SVNTeamPlugin.instance().getModelChangeSetManager().isDefault((ActiveChangeSet)element)) {
            return String.valueOf(super.getText(element)) + " " + SVNUIMessages.ChangeSet_DefaultDecoration;
        }
        return super.getText(element);
    }

    protected String getDelegateText(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)element;
            return set.getName();
        }
        return super.getDelegateText(elementOrPath);
    }

    protected Image getDelegateImage(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof ChangeSet) {
            return this.getChangeSetImage();
        }
        return super.getDelegateImage(elementOrPath);
    }

    private Image getChangeSetImage() {
        if (this.changeSetImage == null) {
            this.changeSetImage = SVNTeamUIPlugin.instance().getImageDescriptor("icons/objects/changeset.gif").createImage();
        }
        return this.changeSetImage;
    }

    public void dispose() {
        if (this.changeSetImage != null) {
            this.changeSetImage.dispose();
        }
        super.dispose();
    }

    protected boolean isBusy(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)element;
            IResource[] resources = dcs.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (this.getContext().getDiffTree().getProperty(resource.getFullPath(), 1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return super.isBusy(elementOrPath);
    }

    protected boolean hasDecendantConflicts(Object elementOrPath) {
        DiffChangeSet set;
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)element;
            IResource[] resources = dcs.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (this.getContext().getDiffTree().getProperty(resource.getFullPath(), 2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (elementOrPath instanceof TreePath && element instanceof IResource && (set = this.internalGetChangeSet(elementOrPath)) != null) {
            ResourceTraversal[] traversals = this.getTraversalCalculator().getTraversals(set, (TreePath)elementOrPath);
            return this.getContext().getDiffTree().hasMatchingDiffs(traversals, CONFLICT_FILTER);
        }
        return super.hasDecendantConflicts(elementOrPath);
    }

    private DiffChangeSet internalGetChangeSet(Object elementOrPath) {
        TreePath tp;
        Object o;
        if (elementOrPath instanceof TreePath && (o = (tp = (TreePath)elementOrPath).getFirstSegment()) instanceof DiffChangeSet) {
            return (DiffChangeSet)o;
        }
        return null;
    }

    protected int getMarkerSeverity(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)element;
            HashSet<IProject> projects = new HashSet<IProject>();
            IResource[] resources = dcs.getResources();
            int severity = -1;
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                IProject project = resource.getProject();
                if (!projects.contains(project)) {
                    projects.add(project);
                    int next = super.getMarkerSeverity((Object)project);
                    if (next == 2) {
                        return 2;
                    }
                    if (next == 1) {
                        severity = next;
                    }
                }
                ++i;
            }
            return severity;
        }
        return super.getMarkerSeverity(elementOrPath);
    }

    protected void updateLabels(Object[] elements) {
        super.updateLabels(this.addSetsContainingElements(elements));
    }

    private Object[] addSetsContainingElements(Object[] elements) {
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            result.add(object);
            if (object instanceof IProject) {
                IProject project = (IProject)object;
                ChangeSet[] sets = this.getSetsContaing(project);
                int j = 0;
                while (j < sets.length) {
                    ChangeSet set = sets[j];
                    result.add(set);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray();
    }

    private ChangeSet[] getSetsContaing(IProject project) {
        return this.getContentProvider().getSetsShowingPropogatedStateFrom(project.getFullPath());
    }

    private SVNChangeSetContentProvider getContentProvider() {
        return (SVNChangeSetContentProvider)this.getExtensionSite().getExtension().getContentProvider();
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    public Font getFont(Object element) {
        if ((element = this.internalGetElement(element)) instanceof ActiveChangeSet && this.isDefaultActiveSet((ActiveChangeSet)element)) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return super.getFont(element);
    }

    private boolean isDefaultActiveSet(ActiveChangeSet set) {
        ActiveChangeSetManager activeChangeSetManager;
        ChangeSetCapability changeSetCapability = this.getContentProvider().getChangeSetCapability();
        if (changeSetCapability != null && (activeChangeSetManager = changeSetCapability.getActiveChangeSetManager()) != null) {
            return activeChangeSetManager.isDefault(set);
        }
        return false;
    }
}

