/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.graphic.FindRevisionNodeDialog;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditor;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class FindRevisionNodeAction
extends Action {
    protected IEditorPart editor;
    protected static FindRevisionNodeDialogStub findDialogStub;

    public FindRevisionNodeAction(IWorkbenchPart part) {
        this.init();
    }

    protected void init() {
        this.setId(ActionFactory.FIND.getId());
        this.setText(SVNRevisionGraphMessages.FindRevisionNodeAction_Text);
        this.setToolTipText(SVNRevisionGraphMessages.FindRevisionNodeAction_Tooltip);
        this.setImageDescriptor(SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/search.gif"));
    }

    public void setActiveEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public void run() {
        if (FindRevisionNodeAction.canSearch((IWorkbenchPart)this.editor)) {
            if (findDialogStub == null) {
                findDialogStub = new FindRevisionNodeDialogStub(this.editor.getSite());
            }
            FindRevisionNodeDialog dlg = findDialogStub.getDialog();
            dlg.updateTarget((RevisionGraphEditor)this.editor);
            dlg.open();
        }
    }

    public static boolean canSearch(IWorkbenchPart part) {
        if (part instanceof RevisionGraphEditor) {
            RevisionGraphEditor editor = (RevisionGraphEditor)part;
            return editor.getModel() instanceof RevisionRootNode;
        }
        return false;
    }

    protected static class FindRevisionNodeDialogStub
    implements IPartListener2,
    DisposeListener,
    PropertyChangeListener {
        protected RevisionGraphEditor graphEditor;
        protected FindRevisionNodeDialog findDialog;
        protected IWorkbenchWindow workbenchWindow;

        public FindRevisionNodeDialogStub(IWorkbenchPartSite site) {
            this.findDialog = new FindRevisionNodeDialog(site.getShell());
            this.findDialog.create();
            this.findDialog.getShell().addDisposeListener((DisposeListener)this);
            this.workbenchWindow = site.getWorkbenchWindow();
            IPartService service = this.workbenchWindow.getPartService();
            service.addPartListener((IPartListener2)this);
            this.partActivated(service.getActivePart());
        }

        public FindRevisionNodeDialog getDialog() {
            return this.findDialog;
        }

        protected void partActivated(IWorkbenchPart part) {
            RevisionGraphEditor newGraphEditor;
            RevisionGraphEditor revisionGraphEditor = newGraphEditor = FindRevisionNodeAction.canSearch(part) ? (RevisionGraphEditor)part : null;
            if (this.graphEditor != newGraphEditor) {
                RevisionGraphEditor previousEditor = this.graphEditor;
                this.graphEditor = newGraphEditor;
                if (previousEditor != null) {
                    ((RevisionRootNode)previousEditor.getModel()).removePropertyChangeListener(this);
                }
                if (this.graphEditor != null) {
                    ((RevisionRootNode)this.graphEditor.getModel()).addPropertyChangeListener(this);
                }
                if (this.findDialog != null) {
                    this.findDialog.updateTarget(newGraphEditor);
                }
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            this.partActivated(partRef.getPart(true));
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            RevisionGraphEditor graphEditor;
            IWorkbenchPart part = partRef.getPart(true);
            RevisionGraphEditor revisionGraphEditor = graphEditor = FindRevisionNodeAction.canSearch(part) ? (RevisionGraphEditor)part : null;
            if (this.graphEditor == graphEditor) {
                this.partActivated((IWorkbenchPart)null);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            findDialogStub = null;
            if (this.workbenchWindow != null) {
                this.workbenchWindow.getPartService().removePartListener((IPartListener2)this);
                this.workbenchWindow = null;
            }
            if (this.graphEditor != null) {
                ((RevisionRootNode)this.graphEditor.getModel()).removePropertyChangeListener(this);
            }
            this.graphEditor = null;
            this.findDialog = null;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("filterNodes".equals(evt.getPropertyName()) || "expandCollapseNodes".equals(evt.getPropertyName())) {
                if (this.findDialog != null) {
                    this.findDialog.changeGraphModel();
                }
            } else if ("refreshNodes".equals(evt.getPropertyName())) {
                RevisionRootNode oldRoot = (RevisionRootNode)evt.getOldValue();
                oldRoot.removePropertyChangeListener(this);
                RevisionRootNode newRoot = (RevisionRootNode)evt.getNewValue();
                newRoot.addPropertyChangeListener(this);
                if (this.findDialog != null) {
                    this.findDialog.changeGraphModel();
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

