/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.sphinx.platform.ui.dialogs.ProjectSelectionDialog;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.preferences.messages.AbstractPreferenceAndPropertyMessages;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractPreferenceAndPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    protected String requiredProjectNatureId;
    private Composite parentComposite;
    private Link configureOtherSettingsLink;
    private SelectionButtonField enableProjectSpecificSettingsField;
    private IProject project;
    private Map<String, Object> data;
    public static final String DATA_NO_LINK = "AbstractPreferenceAndPropertyPage.nolink";

    public AbstractPreferenceAndPropertyPage(String requiredProjectNatureId) {
        this(requiredProjectNatureId, 0);
    }

    public AbstractPreferenceAndPropertyPage(String requiredProjectNatureId, int style) {
        super(style);
        this.requiredProjectNatureId = requiredProjectNatureId;
        this.project = null;
        this.data = null;
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.addFields(composite);
    }

    protected abstract void addFields(Composite var1);

    protected abstract void enablePreferenceContent(boolean var1);

    protected String getPreferencePageID() {
        return null;
    }

    protected String getPropertyPageID() {
        return null;
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.parentComposite = parent;
        if (this.isProjectPreferencePage()) {
            if (this.supportsWorkspaceSpecificOptions()) {
                Composite composite = new Composite(parent, 0);
                composite.setFont(parent.getFont());
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                composite.setLayout((Layout)layout);
                composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                IFieldListener listener = new IFieldListener(){

                    @Override
                    public void dialogFieldChanged(IField field) {
                        boolean enabled = ((SelectionButtonField)field).isSelected();
                        AbstractPreferenceAndPropertyPage.this.enableProjectSpecificSettings(enabled);
                        if (enabled && AbstractPreferenceAndPropertyPage.this.getData() != null) {
                            AbstractPreferenceAndPropertyPage.this.applyData(AbstractPreferenceAndPropertyPage.this.getData());
                        }
                    }
                };
                this.enableProjectSpecificSettingsField = new SelectionButtonField(32);
                this.enableProjectSpecificSettingsField.addFieldListener(listener);
                this.enableProjectSpecificSettingsField.setLabelText(AbstractPreferenceAndPropertyMessages.AbstractPreferenceAndPropertyPage_enableProjectSpecificSettings);
                this.enableProjectSpecificSettingsField.fillIntoGrid(composite, 1);
                this.enableProjectSpecificSettingsField.setSelectionWithoutEvent(true);
                LayoutUtil.setHorizontalGrabbing((Control)this.enableProjectSpecificSettingsField.getSelectionButton(null));
                if (this.offerLink()) {
                    this.configureOtherSettingsLink = this.createLink(composite, AbstractPreferenceAndPropertyMessages.AbstractPreferenceAndPropertyPage_configureWorkspaceSettings);
                    this.configureOtherSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                    if (this.enableProjectSpecificSettingsField != null) {
                        this.enableProjectSpecificSettings(this.enableProjectSpecificSettingsField.isSelected());
                    }
                } else {
                    LayoutUtil.setHorizontalSpan((Control)this.enableProjectSpecificSettingsField.getSelectionButton(null), 2);
                }
                Label horizontalLine = new Label(composite, 258);
                horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                horizontalLine.setFont(composite.getFont());
            }
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.configureOtherSettingsLink = this.createLink(parent, AbstractPreferenceAndPropertyMessages.AbstractPreferenceAndPropertyPage_configureProjectSpecificSettings);
            this.configureOtherSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected boolean supportsWorkspaceSpecificOptions() {
        return this.getPreferencePageID() != null;
    }

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean isProjectPreferencePage() {
        return this.project != null;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.enableProjectSpecificSettingsField.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.data = (Map)data;
        }
        if (this.configureOtherSettingsLink != null && !this.offerLink()) {
            this.configureOtherSettingsLink.dispose();
            this.parentComposite.layout(true, true);
        }
    }

    protected Map<String, Object> getData() {
        return this.data;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.enableProjectSpecificSettingsField != null && this.enableProjectSpecificSettingsField.isSelected();
    }

    protected boolean offerLink() {
        return this.data == null || !Boolean.TRUE.equals(this.data.get(DATA_NO_LINK));
    }

    private final void doLinkActivated(Link link) {
        Map<String, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
            Collection projects = ExtendedPlatform.getProjects((String)this.requiredProjectNatureId);
            for (IProject project : projects) {
                projectsWithSpecifics.add(project);
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
            if (dialog.open() == 0) {
                IProject project = (IProject)dialog.getFirstResult();
                this.openProjectProperties(project, data);
            }
        }
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferenceAndPropertyPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractPreferenceAndPropertyPage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    private void updateLinkVisibility() {
        if (this.configureOtherSettingsLink == null || this.configureOtherSettingsLink.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.configureOtherSettingsLink.setEnabled(!this.useProjectSettings());
        }
    }
}

