/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.interpreter.aql;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;

public class AQLInterpreter
implements IInterpreter {
    private static final String AQL_PREFIX = "aql:";
    private LoadingCache<String, IQueryBuilderEngine.AstResult> parsedExpressions;
    private IQueryEnvironment queryEnvironment;

    public AQLInterpreter() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        this.initExpressionsCache();
    }

    public AQLInterpreter(IQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
        this.initExpressionsCache();
    }

    private void initExpressionsCache() {
        final IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)this.queryEnvironment);
        this.parsedExpressions = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, IQueryBuilderEngine.AstResult>(){

            public IQueryBuilderEngine.AstResult load(String key) throws Exception {
                return builder.build(key);
            }
        });
    }

    public IEvaluationResult evaluateExpression(Map<String, Object> variables, String expressionBody) {
        String expression = expressionBody;
        if (expression.startsWith(AQL_PREFIX)) {
            expression = expression.substring(AQL_PREFIX.length());
        }
        try {
            IQueryBuilderEngine.AstResult build = (IQueryBuilderEngine.AstResult)this.parsedExpressions.get((Object)expression);
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)this.queryEnvironment);
            EvaluationResult evalResult = evaluationEngine.eval(build, variables);
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            if (build.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(build.getDiagnostic());
            }
            if (evalResult.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(evalResult.getDiagnostic());
            }
            return org.eclipse.sirius.common.interpreter.api.EvaluationResult.of((Object)evalResult.getResult(), (Diagnostic)diagnostic);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

