/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ActionsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.FactsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.InfoSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDialog;
import org.eclipse.sapphire.ui.assist.internal.ResetActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.RestoreInitialValueActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ShowInSourceActionAssistContributor;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class PropertyEditorAssistDecorator {
    private static final List<Class<? extends PropertyEditorAssistContributor>> SYSTEM_CONTRIBUTORS = new ArrayList<Class<? extends PropertyEditorAssistContributor>>();
    private static final ImageDescriptor IMG_ASSIST;
    private static final ImageDescriptor IMG_ASSIST_FAINT;
    private static final ImageDescriptor IMG_ASSIST_CLEAR;
    private final SapphirePart part;
    private final Property property;
    private final Label control;
    private Control primary;
    private PropertyEditorAssistContext assistContext;
    private Status problem;
    private boolean mouseOverEditorControl;
    private EditorControlMouseTrackListener mouseTrackListener;
    private final Listener modelPropertyListener;
    private final Listener partValidationListener;
    private final SapphireAction assistAction;
    private final SapphireActionHandler assistActionHandler;
    private final List<PropertyEditorAssistContributor> contributors;

    static {
        SYSTEM_CONTRIBUTORS.add(InfoSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(FactsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ProblemsSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ActionsSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ResetActionsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(RestoreInitialValueActionsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ShowInSourceActionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ProblemsAssistContributor.class);
        IMG_ASSIST = SwtUtil.createImageDescriptor(PropertyEditorAssistContext.class, "Assist.png");
        IMG_ASSIST_FAINT = SwtUtil.createImageDescriptor(PropertyEditorAssistContext.class, "AssistFaint.png");
        IMG_ASSIST_CLEAR = SwtUtil.createImageDescriptor(PropertyEditorAssistContext.class, "AssistClear.png");
    }

    public PropertyEditorAssistDecorator(PropertyEditorPart part, Composite parent) {
        this(part, part.property(), parent);
    }

    public PropertyEditorAssistDecorator(SapphirePart part, Property property, Composite parent) {
        Object segment;
        int n;
        String[] stringArray;
        this.part = part;
        this.property = property;
        this.mouseOverEditorControl = false;
        this.mouseTrackListener = new EditorControlMouseTrackListener();
        PartDef def = this.part.definition();
        ArrayList contributorClasses = new ArrayList();
        contributorClasses.addAll(SYSTEM_CONTRIBUTORS);
        String additionalContributorsStr = def.getHint("assist.contributors");
        if (additionalContributorsStr != null) {
            ISapphireUiDef iSapphireUiDef = (ISapphireUiDef)def.nearest(ISapphireUiDef.class);
            stringArray = additionalContributorsStr.split(",");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                segment = stringArray[n2];
                Class<?> cl = iSapphireUiDef.resolveClass(((String)segment).trim());
                if (cl != null) {
                    contributorClasses.add(cl);
                }
                ++n2;
            }
        }
        this.contributors = new ArrayList<PropertyEditorAssistContributor>();
        for (Class clazz : contributorClasses) {
            try {
                this.contributors.add((PropertyEditorAssistContributor)clazz.newInstance());
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        String string = def.getHint("suppress.assist.contributors");
        if (string != null) {
            stringArray = string.split(",");
            n = stringArray.length;
            int e = 0;
            while (e < n) {
                segment = stringArray[e];
                String id = ((String)segment).trim();
                Iterator<PropertyEditorAssistContributor> itr = this.contributors.iterator();
                while (itr.hasNext()) {
                    PropertyEditorAssistContributor contributor = itr.next();
                    if (!contributor.getId().equals(id)) continue;
                    itr.remove();
                    break;
                }
                ++e;
            }
        }
        Listener contributorListener = new Listener(){

            public void handle(Event event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertyEditorAssistDecorator.this.refresh();
                    }
                });
            }
        };
        for (PropertyEditorAssistContributor contributor : this.contributors) {
            try {
                contributor.init(this.part);
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            contributor.attach(contributorListener);
        }
        Collections.sort(this.contributors, new Comparator<PropertyEditorAssistContributor>(){

            @Override
            public int compare(PropertyEditorAssistContributor c1, PropertyEditorAssistContributor c2) {
                return c1.getPriority() - c2.getPriority();
            }
        });
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertyEditorAssistDecorator.this.refresh();
                    }
                });
            }
        };
        this.property.attach(this.modelPropertyListener);
        this.partValidationListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertyEditorAssistDecorator.this.refresh();
                    }
                });
            }
        };
        this.part.attach(this.partValidationListener);
        this.assistAction = part.getActions().getAction("Sapphire.Assist");
        this.assistActionHandler = new SapphireActionHandler(){

            @Override
            protected Object run(Presentation context) {
                PropertyEditorAssistDecorator.this.openAssistDialog();
                return null;
            }
        };
        this.assistActionHandler.init(this.assistAction, null);
        this.assistAction.addHandler(this.assistActionHandler);
        this.control = new Label(parent, 0);
        this.control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                PropertyEditorAssistDecorator.this.openAssistDialog();
            }
        });
        this.control.addMouseTrackListener((MouseTrackListener)new EditorControlMouseTrackListener(this){

            @Override
            public void mouseEnter(MouseEvent event) {
                super.mouseEnter(event);
                this.refreshImageAndCursor();
            }

            @Override
            public void mouseHover(MouseEvent event) {
            }
        });
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PropertyEditorAssistDecorator.this.dispose();
            }
        });
        this.refresh();
    }

    public Label control() {
        return this.control;
    }

    public Shell shell() {
        return this.control.getShell();
    }

    public SapphirePart part() {
        return this.part;
    }

    public Property property() {
        return this.property;
    }

    public void addEditorControl(Control control) {
        this.addEditorControl(control, false);
    }

    public void addEditorControl(Control control, boolean primary) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addEditorControl(child);
                ++n2;
            }
        }
        control.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        if (primary) {
            this.primary = control;
        }
    }

    public void removeEditorControl(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.removeEditorControl(child);
                ++n2;
            }
        }
        control.removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        if (this.primary == control) {
            this.primary = null;
        }
    }

    private void openAssistDialog() {
        if (this.assistContext != null && !this.assistContext.isEmpty()) {
            Point position;
            Rectangle primaryControlBounds;
            Rectangle decoratorControlBounds = this.control.getBounds();
            Rectangle rectangle = primaryControlBounds = this.primary == null ? null : this.primary.getBounds();
            if (primaryControlBounds != null && primaryControlBounds.height < 50) {
                position = new Point(primaryControlBounds.x, primaryControlBounds.y + primaryControlBounds.height + 1);
                position = this.primary.getParent().toDisplay(position);
            } else {
                position = new Point(decoratorControlBounds.x + decoratorControlBounds.width + 2, decoratorControlBounds.y);
                position = this.control.getParent().toDisplay(position);
            }
            PropertyEditorAssistDialog dialog = new PropertyEditorAssistDialog(this.shell(), position, this.assistContext);
            dialog.open();
        }
    }

    private void refresh() {
        if (this.control.isDisposed()) {
            return;
        }
        if (this.property.enabled()) {
            this.assistContext = new PropertyEditorAssistContext(this.part, this.shell());
            this.problem = this.part.validation();
            for (PropertyEditorAssistContributor c : this.contributors) {
                c.contribute(this.assistContext);
            }
            if (this.assistContext.isEmpty()) {
                this.assistContext = null;
            } else {
                Status.Severity valResultSeverity = this.problem.severity();
                if (valResultSeverity != Status.Severity.ERROR && valResultSeverity != Status.Severity.WARNING) {
                    this.problem = null;
                }
            }
        } else {
            this.assistContext = null;
            this.problem = null;
        }
        this.refreshImageAndCursor();
    }

    private void refreshImageAndCursor() {
        if (this.control.isDisposed()) {
            return;
        }
        SwtResourceCache imageCache = this.part.getSwtResourceCache();
        if (this.assistContext != null) {
            if (this.problem != null) {
                String fieldDecorationId;
                switch (this.problem.severity()) {
                    case ERROR: {
                        fieldDecorationId = "DEC_ERROR";
                        break;
                    }
                    case WARNING: {
                        fieldDecorationId = "DEC_WARNING";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
                this.control.setImage(fieldDecoration.getImage());
            } else if (this.mouseOverEditorControl) {
                this.control.setImage(imageCache.image(IMG_ASSIST));
            } else {
                this.control.setImage(imageCache.image(IMG_ASSIST_FAINT));
            }
            this.control.setVisible(true);
            this.control.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.control.setVisible(false);
            this.control.setImage(imageCache.image(IMG_ASSIST_CLEAR));
            this.control.setCursor(null);
        }
    }

    private void dispose() {
        this.part.detach(this.partValidationListener);
        this.property.detach(this.modelPropertyListener);
        this.assistAction.removeHandler(this.assistActionHandler);
        for (PropertyEditorAssistContributor contributor : this.contributors) {
            try {
                contributor.dispose();
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
    }

    private class EditorControlMouseTrackListener
    extends MouseTrackAdapter {
        private EditorControlMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = true;
        }

        public void mouseHover(MouseEvent event) {
            PropertyEditorAssistDecorator.this.refreshImageAndCursor();
        }

        public void mouseExit(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = false;
            this.performedDelayedImageRefresh();
        }

        private void performedDelayedImageRefresh() {
            final Runnable op = new Runnable(){

                @Override
                public void run() {
                    PropertyEditorAssistDecorator.this.refreshImageAndCursor();
                }
            };
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    Display.getDefault().asyncExec(op);
                }
            };
            thread.start();
        }

        /* synthetic */ EditorControlMouseTrackListener(EditorControlMouseTrackListener editorControlMouseTrackListener, EditorControlMouseTrackListener editorControlMouseTrackListener2) {
            this();
        }
    }
}

