/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.io.File;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.services.PathValidationService;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class RelativePathValidationService
extends PathValidationService {
    @Text(value="Relative path \"{0}\" could not be resolved")
    private static LocalizableText couldNotResolveRelative;
    private RelativePathService relativePathService;
    private Listener relativePathServiceListener;

    static {
        LocalizableText.init(RelativePathValidationService.class);
    }

    @Override
    protected void initValidationService() {
        super.initValidationService();
        this.relativePathService = this.context(Value.class).service(RelativePathService.class);
        this.relativePathServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                RelativePathValidationService.this.refresh();
            }
        };
        this.relativePathService.attach(this.relativePathServiceListener);
    }

    @Override
    protected Status compute() {
        Path path = (Path)this.context(Value.class).content();
        if (path != null) {
            Path absolutePath = this.relativePathService.convertToAbsolute(path);
            if (absolutePath == null) {
                String message = couldNotResolveRelative.format(path.toString());
                return Status.createErrorStatus(message);
            }
            File absolutePathFile = absolutePath.toFile();
            if (absolutePathFile.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (absolutePathFile.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = pathIsNotFile.format(absolutePath.toPortableString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !absolutePathFile.isDirectory()) {
                    String message = pathIsNotFolder.format(absolutePath.toPortableString());
                    return Status.createErrorStatus(message);
                }
                return Status.createOkStatus();
            }
            if (this.resourceMustExist) {
                String message;
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    message = fileMustExist.format(path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    message = folderMustExist.format(path.toString());
                    return Status.createErrorStatus(message);
                }
                message = resourceMustExistMessage.format(path.toString());
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        if (this.relativePathService != null) {
            this.relativePathService.detach(this.relativePathServiceListener);
            this.relativePathService = null;
            this.relativePathServiceListener = null;
        }
        super.dispose();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && Path.class.isAssignableFrom(property.definition().getTypeClass()) && property.service(RelativePathService.class) != null;
        }
    }
}

