/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.services.ContentProposal;
import org.eclipse.sapphire.services.ContentProposalService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class PossibleValuesContentProposalService
extends ContentProposalService {
    private PossibleValuesService possibleValuesService;

    @Override
    protected void init() {
        super.init();
        Property property = this.context(Property.class);
        this.possibleValuesService = property.service(PossibleValuesService.class);
        if (this.possibleValuesService == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public ContentProposalService.Session session() {
        return new ContentProposalService.Session(this){

            @Override
            protected List<ContentProposal> compute() {
                String filter = this.filter().toLowerCase();
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                if (filter.length() == 0) {
                    for (String value : PossibleValuesContentProposalService.this.possibleValuesService.values()) {
                        ContentProposal proposal = new ContentProposal(value);
                        proposals.add(proposal);
                    }
                } else {
                    for (ContentProposal proposal : this.proposals()) {
                        if (!proposal.content().toLowerCase().startsWith(filter)) continue;
                        proposals.add(proposal);
                    }
                }
                return proposals;
            }
        };
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.service(PossibleValuesService.class) != null;
        }
    }
}

