/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import com.jcraft.jsch.ChannelShell;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.proxy.core.ProxyConnectionBootstrap;
import org.eclipse.remote.internal.proxy.core.ProxyProcessBuilder;
import org.eclipse.remote.internal.proxy.core.commands.ExecCommand;
import org.eclipse.remote.internal.proxy.core.commands.GetCwdCommand;
import org.eclipse.remote.internal.proxy.core.commands.GetEnvCommand;
import org.eclipse.remote.internal.proxy.core.commands.GetPropertiesCommand;
import org.eclipse.remote.internal.proxy.core.messages.Messages;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.StreamChannelManager;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ProxyConnection
implements IRemoteConnectionControlService,
IRemoteConnectionChangeListener,
IRemoteProcessService,
IRemoteCommandShellService,
IRemoteConnectionHostService,
IRemoteConnectionPropertyService {
    public static final String JSCH_ID = "org.eclipse.remote.Proxy";
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final boolean DEFAULT_USE_PASSWORD = false;
    public static final boolean DEFAULT_USE_DEFAULT_SERVER = true;
    public static final String DEFAULT_SERVER_COMMAND = "sh .eclipsesettings/proxy.sh";
    public static final String HOSTNAME_ATTR = "PROXY_HOSTNAME__ATTR";
    public static final String USERNAME_ATTR = "PROXY_USERNAME_ATTR";
    public static final String PASSWORD_ATTR = "PROXY_PASSWORD_ATTR";
    public static final String PORT_ATTR = "PROXY_PORT_ATTR";
    public static final String USE_PASSWORD_ATTR = "PROXY_USE_PASSWORD_ATTR";
    public static final String PASSPHRASE_ATTR = "PROXY_PASSPHRASE_ATTR";
    public static final String TIMEOUT_ATTR = "PROXY_TIMEOUT_ATTR";
    public static final String SERVER_COMMAND_ATTR = "PROXY_SERVER_COMMAND_ATTR";
    public static final String USE_DEFAULT_SERVER_ATTR = "PROXY_USE_DEFAULT_SERVER_ATTR";
    private String fWorkingDir;
    private StreamChannelManager channelMux;
    private StreamChannel commandChannel;
    private boolean isOpen;
    private final IRemoteConnection fRemoteConnection;
    private final Map<String, String> fEnv = new HashMap<String, String>();
    private final Map<String, String> fProperties = new HashMap<String, String>();
    private static final Map<IRemoteConnection, ProxyConnection> connectionMap = new HashMap<IRemoteConnection, ProxyConnection>();
    private StringBuffer stdout = new StringBuffer();
    private StringBuffer stderr = new StringBuffer();

    public ProxyConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
        connection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(RemoteConnectionChangeEvent event) {
        if (event.getType() == 32) {
            Map<IRemoteConnection, ProxyConnection> map = connectionMap;
            synchronized (map) {
                connectionMap.remove(event.getConnection());
            }
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    public synchronized void close() {
        if (this.isOpen) {
            this.channelMux.shutdown();
            this.isOpen = false;
            this.fRemoteConnection.fireConnectionChangeEvent(1);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProxyConnection_0, (int)20);
        if (!this.isOpen) {
            ProxyConnectionBootstrap bootstrap = new ProxyConnectionBootstrap();
            this.channelMux = bootstrap.run(this.getRemoteConnection(), (IProgressMonitor)subMon.newChild(10));
            new Thread((Runnable)this.channelMux, "multiplexer").start();
            try {
                this.commandChannel = this.channelMux.openChannel();
                this.initialize((IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException | RemoteConnectionException e) {
                try {
                    this.commandChannel.close();
                }
                catch (IOException iOException) {}
                this.channelMux.shutdown();
                throw new RemoteConnectionException(e.getMessage());
            }
            this.isOpen = true;
            this.fRemoteConnection.fireConnectionChangeEvent(2);
        }
    }

    private void initialize(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        this.fWorkingDir = this.getCwd((IProgressMonitor)subMon.newChild(10));
        if (subMon.isCanceled()) {
            throw new RemoteConnectionException(Messages.ProxyConnection_2);
        }
        this.fEnv.putAll(this.loadEnv((IProgressMonitor)subMon.newChild(10)));
        if (subMon.isCanceled()) {
            throw new RemoteConnectionException(Messages.ProxyConnection_2);
        }
        this.fProperties.putAll(this.loadProperties((IProgressMonitor)subMon.newChild(10)));
        if (subMon.isCanceled()) {
            throw new RemoteConnectionException(Messages.ProxyConnection_2);
        }
    }

    private String getCwd(IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            GetCwdCommand cmd = new GetCwdCommand(this);
            return (String)cmd.getResult(monitor);
        }
        catch (ProxyException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private Map<String, String> loadEnv(IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            GetEnvCommand cmd = new GetEnvCommand(this);
            return (Map)cmd.getResult(monitor);
        }
        catch (ProxyException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private Map<String, String> loadProperties(IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            GetPropertiesCommand cmd = new GetPropertiesCommand(this);
            return (Map)cmd.getResult(monitor);
        }
        catch (ProxyException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public Map<String, String> getEnv() {
        return Collections.unmodifiableMap(this.fEnv);
    }

    public StreamChannel getCommandChannel() {
        return this.commandChannel;
    }

    public StreamChannel openChannel() throws IOException {
        return this.channelMux.openChannel();
    }

    private String executeSshCommand(ChannelShell shell, String command) throws RemoteConnectionException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            shell.setOutputStream((OutputStream)stream);
            shell.setExtOutputStream((OutputStream)err);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(shell.getOutputStream()));
            writer.write(command);
            writer.flush();
            if (err.size() > 0) {
                throw new RemoteConnectionException(err.toString());
            }
            return stream.toString();
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private String executeCommand(List<String> command, IProgressMonitor monitor) throws ProxyException {
        try {
            final StreamChannel chanA = this.channelMux.openChannel();
            final StreamChannel chanB = this.channelMux.openChannel();
            StreamChannel chanC = this.channelMux.openChannel();
            new Thread("cmd stdin reader"){

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    try {
                        int n;
                        while ((n = chanA.getInputStream().read(buf)) >= 0) {
                            ProxyConnection.this.stdout.append(new String(buf, 0, n));
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            new Thread("cmd stderr reader"){

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    try {
                        int n;
                        while ((n = chanB.getInputStream().read(buf)) >= 0) {
                            ProxyConnection.this.stderr.append(new String(buf, 0, n));
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            ExecCommand cmd = new ExecCommand(this, command, this.getEnv(), this.getWorkingDirectory(), false, false, chanA.getId(), chanB.getId(), chanC.getId());
            cmd.getResult(monitor);
            DataInputStream status = new DataInputStream(chanC.getInputStream());
            int stat = status.readInt();
            if (stat == 0) {
                return this.stdout.toString();
            }
            return this.stderr.toString();
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }

    public String getEnv(String name) {
        return this.getEnv().get(name);
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new ProxyProcessBuilder(this, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new ProxyProcessBuilder(this, command);
    }

    public String getWorkingDirectory() {
        return this.fWorkingDir;
    }

    public void setWorkingDirectory(String path) {
        if (RemoteServicesUtils.posixPath((String)path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        return new ProxyProcessBuilder(this).start(flags);
    }

    public String getHostname() {
        return this.fRemoteConnection.getAttribute(HOSTNAME_ATTR);
    }

    public int getPort() {
        String portStr = this.fRemoteConnection.getAttribute(PORT_ATTR);
        return !portStr.isEmpty() ? Integer.parseInt(portStr) : 22;
    }

    public int getTimeout() {
        String portStr = this.fRemoteConnection.getAttribute(TIMEOUT_ATTR);
        return !portStr.isEmpty() ? Integer.parseInt(portStr) : 0;
    }

    public String getPassphrase() {
        return this.fRemoteConnection.getSecureAttribute(PASSPHRASE_ATTR);
    }

    public String getPassword() {
        return this.fRemoteConnection.getSecureAttribute(PASSWORD_ATTR);
    }

    public boolean usePassword() {
        String str = this.fRemoteConnection.getAttribute(USE_PASSWORD_ATTR);
        return !str.isEmpty() ? Boolean.parseBoolean(str) : false;
    }

    public String getUsername() {
        return this.fRemoteConnection.getAttribute(USERNAME_ATTR);
    }

    public boolean useLoginShell() {
        return false;
    }

    public void setHostname(String hostname) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(HOSTNAME_ATTR, hostname);
        }
    }

    public void setPassphrase(String passphrase) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setSecureAttribute(PASSPHRASE_ATTR, passphrase);
        }
    }

    public void setPassword(String password) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setSecureAttribute(PASSWORD_ATTR, password);
        }
    }

    public void setPort(int port) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(PORT_ATTR, Integer.toString(port));
        }
    }

    public void setTimeout(int timeout) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(TIMEOUT_ATTR, Integer.toString(timeout));
        }
    }

    public void setUseLoginShell(boolean useLogingShell) {
    }

    public void setUsePassword(boolean usePassword) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(USE_PASSWORD_ATTR, Boolean.toString(usePassword));
        }
    }

    public void setUsername(String username) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(USERNAME_ATTR, username);
        }
    }

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection connection, Class<T> service) {
            if (ProxyConnection.class.equals(service)) {
                Map map = connectionMap;
                synchronized (map) {
                    ProxyConnection conn = (ProxyConnection)connectionMap.get(connection);
                    if (conn == null) {
                        conn = new ProxyConnection(connection);
                        connectionMap.put(connection, conn);
                    }
                    return (T)conn;
                }
            }
            if (IRemoteConnectionControlService.class.equals(service) || IRemoteConnectionPropertyService.class.equals(service) || IRemoteConnectionHostService.class.equals(service) || IRemoteProcessService.class.equals(service) || IRemoteCommandShellService.class.equals(service) || IRemoteConnectionPropertyService.class.equals(service)) {
                return (T)connection.getService(ProxyConnection.class);
            }
            return null;
        }
    }
}

