/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTcUtil;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Element2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

abstract class AbstractRelation2TraceClass
implements Relation2TraceClass {
    protected final @NonNull RelationalTransformation2TracePackage relationalTransformation2tracePackage;
    protected final @NonNull Relation relation;
    protected final @NonNull Class traceClass;
    private @Nullable Class signatureClass = null;
    private final @NonNull List<@NonNull Relation2TraceClass> consumedByRelation2TraceClasses = new ArrayList<Relation2TraceClass>();
    private final @NonNull List<@NonNull Relation2TraceClass> consumedRelation2TraceClasses = new ArrayList<Relation2TraceClass>();
    private @Nullable Set<@NonNull Relation2TraceClass> transitivelyConsumedByRelation2TraceClasses = null;
    private @Nullable Set<@NonNull Relation2TraceClass> transitivelyConsumedRelation2TraceClasses = null;
    private @Nullable Set<@NonNull Relation2TraceClass> cyclicRelation2TraceClasses = null;
    private final @NonNull List<@NonNull RelationCallExp> whenInvocations = new ArrayList<RelationCallExp>();
    private final @NonNull List<@NonNull RelationCallExp> whereInvocations = new ArrayList<RelationCallExp>();
    protected final @NonNull Map<@NonNull String, @NonNull Element2TraceProperty> name2element2traceProperty = new HashMap<String, Element2TraceProperty>();
    private @Nullable Class bagOfTraceClass = null;
    private @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableDeclaration2TraceProperty> variable2variableDeclaration2traceProperty = new HashMap<VariableDeclaration, VariableDeclaration2TraceProperty>();
    private @NonNull Map<@NonNull RelationCallExp, @NonNull Invocation2TraceProperty> invocation2invocation2traceProperty = new HashMap<RelationCallExp, Invocation2TraceProperty>();

    protected AbstractRelation2TraceClass(@NonNull RelationalTransformation2TracePackage relationalTransformation2tracePackage, @NonNull Relation relation) {
        Pattern wherePattern;
        this.relationalTransformation2tracePackage = relationalTransformation2tracePackage;
        this.relation = relation;
        String traceClassName = relationalTransformation2tracePackage.getNameGenerator().createTraceClassName(relation);
        this.traceClass = PivotUtil.createClass((String)relationalTransformation2tracePackage.getUniqueTraceClassName(this, traceClassName));
        this.traceClass.setIsAbstract(relation.isIsAbstract());
        Pattern whenPattern = relation.getWhen();
        if (whenPattern != null) {
            for (EObject whenExpression : new TreeIterable((EObject)whenPattern, false)) {
                if (!(whenExpression instanceof RelationCallExp)) continue;
                this.whenInvocations.add((RelationCallExp)whenExpression);
            }
        }
        if ((wherePattern = relation.getWhere()) != null) {
            for (EObject whereExpression : new TreeIterable((EObject)wherePattern, false)) {
                if (!(whereExpression instanceof RelationCallExp)) continue;
                this.whereInvocations.add((RelationCallExp)whereExpression);
            }
        }
    }

    @Override
    public void addConsumedBy(@NonNull Relation2TraceClass consumedByRelation2TraceClass) {
        if (!this.consumedByRelation2TraceClasses.contains(consumedByRelation2TraceClass)) {
            this.consumedByRelation2TraceClasses.add(consumedByRelation2TraceClass);
        }
        consumedByRelation2TraceClass.addConsumedInternal(this);
    }

    @Override
    public void addConsumedInternal(@NonNull Relation2TraceClass consumedRelation2TraceClass) {
        if (!this.consumedRelation2TraceClasses.contains(consumedRelation2TraceClass)) {
            this.consumedRelation2TraceClasses.add(consumedRelation2TraceClass);
        }
    }

    @Override
    public void analyzeInheritance() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyzePredicateVariables(@NonNull Pattern rPattern) {
        for (Predicate rPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)rPattern)) {
            OCLExpression rConditionExpression = QVTrelationUtil.getConditionExpression((Predicate)rPredicate);
            if (!(rConditionExpression instanceof RelationCallExp)) continue;
            RelationCallExp rInvocation = (RelationCallExp)rConditionExpression;
            @NonNull List rArguments = QVTrelationUtil.Internal.getOwnedArgumentsList((RelationCallExp)rInvocation);
            int i = 0;
            while (i < rArguments.size()) {
                OCLExpression rArgument = (OCLExpression)rArguments.get(i);
                if (rArgument instanceof VariableExp) {
                    Variable rVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rArgument));
                    RelationDomain rDomain = QVTrelationUtil.getRelationCallExpArgumentDomain((RelationCallExp)rInvocation, (int)i);
                    this.getVariableDeclaration2TraceProperty(rDomain.getTypedModel(), (VariableDeclaration)rVariable, false);
                }
                ++i;
            }
        }
    }

    @Override
    public void analyzeProperties() throws CompilerChainException {
        Pattern rWherePattern;
        boolean manyTraces;
        boolean bl = manyTraces = this.hasManyRootMatches() || this.hasCollectionMemberMatches() || this.hasMultiObjectMatches();
        if (!manyTraces) {
            for (Variable rVariable : QVTrelationUtil.getOwnedVariables((Relation)this.relation)) {
                if (!this.hasManyVariableMatches(rVariable)) continue;
                manyTraces = true;
                break;
            }
        }
        for (Variable rVariable : QVTrelationUtil.getOwnedVariables((Relation)this.relation)) {
            if (rVariable instanceof IteratorVariable || rVariable instanceof TemplateVariable || rVariable.isIsImplicit()) continue;
            this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)rVariable, false);
        }
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            TypedModel rTypedModel = rDomain.getTypedModel();
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rDomain)) {
                TemplateExp rTemplateExp = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)rDomainPattern);
                Variable bindsTo = QVTrelationUtil.getBindsTo((TemplateExp)rTemplateExp);
                this.getVariableDeclaration2TraceProperty(rTypedModel, (VariableDeclaration)bindsTo, !manyTraces);
            }
        }
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rDomain)) {
                TemplateExp rTemplateExp = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)rDomainPattern);
                TypedModel rTypedModel = QVTrelationUtil.getTypedModel((Domain)rDomain);
                this.analyzeTemplateVariables(rTemplateExp, rTypedModel, !manyTraces);
            }
        }
        Pattern rWhenPattern = this.relation.getWhen();
        if (rWhenPattern != null) {
            this.analyzePredicateVariables(rWhenPattern);
        }
        if ((rWherePattern = this.relation.getWhere()) != null) {
            this.analyzePredicateVariables(rWherePattern);
        }
    }

    private void analyzeTemplateVariables(@NonNull TemplateExp templateExp, @NonNull TypedModel rTypedModel, boolean isOneToOne) {
        block6: {
            block7: {
                Variable templateVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                if (!this.variable2variableDeclaration2traceProperty.containsKey(templateVariable)) break block6;
                if (!(templateExp instanceof ObjectTemplateExp)) break block7;
                for (PropertyTemplateItem rPropertyTemplateItem : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)((ObjectTemplateExp)templateExp))) {
                    Variable itemVariable;
                    OCLExpression valueExpression;
                    Property oppositeProperty;
                    boolean isNestedOneToOne = false;
                    Property property = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)rPropertyTemplateItem);
                    if (!property.isIsMany() && (oppositeProperty = property.getOpposite()) != null && !oppositeProperty.isIsMany()) {
                        isNestedOneToOne = isOneToOne;
                    }
                    if ((valueExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)rPropertyTemplateItem)) instanceof TemplateExp) {
                        TemplateExp templateValueExpression = (TemplateExp)valueExpression;
                        itemVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateValueExpression);
                        if (QVTrelationUtil.getElementalType((Type)QVTrelationUtil.getType((TypedElement)itemVariable)) instanceof DataType) {
                            this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, false);
                            continue;
                        }
                        this.getVariableDeclaration2TraceProperty(rTypedModel, (VariableDeclaration)itemVariable, isNestedOneToOne);
                        this.analyzeTemplateVariables(templateValueExpression, rTypedModel, isOneToOne);
                        continue;
                    }
                    if (!(valueExpression instanceof VariableExp)) continue;
                    VariableExp variableExpression = (VariableExp)valueExpression;
                    itemVariable = QVTrelationUtil.getReferredVariable((VariableExp)variableExpression);
                    this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, isNestedOneToOne);
                }
                break block6;
            }
            if (!(templateExp instanceof CollectionTemplateExp)) break block6;
            for (OCLExpression memberExpression : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)((CollectionTemplateExp)templateExp))) {
                Variable itemVariable;
                if (memberExpression instanceof TemplateExp) {
                    TemplateExp templateValueExpression = (TemplateExp)memberExpression;
                    itemVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateValueExpression);
                    this.getVariableDeclaration2TraceProperty(rTypedModel, (VariableDeclaration)itemVariable, false);
                    this.analyzeTemplateVariables(templateValueExpression, rTypedModel, false);
                    continue;
                }
                if (!(memberExpression instanceof VariableExp)) continue;
                VariableExp variableExpression = (VariableExp)memberExpression;
                itemVariable = QVTrelationUtil.getReferredVariable((VariableExp)variableExpression);
                this.getVariableDeclaration2TraceProperty(null, (VariableDeclaration)itemVariable, false);
            }
        }
    }

    @Override
    public @Nullable Class basicGetSignatureClass() {
        return this.signatureClass;
    }

    @Override
    public @Nullable Property basicGetTraceProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty = this.variable2variableDeclaration2traceProperty.get(rVariable);
        if (variableDeclaration2traceProperty == null) {
            return null;
        }
        return variableDeclaration2traceProperty.getTraceProperty();
    }

    @Override
    public int compareTo(@NonNull Relation2TraceClass that) {
        return ClassUtil.safeCompareTo((Comparable)((Object)this.traceClass.getName()), (Comparable)((Object)that.getTraceClass().getName()));
    }

    public @NonNull Property createProperty(@Nullable TypedModel rTypedModel, @NonNull Class owningClass, @NonNull String name, @NonNull Class type, boolean isRequired, boolean unitOpposite) {
        String domainName = rTypedModel != null ? rTypedModel.getName() : null;
        Property traceProperty = PivotFactory.eINSTANCE.createProperty();
        traceProperty.setName(name);
        traceProperty.setType((Type)type);
        traceProperty.setIsRequired(isRequired);
        if (domainName != null) {
            Annotation domainAnnotation = PivotFactory.eINSTANCE.createAnnotation();
            domainAnnotation.setName("http://www.eclipse.org/qvt#Domains");
            Detail domainDetail = PivotFactory.eINSTANCE.createDetail();
            domainDetail.setName("referredDomain");
            domainDetail.getValues().add(domainName);
            domainAnnotation.getOwnedDetails().add(domainDetail);
            traceProperty.getOwnedAnnotations().add(domainAnnotation);
        }
        traceProperty.setOwningClass(owningClass);
        if (!(type instanceof DataType)) {
            Property oppositeProperty = PivotFactory.eINSTANCE.createProperty();
            oppositeProperty.setName(owningClass.getName());
            oppositeProperty.setType((Type)(unitOpposite ? this.traceClass : this.getBagOfTraceClass()));
            oppositeProperty.setIsRequired(!unitOpposite);
            oppositeProperty.setIsImplicit(true);
            oppositeProperty.setOwningClass(type);
            traceProperty.setOpposite(oppositeProperty);
            oppositeProperty.setOpposite(traceProperty);
        }
        return traceProperty;
    }

    @Override
    public @NonNull Class getBagOfTraceClass() {
        Class bagOfTraceClass2 = this.bagOfTraceClass;
        if (bagOfTraceClass2 == null) {
            this.bagOfTraceClass = bagOfTraceClass2 = this.relationalTransformation2tracePackage.getBagType(this.traceClass);
        }
        return bagOfTraceClass2;
    }

    @Override
    public @Nullable Iterable<@NonNull Relation2TraceClass> getConsumedByRelation2TraceClasses() {
        return this.consumedByRelation2TraceClasses;
    }

    @Override
    public @Nullable Iterable<@NonNull Relation2TraceClass> getConsumedRelation2TraceClasses() {
        return this.consumedRelation2TraceClasses;
    }

    @Override
    public @Nullable Iterable<@NonNull Relation2TraceClass> getCyclicRelation2TraceClasses() {
        return this.cyclicRelation2TraceClasses;
    }

    private Invocation2TraceProperty getInvocation2TraceProperty(@NonNull String name, @NonNull RelationCallExp rInvocation) {
        Invocation2TraceProperty invocation2TraceProperty = new Invocation2TraceProperty(this, name, rInvocation);
        invocation2TraceProperty.getTraceProperty();
        Invocation2TraceProperty oldInvocation2TraceProperty = this.invocation2invocation2traceProperty.put(rInvocation, invocation2TraceProperty);
        assert (oldInvocation2TraceProperty == null);
        return invocation2TraceProperty;
    }

    @Override
    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.relationalTransformation2tracePackage.getNameGenerator();
    }

    @Override
    public @NonNull Relation getRelation() {
        return this.relation;
    }

    @Override
    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage() {
        return this.relationalTransformation2tracePackage;
    }

    @Override
    public @NonNull Class getSignatureClass() {
        Class signatureClass2 = this.signatureClass;
        if (signatureClass2 == null) {
            String name = this.relationalTransformation2tracePackage.getNameGenerator().createSignatureClassName(this.traceClass);
            this.signatureClass = signatureClass2 = PivotUtil.createClass((String)this.relationalTransformation2tracePackage.getUniqueTraceClassName(this, name));
        }
        return signatureClass2;
    }

    @Override
    public @NonNull Property getSignatureProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.variable2variableDeclaration2traceProperty.get(rVariable);
        assert (variableDeclaration2TraceProperty != null);
        return variableDeclaration2TraceProperty.getSignatureProperty();
    }

    @Override
    public @NonNull Class getTraceClass() {
        return this.traceClass;
    }

    @Override
    public @NonNull Property getTraceProperty(@NonNull RelationCallExp rInvocation) {
        Invocation2TraceProperty invocation2TraceProperty = this.invocation2invocation2traceProperty.get(rInvocation);
        assert (invocation2TraceProperty != null);
        return invocation2TraceProperty.getTraceProperty();
    }

    @Override
    public @NonNull Set<@NonNull Relation2TraceClass> getTransitivelyConsumedByRelation2TraceClasses() {
        Set<@NonNull Relation2TraceClass> transitivelyConsumedByRelation2TraceClasses2 = this.transitivelyConsumedByRelation2TraceClasses;
        if (transitivelyConsumedByRelation2TraceClasses2 == null) {
            transitivelyConsumedByRelation2TraceClasses2 = this.getTransitivelyConsumedByRelation2TraceClasses(new HashSet<Relation2TraceClass>());
        }
        return transitivelyConsumedByRelation2TraceClasses2;
    }

    @Override
    public @NonNull Set<@NonNull Relation2TraceClass> getTransitivelyConsumedByRelation2TraceClasses(@NonNull Set<@NonNull Relation2TraceClass> accumulator) {
        Set<@NonNull Relation2TraceClass> transitivelyConsumedByRelation2TraceClasses2 = this.transitivelyConsumedByRelation2TraceClasses;
        if (transitivelyConsumedByRelation2TraceClasses2 != null) {
            accumulator.addAll(transitivelyConsumedByRelation2TraceClasses2);
        } else {
            for (Relation2TraceClass consumedByRelation2TraceClass : this.consumedByRelation2TraceClasses) {
                if (!accumulator.add(consumedByRelation2TraceClass)) continue;
                consumedByRelation2TraceClass.getTransitivelyConsumedByRelation2TraceClasses(accumulator);
            }
        }
        return accumulator;
    }

    @Override
    public @NonNull Set<@NonNull Relation2TraceClass> getTransitivelyConsumedRelation2TraceClasses() {
        Set<@NonNull Relation2TraceClass> transitivelyConsumedRelation2TraceClasses2 = this.transitivelyConsumedRelation2TraceClasses;
        if (transitivelyConsumedRelation2TraceClasses2 == null) {
            transitivelyConsumedRelation2TraceClasses2 = this.getTransitivelyConsumedRelation2TraceClasses(new HashSet<Relation2TraceClass>());
        }
        return transitivelyConsumedRelation2TraceClasses2;
    }

    @Override
    public @NonNull Set<@NonNull Relation2TraceClass> getTransitivelyConsumedRelation2TraceClasses(@NonNull Set<@NonNull Relation2TraceClass> accumulator) {
        Set<@NonNull Relation2TraceClass> transitivelyConsumedRelation2TraceClasses2 = this.transitivelyConsumedRelation2TraceClasses;
        if (transitivelyConsumedRelation2TraceClasses2 != null) {
            accumulator.addAll(transitivelyConsumedRelation2TraceClasses2);
        } else {
            for (Relation2TraceClass consumedRelation2TraceClass : this.consumedRelation2TraceClasses) {
                if (!accumulator.add(consumedRelation2TraceClass)) continue;
                consumedRelation2TraceClass.getTransitivelyConsumedRelation2TraceClasses(accumulator);
            }
        }
        return accumulator;
    }

    @Override
    public @NonNull String getUniqueTracePropertyName(@NonNull Element2TraceProperty variableDeclaration2TraceProperty, @NonNull String name) {
        return this.relationalTransformation2tracePackage.getNameGenerator().getUniqueName(this.name2element2traceProperty, name, variableDeclaration2TraceProperty);
    }

    private @NonNull VariableDeclaration2TraceProperty getVariableDeclaration2TraceProperty(@Nullable TypedModel rTypedModel, @NonNull VariableDeclaration variable, boolean isNestedOneToOne) {
        VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.variable2variableDeclaration2traceProperty.get(variable);
        if (variableDeclaration2TraceProperty != null) {
            variableDeclaration2TraceProperty.refineTraceProperty(rTypedModel, isNestedOneToOne);
        } else {
            variableDeclaration2TraceProperty = new VariableDeclaration2TraceProperty((Relation2TraceClass)this, rTypedModel, variable, isNestedOneToOne);
            this.variable2variableDeclaration2traceProperty.put(variable, variableDeclaration2TraceProperty);
        }
        return variableDeclaration2TraceProperty;
    }

    @Override
    public @NonNull Iterable<@NonNull RelationCallExp> getWhenInvocations() {
        return this.whenInvocations;
    }

    @Override
    public @NonNull Iterable<@NonNull RelationCallExp> getWhereInvocations() {
        return this.whereInvocations;
    }

    private boolean hasCollectionMemberMatches() {
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            EList members;
            if (!(eObject instanceof CollectionTemplateExp) || (members = ((CollectionTemplateExp)eObject).getMember()).size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean hasManyRootMatches() {
        @NonNull List rDomains = QVTrelationUtil.Internal.getOwnedDomainsList((Relation)this.relation);
        if (rDomains.size() > 2) {
            return true;
        }
        for (Domain rDomain : rDomains) {
            EList rootVariables = ((RelationDomain)rDomain).getRootVariable();
            if (rootVariables.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasManyVariableMatches(@NonNull Variable rVariable) {
        for (Domain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            Iterable<@NonNull Variable> bindsTo = QVTr2QVTcUtil.getRelationDomainBindsTo((RelationDomain)rDomain);
            if (!Iterables.contains(bindsTo, (Object)rVariable)) continue;
            return false;
        }
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            EObject eContainer;
            VariableDeclaration referredVariable;
            if (!(eObject instanceof VariableExp) || (referredVariable = ((VariableExp)eObject).getReferredVariable()) != rVariable || !((eContainer = eObject.eContainer()) instanceof OperationCallExp)) continue;
            OperationCallExp operationCallExp = (OperationCallExp)eContainer;
            Operation referredOperation = operationCallExp.getReferredOperation();
            assert (referredOperation != null);
            if (!operationCallExp.getOwnedArguments().equals(Collections.singletonList(eObject)) || !"includes".equals(referredOperation.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiObjectMatches() {
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            Property referredProperty;
            if (!(eObject instanceof PropertyTemplateItem) || !(referredProperty = ((PropertyTemplateItem)eObject).getReferredProperty()).isIsMany()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void installConsumesDependencies() throws CompilerChainException {
    }

    @Override
    public void synthesize() {
        String name;
        Relation invokedRelation;
        Element2TraceProperty vd2tp;
        for (VariableDeclaration variableDeclaration : this.variable2variableDeclaration2traceProperty.keySet()) {
            vd2tp = this.variable2variableDeclaration2traceProperty.get(variableDeclaration);
            assert (vd2tp != null);
            vd2tp.getTraceProperty();
        }
        for (RelationCallExp relationCallExp : this.invocation2invocation2traceProperty.keySet()) {
            vd2tp = this.invocation2invocation2traceProperty.get(relationCallExp);
            assert (vd2tp != null);
            vd2tp.getTraceProperty();
        }
        for (RelationCallExp relationCallExp : this.getWhenInvocations()) {
            invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationCallExp);
            if (invokedRelation.isIsTopLevel()) continue;
            name = this.getNameGenerator().createWhenInvocationPropertyName(invokedRelation);
            this.getInvocation2TraceProperty(name, relationCallExp);
        }
        for (RelationCallExp relationCallExp : this.getWhereInvocations()) {
            invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationCallExp);
            if (invokedRelation.isIsTopLevel()) continue;
            name = this.getNameGenerator().createWhereInvocationPropertyName(invokedRelation);
            this.getInvocation2TraceProperty(name, relationCallExp);
        }
        CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedPropertiesList((Class)this.traceClass));
        Class clazz = this.basicGetSignatureClass();
        if (clazz != null) {
            for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
                for (Variable rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)rDomain)) {
                    VariableDeclaration2TraceProperty rootVariableDeclaration2TraceProperty = this.variable2variableDeclaration2traceProperty.get(rootVariable);
                    assert (rootVariableDeclaration2TraceProperty != null);
                    rootVariableDeclaration2TraceProperty.getSignatureProperty();
                }
            }
            CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedPropertiesList((Class)clazz));
        }
    }

    public String toString() {
        return this.traceClass.getName();
    }
}

