/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.MappingAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDatum;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyPaths;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyStep;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EarlyMerger;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.impl.OperationRegionImpl;

public class QVTm2QVTs
extends ScheduleManager {
    public static final @NonNull TracingOption CALL_TREE = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/callTree");
    public static final @NonNull TracingOption DEBUG_GRAPHS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/debugGraphs");
    public static final @NonNull TracingOption DUMP_CLASS_TO_CONSUMING_NODES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/dump/class2consumingNodes");
    public static final @NonNull TracingOption DUMP_CLASS_TO_CONTAINING_PROPERTIES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/dump/class2containingProperty");
    public static final @NonNull TracingOption DUMP_CLASS_TO_REALIZED_NODES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/dump/class2realizedNodes");
    public static final @NonNull TracingOption DUMP_INPUT_MODEL_TO_DOMAIN_USAGE = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/dump/inputModel2domainUsage");
    public static final @NonNull TracingOption DUMP_PROPERTY_TO_CONSUMING_CLASSES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/dump/property2consumingClass");
    public static final @NonNull TracingOption EDGE_ORDER = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/edgeOrder");
    public static final @NonNull TracingOption REGION_CYCLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/regionCycles");
    public static final @NonNull TracingOption REGION_DEPTH = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/regionDepth");
    public static final @NonNull TracingOption REGION_ORDER = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/regionOrder");
    public static final @NonNull TracingOption REGION_STACK = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/regionStack");
    public static final @NonNull TracingOption REGION_TRAVERSAL = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvts/regionTraversal");
    protected final @NonNull ProblemHandler problemHandler;
    private final @NonNull Map<@NonNull Mapping, @NonNull MappingAnalysis> mapping2mappingAnalysis = new HashMap<Mapping, MappingAnalysis>();
    private Map<@NonNull OperationDatum, @NonNull OperationRegion> operationDatum2operationRegion = new HashMap<OperationDatum, OperationRegion>();

    public QVTm2QVTs(@NonNull ProblemHandler problemHandler, @NonNull EnvironmentFactory environmentFactory, @NonNull Transformation asTransformation, @Nullable Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions) {
        super(QVTscheduleFactory.eINSTANCE.createScheduleModel(), environmentFactory, asTransformation, schedulerOptions);
        this.problemHandler = problemHandler;
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    @Override
    public void addRegionError(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        this.addProblem(RegionUtil.createRegionError(region, messageTemplate, bindings));
    }

    public @NonNull OperationRegion analyzeOperation(@NonNull ScheduleManager scheduleManager, @NonNull OperationCallExp operationCallExp) {
        Operation operation = operationCallExp.getReferredOperation();
        LanguageExpression bodyExpression = operation.getBodyExpression();
        assert (bodyExpression != null);
        try {
            ExpressionInOCL specification = this.getEnvironmentFactory().getMetamodelManager().parseSpecification(bodyExpression);
            OperationDatum operationDatum = this.createOperationDatum(operationCallExp);
            OperationRegion operationRegion = this.operationDatum2operationRegion.get(operationDatum);
            if (operationRegion == null) {
                operationRegion = this.createOperationRegion(scheduleManager, operationCallExp, specification, operationDatum);
                this.operationDatum2operationRegion.put(operationDatum, operationRegion);
                if (DEBUG_GRAPHS.isActive()) {
                    scheduleManager.writeDebugGraphs((Region)operationRegion, null);
                }
            }
            return operationRegion;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull OperationDatum createOperationDatum(@NonNull OperationCallExp operationCallExp) {
        @NonNull List ownedArguments = ClassUtil.nullFree((List)operationCallExp.getOwnedArguments());
        @NonNull ClassDatum[] classDatums = new ClassDatum[1 + ownedArguments.size()];
        int i = 0;
        @NonNull OCLExpression source = operationCallExp.getOwnedSource();
        classDatums[i++] = this.getClassDatum((TypedElement)source);
        for (OCLExpression argument : ownedArguments) {
            classDatums[i++] = this.getClassDatum((TypedElement)argument);
        }
        String operationName = operationCallExp.getReferredOperation().getName();
        assert (operationName != null);
        return new OperationDatum(this, operationName, classDatums);
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegion operationRegion, @NonNull Variable variable, @NonNull String name, @NonNull OCLExpression expression) {
        Class type = (Class)expression.getType();
        assert (type != null);
        TypedModel typedModel = this.getDomainUsage((Element)expression).getTypedModel((Element)expression);
        assert (typedModel != null);
        ClassDatumAnalysis classDatumAnalysis = this.getClassDatumAnalysis(type, typedModel);
        Node parameterNode = RegionUtil.createOperationParameterNode((Region)operationRegion, name, classDatumAnalysis);
        operationRegion.addHeadNode(parameterNode);
        return parameterNode;
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegion operationRegion, @NonNull ClassDatumAnalysis classDatumAnalysis, @NonNull String name) {
        Node parameterNode = RegionUtil.createOperationParameterNode((Region)operationRegion, name, classDatumAnalysis);
        operationRegion.addHeadNode(parameterNode);
        return parameterNode;
    }

    protected @NonNull OperationRegion createOperationRegion(@NonNull ScheduleManager scheduleManager, @NonNull OperationCallExp operationCallExp, @NonNull ExpressionInOCL specification, @NonNull OperationDatum operationDatum) {
        HashMap<@NonNull Variable, @NonNull Node> parameter2node = new HashMap<Variable, Node>();
        String operationName = (String)ClassUtil.nonNullState((Object)operationDatum.toString());
        OperationRegion operationRegion = QVTscheduleFactory.eINSTANCE.createOperationRegion();
        ((OperationRegionImpl)operationRegion).setFixmeScheduleModel(scheduleManager.getScheduleModel());
        operationRegion.setReferredOperation((Operation)ClassUtil.nonNullState((Object)operationCallExp.getReferredOperation()));
        operationRegion.setName(operationName);
        Variable selfVariable = specification.getOwnedContext();
        OCLExpression source = operationCallExp.getOwnedSource();
        assert (source != null);
        Node selfNode = this.createOperationParameterNode(operationRegion, selfVariable, (String)ClassUtil.nonNullState((Object)selfVariable.getName()), source);
        parameter2node.put(selfVariable, selfNode);
        Node dependencyNode = selfNode;
        Node resultNode = RegionUtil.createStepNode("result", (CallExp)operationCallExp, dependencyNode, false);
        operationRegion.setResultNode(resultNode);
        RegionUtil.createExpressionEdge(dependencyNode, "\u00abreturn\u00bb", resultNode);
        List ownedParameters = specification.getOwnedParameters();
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = Math.min(ownedArguments.size(), ownedParameters.size());
        int i = 0;
        while (i < iSize) {
            Variable parameter = (Variable)ownedParameters.get(i);
            Node parameterNode = this.createOperationParameterNode(operationRegion, parameter, (String)ClassUtil.nonNullState((Object)parameter.getName()), (OCLExpression)ClassUtil.nonNullState((Object)((OCLExpression)ownedArguments.get(i))));
            parameter2node.put(parameter, parameterNode);
            ++i;
        }
        OperationDependencyAnalysis operationDependencyAnalysis = this.getOperationDependencyAnalysis();
        OperationDependencyPaths paths = operationDependencyAnalysis.analyzeOperation(operationCallExp);
        Iterable<@NonNull List<OperationDependencyStep>> hiddenPaths = paths.getHiddenPaths();
        Iterable<@NonNull List<OperationDependencyStep>> returnPaths = paths.getReturnPaths();
        RootDomainUsageAnalysis domainAnalysis = this.getDomainAnalysis();
        HashMap<@NonNull ClassDatumAnalysis, @NonNull Node> classDatumAnalysis2node = new HashMap<ClassDatumAnalysis, Node>();
        for (List steps : Iterables.concat(returnPaths, hiddenPaths)) {
            Node dependencyNode2;
            if (steps.size() <= 0) continue;
            boolean isDirty = false;
            int i2 = 1;
            while (i2 < steps.size()) {
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i2);
                Property asProperty = step.getProperty();
                if (domainAnalysis.isDirty(asProperty)) {
                    isDirty = true;
                    break;
                }
                ++i2;
            }
            OperationDependencyStep.ClassStep classStep = (OperationDependencyStep.ClassStep)steps.get(0);
            DomainUsage stepUsage = classStep.getUsage();
            if ((!stepUsage.isOutput() || stepUsage.isInput()) && !isDirty) continue;
            Class stepType = ((OperationDependencyStep)steps.get(0)).getElementalType();
            TypedModel typedModel = stepUsage.getTypedModel(classStep.getElement());
            assert (typedModel != null);
            ClassDatumAnalysis classDatumAnalysis = this.getClassDatumAnalysis(stepType, typedModel);
            CompleteClass completeClass = classDatumAnalysis.getClassDatum().getCompleteClass();
            Class primaryClass = completeClass.getPrimaryClass();
            if (primaryClass instanceof DataType || primaryClass instanceof VoidType) continue;
            if (classStep.isParameter()) {
                dependencyNode2 = (Node)parameter2node.get(classStep.getElement());
                assert (dependencyNode2 != null);
            } else {
                dependencyNode2 = (Node)classDatumAnalysis2node.get(classDatumAnalysis);
                if (dependencyNode2 == null) {
                    assert (!"OclVoid".equals(stepType.getName()));
                    dependencyNode2 = this.createOperationParameterNode(operationRegion, classDatumAnalysis, "extra2_" + stepType.getName());
                    classDatumAnalysis2node.put(classDatumAnalysis, dependencyNode2);
                    operationRegion.addDependencyNode(dependencyNode2);
                }
            }
            int i3 = 1;
            while (i3 < steps.size()) {
                Node nextNode;
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i3);
                Property property = step.getProperty();
                CallExp callExp = step.getCallExp();
                assert (property != null && callExp != null);
                if (primaryClass instanceof CollectionType) {
                    Property iterateProperty = this.getIterateProperty((Type)primaryClass);
                    Type elementType = PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
                    TypedModel typedModel2 = RegionUtil.getTypedModel(classDatumAnalysis);
                    ClassDatumAnalysis elementClassDatumAnalysis = this.getClassDatumAnalysis((Class)elementType, typedModel2);
                    Node elementNode = RegionUtil.createOperationElementNode((Region)operationRegion, operationName, elementClassDatumAnalysis, dependencyNode2);
                    RegionUtil.createNavigationEdge(dependencyNode2, iterateProperty, elementNode, false);
                    dependencyNode2 = elementNode;
                }
                if (callExp instanceof NavigationCallExp) {
                    String name = RegionUtil.recoverVariableName((NamedElement)callExp);
                    if (name == null) {
                        name = QVTcoreUtil.getName((NamedElement)QVTcoreUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp)));
                    }
                    nextNode = RegionUtil.createDataTypeNode(name, dependencyNode2, (NavigationCallExp)callExp);
                } else {
                    nextNode = RegionUtil.createDataTypeNode(dependencyNode2, property);
                }
                RegionUtil.createNavigationEdge(dependencyNode2, property, nextNode, false);
                dependencyNode2 = nextNode;
                ++i3;
            }
        }
        operationRegion.toGraph((GraphStringBuilder)new DOTStringBuilder());
        operationRegion.toGraph((GraphStringBuilder)new GraphMLStringBuilder());
        return operationRegion;
    }

    @Override
    protected @NonNull ClassDatumAnalysis createClassDatumAnalysis(@NonNull ClassDatum classDatum) {
        return new ClassDatumAnalysis(this, classDatum);
    }

    public @NonNull MappingRegion getMappingRegion(@NonNull Mapping mapping) {
        MappingAnalysis mappingAnalysis = this.mapping2mappingAnalysis.get(mapping);
        assert (mappingAnalysis != null);
        return mappingAnalysis.getMappingRegion();
    }

    public @NonNull List<@NonNull Region> transform() throws IOException {
        Iterable<@NonNull Mapping> orderedMappings = this.getOrderedMappings();
        for (Mapping mapping : orderedMappings) {
            Iterator mappingRegion = MappingAnalysis.createMappingRegion(this, mapping);
            this.mapping2mappingAnalysis.put(mapping, (MappingAnalysis)((Object)mappingRegion));
        }
        ArrayList<@NonNull MappingAnalysis> mappingAnalyses = new ArrayList<MappingAnalysis>(this.mapping2mappingAnalysis.values());
        Collections.sort(mappingAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (MappingAnalysis mappingRegion : mappingAnalyses) {
            mappingRegion.registerConsumptionsAndProductions(this);
        }
        if (DEBUG_GRAPHS.isActive()) {
            for (MappingAnalysis mappingAnalysis : mappingAnalyses) {
                this.writeDebugGraphs((Region)mappingAnalysis.getMappingRegion(), null);
            }
        }
        ArrayList<@NonNull MappingRegion> orderedRegions = new ArrayList<MappingRegion>();
        for (Mapping mapping : orderedMappings) {
            MappingAnalysis mappingAnalysis = this.mapping2mappingAnalysis.get(mapping);
            assert (mappingAnalysis != null);
            orderedRegions.add(mappingAnalysis.getMappingRegion());
        }
        boolean noEarlyMerge = this.isNoEarlyMerge();
        ArrayList<@NonNull MappingRegion> activeRegions = new ArrayList<MappingRegion>(noEarlyMerge ? orderedRegions : EarlyMerger.merge(orderedRegions));
        return activeRegions;
    }
}

