/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rm.ibm.lsf.ui.LSFCommand;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;

public class LSFQueuesCommand
extends LSFCommand {
    private final boolean isInteractiveSession;

    public LSFQueuesCommand(String name, IRemoteConnection connection, String[] cmd, boolean isInteractive) {
        super(name, connection, cmd);
        this.isInteractiveSession = isInteractive;
    }

    @Override
    protected LSFCommand.StdoutReader createStdoutReader(IRemoteProcess process, IProgressMonitor monitor) {
        return new QueueStdoutReader(process, monitor);
    }

    protected class QueueStdoutReader
    extends LSFCommand.StdoutReader {
        public QueueStdoutReader(IRemoteProcess proc, IProgressMonitor m) {
            super(LSFQueuesCommand.this, proc, m);
            this.setName("LSF bqueues stdout reader");
        }

        @Override
        public void run() {
            try {
                String[] columnData;
                this.stdoutStream = this.targetProcess.getInputStream();
                LSFCommand.RemoteStreamReader reader = new LSFCommand.RemoteStreamReader(LSFQueuesCommand.this, this.stdoutStream);
                ArrayList<String> stdoutData = reader.getData(this.monitor);
                if (this.monitor.isCanceled()) {
                    this.resultStatus = new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
                }
                this.commandResponse = new Vector();
                boolean headerProcessed = false;
                boolean headerNext = false;
                boolean queueDataNext = false;
                boolean batchQueueAllowed = true;
                boolean interactiveQueueAllowed = true;
                String queueName = "";
                String queueData = null;
                for (String data : stdoutData) {
                    if (data.startsWith("QUEUE:")) {
                        if (queueData != null && (LSFQueuesCommand.this.isInteractiveSession && interactiveQueueAllowed || !LSFQueuesCommand.this.isInteractiveSession && batchQueueAllowed)) {
                            queueData = queueData.replaceAll(" +/ +", "/");
                            columnData = queueData.split(" +");
                            this.commandResponse.add(columnData);
                        }
                        queueName = data.substring(7).trim();
                        headerNext = false;
                        queueDataNext = false;
                        batchQueueAllowed = true;
                        interactiveQueueAllowed = true;
                        continue;
                    }
                    if (data.equals("PARAMETERS/STATISTICS")) {
                        headerNext = true;
                        continue;
                    }
                    if (headerNext) {
                        if (!headerProcessed) {
                            data = "QUEUE_NAME " + data;
                            this.columnLabels = data.split(" +");
                        }
                        headerNext = false;
                        headerProcessed = true;
                        queueDataNext = true;
                        continue;
                    }
                    if (queueDataNext) {
                        queueData = String.valueOf(queueName) + " " + data;
                        queueDataNext = false;
                        continue;
                    }
                    if (!data.startsWith("SCHEDULING POLICIES:")) continue;
                    if (data.contains("NO_INTERACTIVE")) {
                        interactiveQueueAllowed = false;
                        continue;
                    }
                    if (!data.contains("ONLY_INTERACTIVE")) continue;
                    batchQueueAllowed = false;
                }
                if (queueData != null && (LSFQueuesCommand.this.isInteractiveSession && interactiveQueueAllowed || !LSFQueuesCommand.this.isInteractiveSession && batchQueueAllowed)) {
                    queueData = queueData.replaceAll(" +/ +", "/");
                    columnData = queueData.split(" +");
                    this.commandResponse.add(columnData);
                }
                this.stdoutStream.close();
            }
            catch (IOException e) {
                this.resultStatus = new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.LSFQueuesCommand_7, (Throwable)e);
            }
            this.resultStatus = new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
        }

        @Override
        public IStatus getResultStatus() {
            return this.resultStatus;
        }

        @Override
        public String[] getColumnLabels() {
            if (this.columnLabels == null) {
                this.columnLabels = new String[0];
            }
            return this.columnLabels;
        }

        @Override
        public Vector<String[]> getCommandResponse() {
            if (this.commandResponse == null) {
                this.commandResponse = new Vector();
            }
            return this.commandResponse;
        }
    }
}

