/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessService;

public class LSFCommand
implements IRunnableWithProgress {
    private static final int THREAD_TIMEOUT = 10000;
    private final String[] command;
    private final String commandDescription;
    private final IRemoteConnection remoteConnection;
    protected Vector<String[]> commandResponse;
    protected String[] columnLabels;
    public static final int OK = 0;
    public static final int COMMAND_ERROR = 3;
    public static final int CANCELED = 2;
    public static final int NO_DATA = 3;
    protected IRemoteProcess process;
    protected IStatus runStatus;
    private StdoutReader stdoutReader;
    private StderrReader stderrReader;

    public LSFCommand(String name, IRemoteConnection connection, String[] cmd) {
        this.commandDescription = name;
        this.remoteConnection = connection;
        this.command = cmd;
        this.commandResponse = new Vector();
    }

    public void run(IProgressMonitor monitor) {
        monitor.beginTask(this.commandDescription, -1);
        this.runStatus = this.runCommand(monitor);
        monitor.done();
    }

    /*
     * Unable to fully structure code
     */
    protected IStatus runCommand(IProgressMonitor monitor) {
        processService = (IRemoteProcessService)this.remoteConnection.getService(IRemoteProcessService.class);
        processBuilder = processService.getProcessBuilder(this.command);
        this.process = null;
        try {
            block15: {
                this.process = processBuilder.start();
                this.stdoutReader = this.createStdoutReader(this.process, monitor);
                this.stdoutReader.setDaemon(true);
                this.stdoutReader.start();
                this.stderrReader = new StderrReader(this.process, monitor);
                this.stderrReader.setDaemon(true);
                this.stderrReader.start();
                while (!this.process.isCompleted()) {
                    if (monitor.isCanceled()) {
                        this.process.destroy();
                        return new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException var4_4) {}
                }
                this.stdoutReader.closeReader();
                this.stderrReader.closeReader();
                exitStatus = this.process.exitValue();
                if (!this.process.isCompleted()) break block15;
                startTime = System.currentTimeMillis();
                waitTime = 10000L;
                currentTime = startTime;
                if (exitStatus != 0) ** GOTO lbl44
                while (currentTime - startTime < 10000L) {
                    try {
                        this.stdoutReader.join(waitTime);
                        break block15;
                    }
                    catch (InterruptedException e) {
                        currentTime = System.currentTimeMillis();
                        waitTime = Math.max(0L, 10000L - (currentTime - startTime));
                    }
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.stderrReader.join(waitTime);
                        break;
                    }
                    catch (InterruptedException e) {
                        currentTime = System.currentTimeMillis();
                        waitTime = Math.max(0L, 10000L - (currentTime - startTime));
                    }
lbl44:
                    // 2 sources

                    ** while (currentTime - startTime < 10000L)
                }
            }
            this.columnLabels = this.stdoutReader.getColumnLabels();
            this.commandResponse = this.stdoutReader.getCommandResponse();
            if (exitStatus == 0) {
                stderrStatus = this.stderrReader.getResultStatus();
                if (stderrStatus.getSeverity() == 1) {
                    return stderrStatus;
                }
                return this.stdoutReader.getResultStatus();
            }
            errorStatus = this.stderrReader.getResultStatus();
            if (errorStatus.isOK()) {
                return new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, this.stderrReader.getErrorText(), null);
            }
            return errorStatus;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.LSFCommandFailed, (Throwable)e);
        }
    }

    protected StdoutReader createStdoutReader(IRemoteProcess process, IProgressMonitor monitor) {
        return new StdoutReader(process, monitor);
    }

    public Vector<String[]> getCommandResponse() {
        return this.commandResponse;
    }

    public String[] getColumnLabels() {
        return this.columnLabels;
    }

    public IStatus getRunStatus() {
        return this.runStatus;
    }

    protected class RemoteStreamReader {
        private static final float REALLOC_FACTOR = 1.5f;
        private static final int INITIAL_ALLOCATION = 100000;
        private InputStream remoteStream;
        private byte[] data;

        public RemoteStreamReader(InputStream stream) {
            this.remoteStream = stream;
            this.data = new byte[100000];
        }

        public ArrayList<String> getData(IProgressMonitor monitor) {
            int currentOffset = 0;
            try {
                while (!monitor.isCanceled()) {
                    int byteCount;
                    int bytesReady = Math.max(1, this.remoteStream.available());
                    if (currentOffset + bytesReady >= this.data.length) {
                        this.data = Arrays.copyOf(this.data, Math.max((int)((float)this.data.length * 1.5f), currentOffset + bytesReady));
                    }
                    if ((byteCount = this.remoteStream.read(this.data, currentOffset, bytesReady)) >= 0) {
                        currentOffset += byteCount;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException byteCount) {
                // empty catch block
            }
            ArrayList<String> streamOutput = new ArrayList<String>();
            currentOffset = 0;
            while (currentOffset < this.data.length && this.data[currentOffset] != 0) {
                int nlIndex = currentOffset;
                while (nlIndex < this.data.length && this.data[nlIndex] != 10 && this.data[nlIndex] != 0) {
                    ++nlIndex;
                }
                String s = new String(this.data, currentOffset, nlIndex - currentOffset);
                streamOutput.add(s);
                currentOffset = nlIndex + 1;
            }
            return streamOutput;
        }
    }

    private class StderrReader
    extends Thread {
        private IRemoteProcess targetProcess;
        private IProgressMonitor monitor;
        private IStatus resultStatus;
        private RemoteStreamReader reader;
        private InputStream stderrStream;
        private ArrayList<String> stderrData;

        public StderrReader(IRemoteProcess proc, IProgressMonitor m) {
            this.setName("LSF stderr reader");
            this.targetProcess = proc;
            this.monitor = m;
            this.resultStatus = new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
        }

        @Override
        public void run() {
            this.stderrStream = this.targetProcess.getErrorStream();
            this.reader = new RemoteStreamReader(this.stderrStream);
            this.stderrData = this.reader.getData(this.monitor);
            if (this.monitor.isCanceled()) {
                this.resultStatus = new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
            } else {
                boolean headerLine = true;
                for (String data : this.stderrData) {
                    if (!headerLine) continue;
                    if (data.equals("No application profiles found.")) {
                        this.resultStatus = new Status(1, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.NoProfileMessage, null);
                    }
                    headerLine = false;
                }
            }
        }

        public IStatus getResultStatus() {
            return this.resultStatus;
        }

        public String getErrorText() {
            StringBuilder errorText = new StringBuilder();
            for (String s : this.stderrData) {
                errorText.append(s);
                errorText.append("\n");
            }
            return errorText.toString();
        }

        public void closeReader() {
            if (this.stderrStream != null) {
                try {
                    this.stderrStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class StdoutReader
    extends Thread {
        protected IRemoteProcess targetProcess;
        protected IProgressMonitor monitor;
        protected String[] columnLabels;
        protected Vector<String[]> commandResponse;
        protected IStatus resultStatus;
        protected RemoteStreamReader reader;
        protected InputStream stdoutStream;

        public StdoutReader(IRemoteProcess proc, IProgressMonitor m) {
            this.setName("LSF stdout reader");
            this.targetProcess = proc;
            this.monitor = m;
            this.resultStatus = new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
        }

        @Override
        public void run() {
            this.stdoutStream = this.targetProcess.getInputStream();
            this.reader = new RemoteStreamReader(this.stdoutStream);
            ArrayList<String> stdoutData = this.reader.getData(this.monitor);
            if (this.monitor.isCanceled()) {
                this.resultStatus = new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
                return;
            }
            boolean headerLine = true;
            this.commandResponse = new Vector();
            for (String data : stdoutData) {
                if (headerLine) {
                    if (data.equals("No reservation found")) {
                        this.resultStatus = new Status(1, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.NoReservationMessage, null);
                    } else {
                        this.columnLabels = data.split(" +");
                        headerLine = false;
                    }
                } else {
                    data = data.replaceAll(" +/ +", "/");
                    String[] columnData = data.split(" +");
                    this.commandResponse.add(columnData);
                }
                if (!this.monitor.isCanceled()) continue;
                this.resultStatus = new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
                break;
            }
        }

        public void closeReader() {
            if (this.stdoutStream != null) {
                try {
                    this.stdoutStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public IStatus getResultStatus() {
            return this.resultStatus;
        }

        public String[] getColumnLabels() {
            if (this.columnLabels == null) {
                this.columnLabels = new String[0];
            }
            return this.columnLabels;
        }

        public Vector<String[]> getCommandResponse() {
            if (this.commandResponse == null) {
                this.commandResponse = new Vector();
            }
            return this.commandResponse;
        }
    }
}

