/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.validation.constraints;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.pmf.pim.DataElement;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;

public class NameConflictConstraint
extends AbstractModelConstraint {
    StringBuffer buffer = new StringBuffer();

    public IStatus validate(IValidationContext ctx) {
        ElementalDataForm dataForm;
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (eType == EMFEventType.NULL ? eObj instanceof ElementalDataForm && !this.validate_name_conflict(dataForm = (ElementalDataForm)eObj, context) : !this.validate_name_conflict(dataForm = (ElementalDataForm)eObj, context)) {
            return ctx.createFailureStatus(new Object[]{this.buffer.toString()});
        }
        return ctx.createSuccessStatus();
    }

    public boolean validate_name_conflict(ElementalDataForm dataForm, Map<Object, Object> context) {
        Boolean valid = true;
        Set<String> name_collection = new HashSet();
        if (context.get("names") == null) {
            context.put("names", name_collection);
        } else {
            name_collection = (Set)context.get("names");
        }
        StringBuffer notification = new StringBuffer();
        for (DataElement dataElement : dataForm.getChildren()) {
            if (dataElement instanceof DataItem) {
                String controlName = "";
                String labelName = "";
                String helpName = "";
                controlName = dataElement.getControl() == null ? dataElement.getName() : dataElement.getControl().getName();
                if (controlName != null && controlName != "") {
                    if (name_collection.contains(controlName)) {
                        valid = false;
                        notification.append(String.valueOf(dataElement.getName()) + "." + controlName);
                    } else {
                        name_collection.add(controlName);
                    }
                }
                if (((DataItem)dataElement).getLabel() != null) {
                    labelName = ((DataItem)dataElement).getLabel().getName() != "" ? ((DataItem)dataElement).getLabel().getName() : String.valueOf(dataElement.getName()) + "_label";
                }
                if (labelName != null && labelName != "") {
                    if (name_collection.contains(labelName)) {
                        valid = false;
                        notification.append(String.valueOf(dataElement.getName()) + "." + labelName);
                    } else {
                        name_collection.add(controlName);
                    }
                }
                if (((DataItem)dataElement).getHelp() != null) {
                    helpName = ((DataItem)dataElement).getHelp().getName() != "" ? ((DataItem)dataElement).getHelp().getName() : String.valueOf(dataElement.getName()) + "_help";
                }
                if (helpName == null || helpName == "") continue;
                if (name_collection.contains(helpName)) {
                    valid = false;
                    notification.append(String.valueOf(dataElement.getName()) + "." + helpName);
                    continue;
                }
                name_collection.add(helpName);
                continue;
            }
            if (!(dataElement instanceof DataForm)) continue;
            context.put("names", name_collection);
            this.validate_name_conflict((ElementalDataForm)dataElement, context);
        }
        if (!valid.booleanValue()) {
            this.buffer.append(System.getProperty("line.seperator"));
            this.buffer.append("Naming conflict: " + dataForm.getName() + ": " + notification.toString());
        }
        return valid;
    }
}

