/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.ArrayElement;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Dispatch;
import org.eclipse.php.core.ast.nodes.DoStatement;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.ast.nodes.ForStatement;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.IfStatement;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SwitchStatement;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.nodes.WhileStatement;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.php.internal.ui.corext.dom.fragments.AssociativeInfixExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IExpressionFragment;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.RefactoringPlugin;
import org.eclipse.php.refactoring.core.SourceModuleSourceContext;
import org.eclipse.php.refactoring.core.changes.ProgramDocumentChange;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.php.refactoring.core.visitor.ScopeSyntaxErrorsVisitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractVariableRefactoring
extends Refactoring {
    private static final String CHANGE_DESCRIPTION = PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.4");
    private ISourceModule sourceModule = null;
    private IDocument document = null;
    private IExpressionFragment fSelectedExpression;
    private int selectionStartOffset;
    private int selectionLength;
    private Program astRoot;
    private boolean fReplaceAllOccurrences;
    private String newVariableName = null;
    private String[] fGuessedTempNames;
    private ASTNode enclosingBodyNode;
    private DocumentChange textFileChange = null;
    private IASTFragment[] allMatchingFragments = null;
    private IASTFragment[] validMatchingFragments = null;
    private RefactoringStatus matchingFragmentsStatus;
    private boolean createVariableDeclaration = false;
    protected CompositeChange rootChange;
    private ASTRewrite fRewriter;
    private AST fAst;

    public ExtractVariableRefactoring(ISourceModule source, IDocument document, int offset, int length) throws CoreException {
        this.sourceModule = source;
        this.document = document;
        this.selectionStartOffset = offset;
        if (length == 0) {
            this.recalculateLength(source, offset);
        } else {
            this.selectionLength = length;
        }
        this.fReplaceAllOccurrences = true;
    }

    private void recalculateLength(ISourceModule source, int offset) throws CoreException {
        Program program = null;
        try {
            program = ASTUtils.createProgramFromSource(source);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.refactoring.core", "Unexpected Error", (Throwable)e));
        }
        ASTNode selectedNode = NodeFinder.perform((ASTNode)program, (int)offset, (int)0);
        if (selectedNode == null) {
            this.selectionLength = 0;
            return;
        }
        ASTNode parent = selectedNode.getParent();
        if (parent instanceof NamespaceName) {
            parent = parent.getParent();
        }
        this.selectionStartOffset = parent.getStart();
        this.selectionLength = parent.getLength();
    }

    public void setNewVariableName(String newVariableName) {
        this.newVariableName = newVariableName;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public boolean getReplaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 8);
            RefactoringStatus status = RefactoringUtility.validateModifiesFiles(new IResource[]{this.sourceModule.getResource()}, this.getValidationContext());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            try {
                this.astRoot = ASTUtils.createProgramFromSource(this.sourceModule);
            }
            catch (Exception e) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.0"));
                pm.done();
                return refactoringStatus;
            }
            status.merge(this.checkSelection(status, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!status.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean isLiteralNodeSelected() {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        return expression.getType() == 51;
    }

    private RefactoringStatus checkSelection(RefactoringStatus status, IProgressMonitor pm) {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.2"));
                return refactoringStatus;
            }
            pm.worked(1);
            this.enclosingBodyNode = this.getEnclosingBodyNode();
            if (this.enclosingBodyNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.3"));
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.scopeHasSyntaxErrors(this.enclosingBodyNode)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"Unable to activate refactoring. Please fix syntax errors");
                return refactoringStatus;
            }
            pm.worked(1);
            Expression expression = this.getSelectedExpression().getAssociatedExpression();
            status.merge(this.canExtract(expression));
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IASTFragment[] retainOnlyReplacableMatches(boolean recalculate) {
        this.matchingFragmentsStatus = new RefactoringStatus();
        IASTFragment[] allMatches = this.getMatchingFragments(recalculate);
        this.matchingFragmentsStatus.merge(this.checkSemanticProblems(allMatches));
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            Expression associatedExpression = this.getExpressionFromFragment(allMatches[i]).getAssociatedExpression();
            RefactoringStatus status = this.canExtract(associatedExpression);
            if (!status.hasFatalError()) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        this.validMatchingFragments = result.toArray(new IASTFragment[result.size()]);
        this.matchingFragmentsStatus.merge(this.checkMatchingExpressions(this.validMatchingFragments));
        return this.validMatchingFragments;
    }

    private RefactoringStatus checkSemanticProblems(IASTFragment[] allMatches) {
        boolean firstRighHandSideFlag = false;
        boolean firstLeftHandSideFlag = false;
        boolean hasSemanticProblem = false;
        RefactoringStatus status = new RefactoringStatus();
        SourceRange region = null;
        int i = 0;
        while (i < allMatches.length) {
            Expression associatedExpression = this.getExpressionFromFragment(allMatches[i]).getAssociatedExpression();
            if (this.isExpressionRightHandSide(associatedExpression)) {
                if (!firstRighHandSideFlag) {
                    firstRighHandSideFlag = true;
                } else if (firstLeftHandSideFlag) {
                    hasSemanticProblem = true;
                    break;
                }
            } else if (this.isExpressionLeftHandSide(associatedExpression) && !firstLeftHandSideFlag && firstRighHandSideFlag) {
                firstLeftHandSideFlag = true;
                region = new SourceRange(associatedExpression.getStart(), associatedExpression.getLength());
            }
            ++i;
        }
        if (hasSemanticProblem) {
            status.merge(RefactoringStatus.createWarningStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.7"), (RefactoringStatusContext)new SourceModuleSourceContext(this.sourceModule, (ISourceRange)region)));
        }
        return status;
    }

    private RefactoringStatus checkMatchingExpressions(IASTFragment[] allMatches) {
        RefactoringStatus status = new RefactoringStatus();
        IExpressionFragment selectedExpression = this.getSelectedExpression();
        int i = 0;
        while (i < allMatches.length) {
            boolean matchAppearsBeforeVariableDeclaration;
            Expression associatedExpression = this.getExpressionFromFragment(allMatches[i]).getAssociatedExpression();
            boolean bl = matchAppearsBeforeVariableDeclaration = this.createVariableDeclaration && associatedExpression.getStart() < selectedExpression.getStartPosition();
            if (matchAppearsBeforeVariableDeclaration) {
                status.merge(RefactoringStatus.createErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.8")));
            }
            ++i;
        }
        return status;
    }

    private RefactoringStatus canExtract(Expression expression) {
        Scalar scalar;
        if (expression.getType() == 51 && (scalar = (Scalar)expression).getScalarType() == 2 && scalar.getStringValue().equalsIgnoreCase("null")) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.5"));
        }
        if (this.isDispatch(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.9"));
        }
        if (this.isFunctionName(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.9"));
        }
        if (this.isClassName(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.9"));
        }
        if (this.isExpressionLeftHandSide(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.10"));
        }
        if (this.isUsedInForInitializerOrUpdaterOrIncrementor(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.11"));
        }
        if (this.assignmentInStaticStatement(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.12"));
        }
        if (this.expressionOfCatchVariable(expression)) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.13"));
        }
        if (expression.isStaticScalar()) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.14"));
        }
        if (expression.getType() == 27 || expression.getParent() != null && expression.getParent().getType() == 27) {
            return RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.15"));
        }
        return new RefactoringStatus();
    }

    private boolean isClassName(Expression selectedExpression) {
        ASTNode parent = selectedExpression.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof TypeDeclaration;
    }

    private boolean isFunctionName(Expression selectedExpression) {
        ASTNode parent = selectedExpression.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof FunctionDeclaration;
    }

    private boolean expressionOfCatchVariable(Expression expression) {
        CatchClause claue;
        ASTNode parent = expression.getParent();
        return parent.getType() == 9 && (claue = (CatchClause)parent).getVariable() == expression;
    }

    private boolean scopeHasSyntaxErrors(ASTNode enclosingBodyNode) {
        ScopeSyntaxErrorsVisitor visitor = new ScopeSyntaxErrorsVisitor();
        switch (enclosingBodyNode.getType()) {
            case 29: {
                ((FunctionDeclaration)enclosingBodyNode).getBody().accept((Visitor)visitor);
                break;
            }
            case 46: {
                enclosingBodyNode.accept((Visitor)visitor);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return visitor.hasSyntaxError;
    }

    private boolean isUsedInForInitializerOrUpdaterOrIncrementor(Expression expression) {
        boolean isInForStatement = false;
        boolean isInBlock = false;
        ASTNode parent = expression.getParent();
        while (parent != null) {
            if (parent instanceof ForStatement) {
                isInForStatement = true;
                if (isInBlock) {
                    return false;
                }
                Statement action = ((ForStatement)parent).getBody();
                return !this.selectionIsInForAction(expression, action);
            }
            if (parent instanceof Block) {
                isInBlock = true;
            }
            parent = parent.getParent();
        }
        return isInForStatement;
    }

    private boolean selectionIsInForAction(Expression expression, Statement action) {
        ASTNode parent = expression.getParent();
        while (parent != null && !(parent instanceof ForStatement)) {
            if (parent == action) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean assignmentInStaticStatement(Expression expression) {
        ASTNode parent;
        return expression.getType() == 3 && (parent = expression.getParent()).getType() == 54;
    }

    private boolean isExpressionLeftHandSide(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent != null && parent.getType() == 3) {
            Assignment assignment = (Assignment)parent;
            return assignment.getLeftHandSide() == expression;
        }
        return false;
    }

    private boolean isExpressionRightHandSide(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent != null && parent.getType() == 3) {
            Assignment assignment = (Assignment)parent;
            return assignment.getRightHandSide() == expression;
        }
        return false;
    }

    private boolean isDispatch(Expression selectedExpression) {
        ASTNode parent = selectedExpression.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof Dispatch) {
            Dispatch dispatch = (Dispatch)parent;
            return selectedExpression == dispatch.getMember();
        }
        if (parent instanceof StaticDispatch) {
            StaticDispatch dispatch = (StaticDispatch)parent;
            return selectedExpression == dispatch.getMember();
        }
        return false;
    }

    private ASTNode getEnclosingBodyNode() {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        return node.getEnclosingBodyNode();
    }

    private IExpressionFragment getSelectedExpression() {
        IASTFragment selectedFragment;
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        try {
            selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((org.eclipse.dltk.core.SourceRange)new org.eclipse.dltk.core.SourceRange(this.selectionStartOffset, this.selectionLength), (ASTNode)this.astRoot, (IDocument)this.document);
        }
        catch (Exception e) {
            return null;
        }
        this.fSelectedExpression = this.getExpressionFromFragment(selectedFragment);
        return this.fSelectedExpression;
    }

    private IExpressionFragment getExpressionFromFragment(IASTFragment selectedFragment) {
        IExpressionFragment fragment = null;
        if (selectedFragment instanceof IExpressionFragment) {
            fragment = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            ArrayElement arrayElement;
            ASTNode associatedNode = selectedFragment.getAssociatedNode();
            if (associatedNode instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)associatedNode;
                Expression expression = exprStatement.getExpression();
                fragment = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (associatedNode instanceof Assignment) {
                Assignment assignment = (Assignment)associatedNode;
                fragment = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            } else if (associatedNode instanceof ArrayElement && (arrayElement = (ArrayElement)associatedNode).getKey() == null) {
                fragment = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)arrayElement.getValue());
            }
        }
        return fragment;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String[] guessTempNames = this.guessTempNames();
        if (this.newVariableName.trim().length() == 0) {
            this.newVariableName = guessTempNames[0];
        }
        RefactoringStatus status = new RefactoringStatus();
        this.createChange(pm);
        status.merge(this.matchingFragmentsStatus);
        status.merge(this.doesNameAlreadyExist(this.newVariableName));
        return status;
    }

    private void replaceOccurances() throws CoreException {
        IASTFragment[] fragmentsToReplace;
        IASTFragment[] iASTFragmentArray = fragmentsToReplace = this.retainOnlyReplacableMatches(false);
        int n = fragmentsToReplace.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFragment fragment = iASTFragmentArray[n2];
            if (fragment.getAssociatedNode() != this.getSelectedExpression().getAssociatedNode()) {
                ISourceRange range = this.getReplaceOffsets(fragment);
                this.replaceSelectedExpressionWithVariableDeclaration(this.getFullVariableName(), range.getOffset(), range.getLength(), fragment.getAssociatedNode());
            }
            ++n2;
        }
    }

    private ISourceRange getReplaceOffsets(IASTFragment fragment) {
        ASTNode associatedNode = fragment.getAssociatedNode();
        int start = associatedNode.getStart();
        int length = associatedNode.getLength();
        if (fragment instanceof AssociativeInfixExpressionFragment) {
            AssociativeInfixExpressionFragment infixExpressionFragment = (AssociativeInfixExpressionFragment)fragment;
            List operands = infixExpressionFragment.getOperands();
            start = ((Expression)operands.get(0)).getStart();
            length = ((Expression)operands.get(operands.size() - 1)).getEnd() - start;
        }
        return new org.eclipse.dltk.core.SourceRange(start, length);
    }

    private void extractVariable() throws CoreException, BadLocationException {
        IExpressionFragment selectedExpressionFragment = this.getSelectedExpression();
        Expression selectedExpression = selectedExpressionFragment.getAssociatedExpression();
        if (this.shouldReplaceSelectedExpressionWithVariableDeclaration()) {
            this.createVariableDeclaration = true;
            String replacement = String.valueOf(this.getFullVariableName()) + " = " + this.getASTNodeValue(this.getSelectedExpression().getAssociatedNode()) + ";";
            this.replaceSelectedExpressionWithTempDeclaration(replacement);
        } else {
            ISourceRange range = this.getReplaceOffsets((IASTFragment)selectedExpressionFragment);
            this.createAndInsertVariableDeclaration(selectedExpression, range);
            this.addReplaceExpressionWithTemp();
        }
    }

    private void addReplaceExpressionWithTemp() {
        IASTFragment[] fragmentsToReplace = this.retainOnlyReplacableMatches(true);
        ASTRewrite rewrite = this.fRewriter;
        HashSet<IASTFragment> seen = new HashSet<IASTFragment>();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (seen.add(fragment)) {
                Identifier tempName = this.fRewriter.getAST().newIdentifier(this.getFullVariableName());
                TextEditGroup description = new TextEditGroup("replace ");
                fragment.replace(rewrite, (ASTNode)tempName, description);
            }
            ++i;
        }
    }

    private void createAndInsertVariableDeclaration(Expression selectedExpression, ISourceRange range) throws CoreException, BadLocationException {
        if (!this.fReplaceAllOccurrences || this.retainOnlyReplacableMatches(true).length <= 1) {
            this.insertAt((ASTNode)selectedExpression);
            return;
        }
        ASTNode[] firstReplaceNodeParents = ExtractVariableRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue((commonPath.length <= firstReplaceNodeParents.length ? 1 : 0) != 0);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof Block || deepestCommonParent instanceof Program) {
            this.insertAt(firstReplaceNodeParents[commonPath.length]);
        } else {
            this.insertAt(deepestCommonParent);
        }
    }

    private void insertAt(ASTNode target) throws BadLocationException {
        ASTRewrite rewrite = this.fRewriter;
        TextEditGroup groupDescription = new TextEditGroup("dec Variable");
        ASTNode parent = target.getParent();
        StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
        String insertionString = String.valueOf(this.getFullVariableName()) + " = " + this.getASTNodeValue(this.getSelectedExpression().getAssociatedNode()) + ";";
        ASTNode declaration = this.fRewriter.createStringPlaceholder(insertionString, 23);
        while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.BODY_PROPERTY) {
            if (locationInParent == IfStatement.TRUE_STATEMENT_PROPERTY || locationInParent == IfStatement.FALSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst(declaration, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            if (parent instanceof Program) break;
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
        }
        ListRewrite listRewrite = rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)locationInParent);
        listRewrite.insertBefore(declaration, target, groupDescription);
    }

    private void insertVariableDeclaration(ASTNode target, ASTNode expr, boolean shouldWrapStatement, org.eclipse.dltk.core.SourceRange range) throws CoreException, BadLocationException {
        Block block = this.fAst.newBlock();
        block.setIsCurly(true);
        ListRewrite replacementRewrite = this.fRewriter.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
        ASTNode move = this.fRewriter.createMoveTarget(target.getParent());
        String expressionBuffer = this.getASTNodeValue(range.getOffset(), range.getLength());
        String insertionString = String.valueOf(this.getFullVariableName()) + " = " + expressionBuffer + ";";
        ASTNode declaration = this.fRewriter.createStringPlaceholder(insertionString, 23);
        replacementRewrite.insertFirst(declaration, null);
        replacementRewrite.insertLast(move, null);
        TextEditGroup insertDesc = new TextEditGroup(PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.4"));
        this.textFileChange.addTextEditGroup(insertDesc);
        this.fRewriter.replace(target.getParent(), (ASTNode)block, insertDesc);
    }

    private String getLineIndentation(int offset) throws BadLocationException {
        IRegion region = this.document.getLineInformationOfOffset(offset);
        String lineContent = this.document.get(region.getOffset(), region.getLength());
        StringBuilder buff = new StringBuilder();
        int index = 0;
        while (index < lineContent.length()) {
            if (!Character.isWhitespace(lineContent.charAt(index))) break;
            buff.append(lineContent.charAt(index));
            ++index;
        }
        return buff.toString();
    }

    private IExpressionFragment getFirstReplacedExpression() {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = this.retainOnlyReplacableMatches(false);
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        return (IExpressionFragment)nodesToReplace[0];
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        int i = 0;
        while (i < matchNodes.length) {
            matchingNodesParents[i] = ExtractVariableRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<Object> l = Arrays.asList(ExtractVariableRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private ASTNode[] getMatchNodes() {
        IASTFragment[] matches = this.retainOnlyReplacableMatches(false);
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractVariableRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractVariableRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        int i = 0;
        while (i < arrays.length) {
            Object[] array = arrays[i];
            if (!element.equals(array[position])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue((prefixLength <= array.length ? 1 : 0) != 0);
        Assert.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        Object[] prefix = new Object[prefixLength];
        int i = 0;
        while (i < prefix.length) {
            prefix[i] = array[i];
            ++i;
        }
        return prefix;
    }

    private boolean shouldReplaceSelectedExpressionWithVariableDeclaration() {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent().getType() == 23 && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)selectedFragment.getAssociatedNode()));
    }

    private void replaceSelectedExpressionWithTempDeclaration(String str) throws CoreException {
        ASTRewrite rewrite = this.fRewriter;
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        ASTNode declaration = this.fRewriter.createStringPlaceholder(str, 3);
        ExpressionStatement parent = (ExpressionStatement)selectedExpression.getParent();
        TextEditGroup textEditGroup = new TextEditGroup(CHANGE_DESCRIPTION);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)this.textFileChange, textEditGroup);
        this.textFileChange.addTextEditChangeGroup(textEditChangeGroup);
        rewrite.replace((ASTNode)parent, declaration, textEditGroup);
    }

    private void replaceSelectedExpressionWithVariableDeclaration(String replacement, int start, int length, ASTNode astNode) throws CoreException {
        ASTNode node = this.fRewriter.createStringPlaceholder(replacement, 3);
        TextEditGroup textEditGroup = new TextEditGroup(CHANGE_DESCRIPTION);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)this.textFileChange, textEditGroup);
        this.textFileChange.addTextEditChangeGroup(textEditChangeGroup);
        this.fRewriter.replace(astNode, node, textEditGroup);
    }

    private boolean shouldWrapWithBlock(ASTNode node) {
        if (node.getParent() == null || !(node.getParent() instanceof Statement)) {
            return false;
        }
        return ASTNodes.isControlStatement((ASTNode)node.getParent());
    }

    private Statement getParentStatement(ASTNode node) {
        if (node instanceof Statement) {
            return (Statement)node;
        }
        ASTNode parent = node.getParent();
        while (!(parent instanceof Statement)) {
            parent = parent.getParent();
        }
        return (Statement)parent;
    }

    private String getASTNodeValue(ASTNode node) throws BadLocationException {
        return this.getASTNodeValue(node.getStart(), node.getLength());
    }

    private String getASTNodeValue(int start, int length) throws BadLocationException {
        return this.document.get(start, length);
    }

    private void addTextEditChange(TextEdit textEdit) {
        TextEditGroup textEditGroup = new TextEditGroup(CHANGE_DESCRIPTION);
        textEditGroup.addTextEdit(textEdit);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)this.textFileChange, textEditGroup);
        this.textFileChange.addTextEditChangeGroup(textEditChangeGroup);
        this.textFileChange.addEdit(textEdit);
    }

    private String getFullVariableName() {
        assert (this.newVariableName != null);
        return "$" + this.newVariableName;
    }

    private IASTFragment[] getMatchingFragments(boolean clean) {
        if (this.fReplaceAllOccurrences) {
            if (clean || this.allMatchingFragments == null) {
                this.allMatchingFragments = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching((IASTFragment)this.getSelectedExpression());
                Comparator<IASTFragment> comparator = new Comparator<IASTFragment>(){

                    @Override
                    public int compare(IASTFragment o1, IASTFragment o2) {
                        return o1.getStartPosition() - o2.getStartPosition();
                    }
                };
                Arrays.sort(this.allMatchingFragments, comparator);
            }
            return this.allMatchingFragments;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private RefactoringStatus doesNameAlreadyExist(String name) {
        RefactoringStatus status = new RefactoringStatus();
        if (this.enclosingBodyNode.getType() == 29) {
            if (PHPElementConciliator.localVariableAlreadyExists((FunctionDeclaration)((FunctionDeclaration)this.enclosingBodyNode), (String)name)) {
                status.addWarning(NLS.bind((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.26"), (Object)name));
            }
        } else if (PHPElementConciliator.globalVariableAlreadyExists((Program)this.astRoot, (String)name)) {
            status.addWarning(NLS.bind((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.27"), (Object)name));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.28"), 1);
            MultiTextEdit root = new MultiTextEdit();
            this.rootChange = new CompositeChange(CHANGE_DESCRIPTION);
            this.rootChange.markAsSynthetic();
            this.textFileChange = new ProgramDocumentChange(CHANGE_DESCRIPTION, this.document, this.astRoot);
            this.textFileChange.setEdit((TextEdit)root);
            this.textFileChange.setTextType("php");
            this.rootChange.add((Change)this.textFileChange);
            this.fAst = this.getSelectedExpression().getAssociatedNode().getAST();
            this.fRewriter = ASTRewrite.create((AST)this.fAst);
            try {
                this.extractVariable();
            }
            catch (CoreException exception) {
                RefactoringPlugin.logException(PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.29"), (Exception)((Object)exception));
            }
            catch (BadLocationException e) {
                RefactoringPlugin.logException(PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.30"), (Exception)((Object)e));
            }
            if (this.fReplaceAllOccurrences) {
                this.replaceOccurances();
            }
            TextEdit edit = this.fRewriter.rewriteAST(this.document, null);
            root.addChild(edit);
        }
        finally {
            pm.done();
        }
        return this.rootChange;
    }

    public String getName() {
        return PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.6");
    }

    public Change getChange() {
        return this.rootChange;
    }

    public TextChange getTextChange() {
        return this.textFileChange;
    }

    public String[] guessTempNames() {
        if (this.fGuessedTempNames == null) {
            Expression expression = this.getSelectedExpression().getAssociatedExpression();
            if (expression != null) {
                this.fGuessedTempNames = RefactoringUtility.getVariableNameSuggestions(expression);
            }
            if (this.fGuessedTempNames == null || this.fGuessedTempNames.length == 0) {
                this.fGuessedTempNames = new String[0];
            } else {
                this.adjustGuessList(this.fGuessedTempNames);
            }
        }
        return this.fGuessedTempNames;
    }

    private void adjustGuessList(String[] guessedTempNames) {
        int i = 0;
        while (i < guessedTempNames.length) {
            int idx = 2;
            String suggestionStr = guessedTempNames[i];
            while (this.doesNameAlreadyExist(guessedTempNames[i]).getSeverity() != 0) {
                guessedTempNames[i] = String.valueOf(suggestionStr) + idx;
                ++idx;
            }
            ++i;
        }
    }

    public RefactoringStatus checkNewVariableName(String text) {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(RefactoringUtility.checkNewElementName(text));
        status.merge(this.doesNameAlreadyExist(text));
        return status;
    }
}

