/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.connection.PHPUnitConnection;
import org.eclipse.php.phpunit.ui.launch.PHPUnitBasicLauncher;
import org.eclipse.php.phpunit.ui.launch.PHPUnitLaunchUtils;
import org.eclipse.php.phpunit.ui.launch.PHPUnitOption;
import org.eclipse.php.phpunit.ui.launch.PHPUnitOptionsList;
import org.eclipse.php.phpunit.ui.launch.PHPUnitXDLauncher;
import org.eclipse.php.phpunit.ui.launch.PHPUnitZDLauncher;
import org.eclipse.php.phpunit.ui.preference.PHPUnitPreferenceKeys;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPUnitLaunchConfigurationDelegate
extends PHPExecutableLaunchDelegate {
    public static final String PRINTER_NAME = "PHPUnitLogger";
    private static final String PRINTER_DIRECTORY = "printer";
    private static final String TMP_PRINTER_DIRECTORY = "phpunit_printer";
    private static final String ENV_PORT = "PHPUNIT_PORT";
    private static final String TIMESTAMP_DATA_FORMAT = "yyyyMMdd-HHmm";
    private static final String XML_FILE_FORMAT = "%s-%s.xml";
    private static final String NAMESPACE_SEPARATOR = "\\";
    private static final String NAMESPACE_SEPARATOR_ESCAPED = "\\\\";

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        PHPUnitBasicLauncher launcher;
        File workingDirectory;
        IPath elementToTest;
        if (!PHPUnitLaunchUtils.launchIsPHPUnit(launch)) {
            this.displayErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationDelegate_Bad_Config);
        }
        if (config.getAttribute("org.eclipse.php.phpunit.code_coverage", false)) {
            launch.setAttribute("collectCodeCoverage", "1");
        }
        if ((elementToTest = this.findElementToTest((ILaunchConfiguration)config)) == null || elementToTest.isEmpty()) {
            this.displayErrorMessage(PHPUnitMessages.PHPUnitLaunchShortcut_Unable_To_Generate);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember(elementToTest);
        if (resource == null) {
            this.displayErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationTab_No_Container);
            return;
        }
        IProject project = resource.getProject();
        String fileToExecute = this.findFileToExecute((ILaunchConfiguration)config, project);
        if (fileToExecute == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy wconfig = config.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)config : config.getWorkingCopy();
        this.setAdditionalAttributes(wconfig, fileToExecute, project);
        this.setEnvironmentVariables(wconfig, project);
        PHPUnitOptionsList phpUnitOptionsList = this.createPHPUnitOptionsList(wconfig, project);
        config = !wconfig.hasAttribute("org.eclipse.php.phpunit.rerun") ? wconfig.doSave() : wconfig;
        if (!(resource instanceof IProject)) {
            phpUnitOptionsList.setElementToTest(resource.getLocation().toOSString());
        }
        if ((workingDirectory = resource.getLocation().toFile()).isFile()) {
            workingDirectory = workingDirectory.getParentFile();
        }
        if (PHPUnitLaunchUtils.isPHPUnitRunning()) {
            Display.getDefault().syncExec(() -> {
                int n = ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)PHPUnitMessages.PHPUnitConnection_Launching, (String)PHPUnitMessages.PHPUnitConnection_Unable_to_run, (IStatus)new Status(4, "org.eclipse.php.phpunit", 0, PHPUnitMessages.PHPUnitConnection_Previous_session_exists, null));
            });
            return;
        }
        int port = Integer.parseInt((String)this.envVariables.get(ENV_PORT));
        if (!PHPUnitConnection.getInstance().listen(port, launch)) {
            return;
        }
        PHPexeItem execItem = PHPLaunchUtilities.getPHPExe((ILaunchConfiguration)config);
        if (execItem != null) {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("ATTR_LOCATION", execItem.getExecutable().toString());
            wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, execItem.getDebuggerID());
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)execItem.getDebuggerID());
            wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
            if ((mode.equals("debug") || mode.equals("profile")) && debuggerConfiguration.getDebuggerId().equals("org.eclipse.php.debug.core.noneDebugger")) {
                wc.setAttribute("org.eclipse.debug.ui.private", true);
            }
            if (execItem.getINILocation() != null) {
                wc.setAttribute("ATTR_INI_LOCATION", execItem.getINILocation().toString());
            } else {
                wc.setAttribute("ATTR_INI_LOCATION", null);
            }
            if (!wc.hasAttribute("org.eclipse.php.phpunit.rerun")) {
                wc.doSave();
            }
        }
        if (execItem != null) {
            launcher = new PHPUnitBasicLauncher((ILaunchConfiguration)config, launch, phpUnitOptionsList);
            if ("org.eclipse.php.debug.core.xdebugDebugger".equals(execItem.getDebuggerID())) {
                launcher = new PHPUnitXDLauncher((ILaunchConfiguration)config, launch, phpUnitOptionsList);
            } else if ("org.eclipse.php.debug.core.zendDebugger".equals(execItem.getDebuggerID())) {
                launcher = new PHPUnitZDLauncher((ILaunchConfiguration)config, launch, phpUnitOptionsList);
            }
        } else {
            this.displayErrorMessage(PHPDebugCoreMessages.PHPExecutableLaunchDelegate_4);
            return;
        }
        launch.setAttribute("org.eclipse.php.phpunit.phpUnitLaunch", Boolean.TRUE.toString());
        launcher.launch(mode, project, workingDirectory, this.envVariables, monitor);
    }

    private IPath findElementToTest(ILaunchConfiguration config) throws CoreException {
        String containerType = config.getAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", "");
        String container = config.getAttribute("org.eclipse.php.phpunit.container", "");
        String file = config.getAttribute("org.eclipse.php.phpunit.file", "");
        String projectName = config.getAttribute("org.eclipse.php.phpunit.project", "");
        boolean runContainer = config.getAttribute("org.eclipse.php.phpunit.is_suite", true);
        Object resourcePath = null;
        if (containerType.equals("SCRIPT_PROJECT")) {
            resourcePath = runContainer ? new Path(projectName) : new Path(projectName).append(file);
        } else if (containerType.equals("SCRIPT_FOLDER")) {
            if (runContainer) {
                resourcePath = new Path(projectName).append(container);
            }
        } else if (containerType.equals("SCRIPT_SOURCE")) {
            resourcePath = runContainer ? new Path(projectName).append(container) : new Path(projectName).append(file);
        }
        return resourcePath;
    }

    private String findFileToExecute(ILaunchConfiguration config, IProject project) throws CoreException {
        String runType = config.getAttribute("org.eclipse.php.phpunit.runType", "PHAR_EXECUTION_TYPE");
        String result = null;
        if ("COMPOSER_EXECUTION_TYPE".equals(runType)) {
            result = PHPUnitLaunchUtils.findComposerExecutionFile(project);
            if (result == null) {
                this.displayErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationDelegate_no_composer_dependency);
            }
        } else if ("PHAR_EXECUTION_TYPE".equals(runType) && ((result = PHPUnitPreferenceKeys.getPHPUnitPharPath()) == null || !new File(result).exists())) {
            result = null;
            this.displayErrorMessage(PHPUnitMessages.PHPUnitLaunchConfigurationDelegate_no_phar);
        }
        return result;
    }

    private PHPUnitOptionsList createPHPUnitOptionsList(ILaunchConfigurationWorkingCopy config, IProject project) throws CoreException {
        StringBuilder sb;
        List filters;
        IResource configurationXmlResource;
        String configurationXml;
        String xmlLocation;
        PHPUnitOptionsList optionsList = new PHPUnitOptionsList();
        optionsList.add(PHPUnitOption.INCLUDE_PATH, this.getPrinterDirectory());
        optionsList.add(PHPUnitOption.PRINTER, PRINTER_NAME);
        boolean logXml = config.getAttribute("org.eclipse.php.phpunit.logXml", false);
        if (logXml && (xmlLocation = PHPUnitPreferenceKeys.getReportPath()) != null) {
            String timestamp = new SimpleDateFormat(TIMESTAMP_DATA_FORMAT).format(new Date());
            String fileName = String.format(XML_FILE_FORMAT, config.getName(), timestamp);
            optionsList.add(PHPUnitOption.LOG_JUNIT, new Path(xmlLocation).append(fileName).toOSString());
            config.setAttribute("org.eclipse.php.phpunit.logXmlLocation", new Path(xmlLocation).append(fileName).toOSString());
        }
        if ((configurationXml = config.getAttribute("org.eclipse.php.phpunit.phpunitPath", null)) != null && !configurationXml.isEmpty() && (configurationXmlResource = project.findMember(configurationXml)) != null && configurationXmlResource.exists()) {
            optionsList.add(PHPUnitOption.CONFIGURATION, configurationXmlResource.getLocation().toOSString());
        }
        if (config.hasAttribute("org.eclipse.php.phpunit.filter") && (filters = config.getAttribute("org.eclipse.php.phpunit.filter", Collections.emptyList())).size() > 0) {
            int pos = 0;
            sb = new StringBuilder();
            for (String filter : filters) {
                if (pos++ > 0) {
                    sb.append('|');
                }
                sb.append('(');
                sb.append(filter);
                sb.append(')');
            }
            sb.insert(0, "/^");
            sb.append("$/");
            optionsList.add(PHPUnitOption.FILTER, sb.toString().replace(NAMESPACE_SEPARATOR, NAMESPACE_SEPARATOR_ESCAPED));
        }
        if (config.hasAttribute("org.eclipse.php.phpunit.suite") && (filters = config.getAttribute("org.eclipse.php.phpunit.suite", Collections.emptyList())).size() > 0) {
            int pos = 0;
            sb = new StringBuilder();
            for (String filter : filters) {
                if (pos++ > 0) {
                    sb.append(',');
                }
                sb.append(filter);
            }
            optionsList.add(PHPUnitOption.TEST_SUITE, sb.toString().replace(NAMESPACE_SEPARATOR, NAMESPACE_SEPARATOR_ESCAPED));
        }
        return optionsList;
    }

    private String getPrinterDirectory() {
        IPath resourcePath = PHPUnitLaunchUtils.getResourcesPath().append(PRINTER_DIRECTORY);
        File printerFile = resourcePath.append("PHPUnitLogger.php").toFile();
        String tmpDirectoryPath = System.getProperty("java.io.tmpdir");
        File tmpDirectory = new File(tmpDirectoryPath);
        if (tmpDirectory.exists()) {
            File tmpPrinterFile;
            File printerDirectory = new File(tmpDirectory, TMP_PRINTER_DIRECTORY);
            if (!printerDirectory.exists()) {
                printerDirectory.mkdirs();
            }
            if ((tmpPrinterFile = new File(printerDirectory, "PHPUnitLogger.php")).exists() && tmpPrinterFile.lastModified() >= printerFile.lastModified()) {
                return tmpPrinterFile.getParentFile().getAbsolutePath();
            }
            try {
                FileUtils.copyFile((File)printerFile, (File)tmpPrinterFile);
                return tmpPrinterFile.getParentFile().getAbsolutePath();
            }
            catch (IOException e) {
                PHPUnitPlugin.log(e);
                return resourcePath.toOSString();
            }
        }
        return resourcePath.toOSString();
    }

    private void setAdditionalAttributes(ILaunchConfigurationWorkingCopy wconfig, String fileToRun, IProject project) throws CoreException {
        wconfig.setAttribute("firstLineBreakpoint", false);
        wconfig.setAttribute("ATTR_FILE", fileToRun);
        wconfig.setAttribute("ATTR_FILE_FULL_PATH", fileToRun);
        wconfig.setAttribute("org.eclipse.php.debug.core.PHP_Project", project.getName());
    }

    private void setEnvironmentVariables(ILaunchConfigurationWorkingCopy wconfig, IProject project) throws CoreException {
        this.envVariables = wconfig.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
        if (this.envVariables == null) {
            this.envVariables = new HashMap();
        }
        if (this.envVariables.get(ENV_PORT) == null) {
            int port = PHPUnitPreferenceKeys.getPort();
            this.envVariables.put(ENV_PORT, String.valueOf(port));
        }
        wconfig.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.envVariables);
    }

    private void displayErrorMessage(String message) {
        Display display = Display.getDefault();
        display.asyncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPUnitMessages.PHPUnitLaunchConfigurationDelegate_Launching, (String)message));
    }
}

