/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.core.IUniqueIdentityElement;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsProviderRegistry;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.preferences.IPHPexeItemListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItemEvent;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.wizards.DebuggerSettingsSectionBuildersRegistry;
import org.eclipse.php.internal.debug.ui.wizards.DebuggerUnsupportedSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSectionBuilder;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DebuggerCompositeFragment
extends CompositeFragment {
    public static final String ID = "org.eclipse.php.debug.ui.fragments.debuggerCompositeFragment";
    private List<String> debuggersIds;
    private Combo debuggerCombo;
    private Button debuggerTest;
    private Link debuggerGlobalSettings;
    private PHPExeListener phpExeListener;
    private PHPServerListener phpServerListener;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;
    private IDebuggerSettingsSection debuggerSettingsSection;
    private IDebuggerSettingsWorkingCopy debuggerSettingsWC;
    private Map<String, IDebuggerSettingsWorkingCopy> settingsWCBuffer = new HashMap<String, IDebuggerSettingsWorkingCopy>();
    private String detectedDebuggerId = null;
    private boolean detectDebugger;
    private Composite debuggerSettingsComposite;
    private Composite mainComposite;
    private boolean updatingDebuggerId = false;

    public DebuggerCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.detectDebugger = handler.getKind() == IControlHandler.Kind.WIZARD;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DebuggerCompositeFragment.this.unregisterListeners();
                DebuggerCompositeFragment.this.removeDisposeListener(this);
            }
        });
    }

    public String getId() {
        return ID;
    }

    public boolean performOk() {
        boolean isOK;
        if (this.detectDebugger) {
            this.detectDebugger();
            this.detectDebugger = false;
        }
        if (this.debuggerSettingsSection != null && !(isOK = this.debuggerSettingsSection.performOK())) {
            return isOK;
        }
        if (this.debuggerSettingsWC != null) {
            if (this.debuggerSettingsWC.isDirty()) {
                DebuggerSettingsManager.INSTANCE.save(this.debuggerSettingsWC);
            }
            DebuggerSettingsManager.INSTANCE.dropWorkingCopy(this.debuggerSettingsWC);
        }
        return true;
    }

    public boolean performCancel() {
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsSection.performCancel();
        }
        if (this.debuggerSettingsWC != null) {
            DebuggerSettingsManager.INSTANCE.dropWorkingCopy(this.debuggerSettingsWC);
        }
        return super.performCancel();
    }

    public void validate() {
        this.setComplete(true);
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsSection.validate();
        }
    }

    public void setData(Object debuggerOwner) throws IllegalArgumentException {
        if (debuggerOwner != null && !(debuggerOwner instanceof IUniqueIdentityElement)) {
            throw new IllegalArgumentException("The given object is not a PHP Server or Executable");
        }
        this.unregisterListeners();
        super.setData(debuggerOwner);
        this.registerListeners();
        this.createDescription(debuggerOwner);
        this.init();
        this.validate();
    }

    public IUniqueIdentityElement getDebuggerOwner() {
        return (IUniqueIdentityElement)this.getData();
    }

    void createSettings(String debuggerId) {
        boolean repaint;
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner == null || debuggerId == null) {
            return;
        }
        IDebuggerSettings settings = DebuggerSettingsManager.INSTANCE.findSettings(debuggerOwner.getUniqueId(), debuggerId);
        boolean bl = repaint = this.controlHandler.getKind() == IControlHandler.Kind.WIZARD && !"org.eclipse.php.debug.core.noneDebugger".equals(debuggerId);
        if (this.debuggerSettingsSection != null) {
            this.debuggerSettingsComposite.dispose();
            repaint = true;
        }
        this.debuggerSettingsComposite = new Composite(this.mainComposite, 0);
        this.debuggerSettingsComposite.setLayout((Layout)new GridLayout());
        GridData dscData = new GridData(4, 4, true, true);
        this.debuggerSettingsComposite.setLayoutData((Object)dscData);
        if ("org.eclipse.php.debug.core.noneDebugger".equals(debuggerId)) {
            this.debuggerSettingsSection = new EmptySettingsSection(this.debuggerSettingsComposite);
            this.debuggerGlobalSettings.setVisible(false);
        } else if (settings == null) {
            this.debuggerSettingsSection = new DebuggerUnsupportedSettingsSection(this, this.debuggerSettingsComposite);
        } else {
            this.debuggerGlobalSettings.setVisible(PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerId) != null);
            this.debuggerSettingsWC = this.getSettingsWC(debuggerId, settings);
            IDebuggerSettingsProvider provider = DebuggerSettingsProviderRegistry.getProvider((String)debuggerId);
            IDebuggerSettingsSectionBuilder sectionBuilder = DebuggerSettingsSectionBuildersRegistry.getBuilder(provider.getId());
            this.debuggerSettingsSection = sectionBuilder.build(this, this.debuggerSettingsComposite, this.debuggerSettingsWC);
        }
        if (!this.debuggerSettingsSection.canTest()) {
            this.debuggerTest.setVisible(false);
        } else {
            this.debuggerTest.setVisible(true);
        }
        this.getParent().layout(true, true);
        if (repaint) {
            this.repaint();
        }
    }

    IDebuggerSettingsWorkingCopy getSettingsWC(String debuggerId, IDebuggerSettings settings) {
        IDebuggerSettingsWorkingCopy debuggerSettingsWC = this.settingsWCBuffer.get(debuggerId);
        if (debuggerSettingsWC == null) {
            debuggerSettingsWC = DebuggerSettingsManager.INSTANCE.fetchWorkingCopy(settings);
            this.settingsWCBuffer.put(debuggerId, debuggerSettingsWC);
        }
        return debuggerSettingsWC;
    }

    protected void createDescription(Object owner) {
        if (owner instanceof PHPexeItem) {
            this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_DEBUG_PHPEXE"));
            this.setDescription(Messages.DebuggerCompositeFragment_Configure_exe_debugger_settings);
        } else if (owner instanceof Server) {
            this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_DEBUG_SERVER"));
            this.setDescription(Messages.DebuggerCompositeFragment_Configure_server_debugger_settings);
        }
        this.setDisplayName(Messages.DebuggerCompositeFragment_Debugger);
        this.setTitle(Messages.DebuggerCompositeFragment_Debugger_settings);
        this.controlHandler.setTitle(this.getTitle());
        this.controlHandler.setImageDescriptor(this.getImageDescriptor());
        this.controlHandler.setDescription(this.getDescription());
    }

    protected void createContents(Composite parent) {
        this.debuggersIds = new LinkedList<String>(PHPDebuggersRegistry.getDebuggersIds());
        this.mainComposite = parent;
        Composite debuggerChoice = new Composite(parent, 0);
        GridLayout dcLayout = new GridLayout();
        dcLayout.numColumns = 4;
        debuggerChoice.setLayout((Layout)dcLayout);
        debuggerChoice.setLayoutData((Object)new GridData(4, 4, true, false));
        Label debuggerLabel = new Label(debuggerChoice, 0);
        debuggerLabel.setText("Debugger:");
        debuggerLabel.setLayoutData((Object)new GridData());
        this.debuggerCombo = new Combo(debuggerChoice, 12);
        GridData dcData = new GridData(16384, 4, false, false);
        this.debuggerCombo.setLayoutData((Object)dcData);
        this.debuggerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DebuggerCompositeFragment.this.getDebuggerOwner() != null) {
                    ((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId = (String)DebuggerCompositeFragment.this.debuggersIds.get(DebuggerCompositeFragment.this.debuggerCombo.getSelectionIndex());
                    DebuggerCompositeFragment.this.updateItem();
                    DebuggerCompositeFragment.this.createSettings(((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId);
                    DebuggerCompositeFragment.this.validate();
                }
            }
        });
        this.debuggerTest = SWTFactory.createPushButton((Composite)debuggerChoice, (String)Messages.DebuggerCompositeFragment_Test_button, null);
        this.debuggerTest.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DebuggerCompositeFragment.this.debuggerSettingsSection != null) {
                    DebuggerCompositeFragment.this.debuggerSettingsSection.performTest();
                }
            }
        });
        this.debuggerGlobalSettings = new Link(debuggerChoice, 0);
        GridData dgsData = new GridData(131072, 0x1000000, true, false);
        this.debuggerGlobalSettings.setLayoutData((Object)dgsData);
        this.debuggerGlobalSettings.setText(Messages.DebuggerCompositeFragment_Global_settings_link);
        this.debuggerGlobalSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String selectedDebuggerId = (String)DebuggerCompositeFragment.this.debuggersIds.get(DebuggerCompositeFragment.this.debuggerCombo.getSelectionIndex());
                AbstractDebuggerConfiguration globalConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)selectedDebuggerId);
                globalConfiguration.openConfigurationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        int i = 0;
        while (i < this.debuggersIds.size()) {
            String id = this.debuggersIds.get(i);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)id);
            this.debuggerCombo.add(debuggerName, i);
            ++i;
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
        this.debuggerCombo.forceFocus();
    }

    protected void init() {
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner == null) {
            return;
        }
        if (debuggerOwner instanceof Server) {
            this.originalValuesCache.debuggerId = ((Server)debuggerOwner).getDebuggerId();
        } else if (debuggerOwner instanceof PHPexeItem) {
            this.originalValuesCache.debuggerId = ((PHPexeItem)debuggerOwner).getDebuggerID();
        }
        if (this.modifiedValuesCache == null) {
            this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        }
        this.setDebugger();
    }

    private void setDebugger() {
        if (this.detectDebugger) {
            this.detectDebugger();
            this.detectDebugger = false;
        } else {
            this.selectDebugger(this.modifiedValuesCache.debuggerId);
        }
    }

    private void detectDebugger() {
        IUniqueIdentityElement data = (IUniqueIdentityElement)this.getData();
        if (data instanceof PHPexeItem) {
            PHPexeItem exeItem = (PHPexeItem)data;
            this.modifiedValuesCache.debuggerId = this.detectedDebuggerId = this.fetchDebugger(exeItem);
        }
        if (this.detectedDebuggerId == null && (this.modifiedValuesCache.debuggerId == null || this.modifiedValuesCache.debuggerId.equals("org.eclipse.php.debug.core.noneDebugger"))) {
            this.detectedDebuggerId = "org.eclipse.php.debug.core.noneDebugger";
        } else if (this.modifiedValuesCache.debuggerId != null) {
            this.detectedDebuggerId = this.modifiedValuesCache.debuggerId;
        }
        this.selectDebugger(this.detectedDebuggerId);
    }

    private void selectDebugger(String debuggerId) {
        String name = PHPDebuggersRegistry.getDebuggerName((String)debuggerId);
        String[] values = this.debuggerCombo.getItems();
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(name)) {
                this.debuggerCombo.select(i);
                break;
            }
            ++i;
        }
    }

    private String fetchDebugger(PHPexeItem exeItem) {
        AbstractDebuggerConfiguration[] debuggers;
        List modules = PHPExeUtil.getModules((PHPexeItem)exeItem);
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
        int n = debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
            for (PHPExeUtil.PHPModuleInfo module : modules) {
                if (!module.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                return debugger.getDebuggerId();
            }
            ++n2;
        }
        return null;
    }

    private void updateItem() {
        this.updatingDebuggerId = true;
        IUniqueIdentityElement debuggerOwner = this.getDebuggerOwner();
        if (debuggerOwner instanceof Server) {
            ((Server)debuggerOwner).setDebuggerId(this.modifiedValuesCache.debuggerId);
        } else if (debuggerOwner instanceof PHPexeItem) {
            ((PHPexeItem)debuggerOwner).setDebuggerID(this.modifiedValuesCache.debuggerId);
        }
        this.updatingDebuggerId = false;
    }

    private void repaint() {
        boolean resize;
        Shell shell = this.getShell();
        Point previousSize = new Point(shell.getSize().x, shell.getSize().y);
        Rectangle previousClientArea = shell.getClientArea();
        shell.layout(true, true);
        Point computedSize = shell.computeSize(previousClientArea.width, -1, false);
        boolean bl = resize = computedSize.y > previousSize.y;
        if (resize) {
            shell.setSize(shell.computeSize(previousClientArea.width, computedSize.y - 25, true));
        } else {
            shell.setRedraw(false);
            shell.setSize(shell.computeSize(previousClientArea.width + 1, previousClientArea.height, true));
            shell.setRedraw(true);
            shell.setSize(shell.computeSize(previousClientArea.width, previousClientArea.height, true));
        }
    }

    private void registerListeners() {
        Object data = this.getData();
        if (data instanceof PHPexeItem) {
            if (this.phpExeListener == null) {
                this.phpExeListener = new PHPExeListener();
            }
            ((PHPexeItem)data).addPHPexeListener((IPHPexeItemListener)this.phpExeListener);
        }
        if (data instanceof Server) {
            if (this.phpServerListener == null) {
                this.phpServerListener = new PHPServerListener();
            }
            ((Server)data).addPropertyChangeListener((PropertyChangeListener)this.phpServerListener);
        }
    }

    private void unregisterListeners() {
        Object data = this.getData();
        if (data == null) {
            return;
        }
        if (this.phpExeListener != null) {
            ((PHPexeItem)data).removePHPexeListener((IPHPexeItemListener)this.phpExeListener);
        }
        if (this.phpServerListener != null) {
            ((Server)data).removePropertyChangeListener((PropertyChangeListener)this.phpServerListener);
        }
    }

    private class EmptySettingsSection
    implements IDebuggerSettingsSection {
        private EmptySettingsSection(Composite settingsComposite) {
            Composite empty = new Composite(settingsComposite, 0);
            empty.setLayoutData((Object)new GridData(4, 4, true, true));
        }

        @Override
        public boolean performOK() {
            return true;
        }

        @Override
        public boolean performCancel() {
            return true;
        }

        @Override
        public void validate() {
            DebuggerCompositeFragment.this.setMessage(DebuggerCompositeFragment.this.getDescription(), 0);
        }

        @Override
        public boolean canTest() {
            return false;
        }

        @Override
        public void performTest() {
        }
    }

    private class PHPExeListener
    implements IPHPexeItemListener {
        private PHPExeListener() {
        }

        public void phpExeChanged(PHPexeItemEvent event) {
            if (event.getProperty().equals("exe-location") || event.getProperty().equals("ini-location") || event.getProperty().equals("use-default-ini")) {
                DebuggerCompositeFragment.this.detectDebugger = true;
            } else if (!DebuggerCompositeFragment.this.updatingDebuggerId && event.getProperty().equals("debugger-id")) {
                ((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId = (String)event.getNewValue();
                Display.getDefault().syncExec((Runnable)new SelectDebuggerRunnable());
            }
        }
    }

    private class PHPServerListener
    implements PropertyChangeListener {
        private PHPServerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (!DebuggerCompositeFragment.this.updatingDebuggerId && event.getPropertyName().equals("debuggerId")) {
                ((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId = (String)event.getNewValue();
                Display.getDefault().syncExec((Runnable)new SelectDebuggerRunnable());
            }
        }
    }

    private class SelectDebuggerRunnable
    implements Runnable {
        private SelectDebuggerRunnable() {
        }

        @Override
        public void run() {
            DebuggerCompositeFragment.this.selectDebugger(((DebuggerCompositeFragment)DebuggerCompositeFragment.this).modifiedValuesCache.debuggerId);
        }
    }

    private class ValuesCache {
        String debuggerId;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache cache) {
            this.debuggerId = cache.debuggerId;
        }
    }
}

