/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.debug.ui.ExternalFileEditorInput;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.zend.communication.RemoteFileStorage;
import org.eclipse.php.internal.debug.core.zend.model.PHPMultiDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUICompositeImageDescriptor;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.PHPBreakpointImageDescriptor;
import org.eclipse.php.internal.debug.ui.breakpoint.PHPExceptionBreakpointAnnotation;
import org.eclipse.php.internal.debug.ui.editor.RemoteFileStorageEditorInput;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private ImageDescriptorRegistry fDebugImageRegistry;
    private Map<IThread, Annotation> fExceptionAnnotations = new HashMap<IThread, Annotation>();

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value instanceof PHPValue ? ((PHPValue)value).getValueDetail() : (value instanceof AbstractDBGpValue ? ((AbstractDBGpValue)value).getValueDetail() : value.getValueString());
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        listener.detailComputed(value, detail);
    }

    public Image getImage(Object element) {
        if (element instanceof PHPConditionalBreakpoint) {
            return this.getLineBreakpointImage((PHPConditionalBreakpoint)element);
        }
        if (element instanceof IPHPExceptionBreakpoint) {
            return this.getExceptionBreakpointImage((IPHPExceptionBreakpoint)element);
        }
        if (element instanceof IVariable) {
            return this.getVariableImage((IVariable)element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IDebugTarget) {
            return this.getTargetText((IDebugTarget)element);
        }
        if (element instanceof IThread) {
            return this.getThreadText((IThread)element);
        }
        if (element instanceof IStackFrame) {
            return this.getStackFrameText((IStackFrame)element);
        }
        if (element instanceof ILineBreakpoint) {
            return this.getLineBreakpointText((ILineBreakpoint)element);
        }
        if (element instanceof IPHPExceptionBreakpoint) {
            return this.getExceptionBreakpointText((IPHPExceptionBreakpoint)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        if (inputObject instanceof RemoteFileStorage) {
            return "org.eclipse.php.editor";
        }
        if (input instanceof NonExistingPHPFileEditorInput) {
            return "org.eclipse.php.untitledPhpEditor";
        }
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException e) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof RemoteFileStorage) {
            return new RemoteFileStorageEditorInput((RemoteFileStorage)element);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IFileHandle) {
            return new ExternalFileEditorInput((IFileHandle)element);
        }
        if (element instanceof ILineBreakpoint) {
            return this.getLineBreakpointEditorInput(element);
        }
        if (element instanceof IStorage) {
            return new ExternalStorageEditorInput((IStorage)element);
        }
        if (element instanceof IFileStore) {
            IFileStore fileStore = (IFileStore)element;
            NonExistingPHPFileEditorInput nonExistingEditorInput = NonExistingPHPFileEditorInput.findEditorInput((IPath)new Path(fileStore.toURI().getPath()));
            if (nonExistingEditorInput != null) {
                return nonExistingEditorInput;
            }
            return new FileStoreEditorInput(fileStore);
        }
        Logger.log(202, "Unknown editor input type: " + element.getClass().getName());
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = frame.getThread().getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IPHPExceptionBreakpoint) {
                IPHPExceptionBreakpoint exceptionBreakpoint = (IPHPExceptionBreakpoint)breakpoint;
                try {
                    if (frame.getLineNumber() == exceptionBreakpoint.getLine(frame.getDebugTarget())) {
                        this.addExceptionAnnotation(editorPart, frame, exceptionBreakpoint);
                        return true;
                    }
                }
                catch (DebugException e) {
                    Logger.logException(e);
                }
            }
            ++n2;
        }
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IEditorInput editorInput;
        ITextEditor textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        Annotation annotation = this.fExceptionAnnotations.remove(thread);
        if (annotation != null) {
            annModel.removeAnnotation(annotation);
        }
    }

    protected Image getVariableImage(IVariable variable) {
        IVariableFacet facetOwner = null;
        facetOwner = variable instanceof IVariableFacet ? (IVariableFacet)variable : (IVariableFacet)variable.getAdapter(IVariableFacet.class);
        if (facetOwner == null) {
            return null;
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_SUPER_GLOBAL)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_SUPER_GLOBAL");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_LOCAL)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_LOCAL");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_THIS)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_PUBLIC_ACCESS");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_ARRAY_MEMBER)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_ARRAY");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_CONSTANT) && facetOwner.hasFacet(IVariableFacet.Facet.MOD_PUBLIC)) {
            return this.getDebugImageRegistry().get((ImageDescriptor)new PHPDebugUICompositeImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_OBJ_MEMBER_PUBLIC_ACCESS"), PHPDebugUIImages.getImageDescriptor("IMG_OVR_MEMBER_CONSTANT"), 0));
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.KIND_OBJECT_MEMBER)) {
            if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_PUBLIC)) {
                if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_STATIC)) {
                    return this.getDebugImageRegistry().get((ImageDescriptor)new PHPDebugUICompositeImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_OBJ_MEMBER_PUBLIC_ACCESS"), PHPDebugUIImages.getImageDescriptor("IMG_OVR_MEMBER_STATIC"), 0));
                }
                return PHPDebugUIImages.get("IMG_OBJ_MEMBER_PUBLIC_ACCESS");
            }
            if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_PROTECTED)) {
                if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_STATIC)) {
                    return this.getDebugImageRegistry().get((ImageDescriptor)new PHPDebugUICompositeImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_OBJ_MEMBER_PROTECTED_ACCESS"), PHPDebugUIImages.getImageDescriptor("IMG_OVR_MEMBER_STATIC"), 0));
                }
                return PHPDebugUIImages.get("IMG_OBJ_MEMBER_PROTECTED_ACCESS");
            }
            if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_PRIVATE)) {
                if (facetOwner.hasFacet(IVariableFacet.Facet.MOD_STATIC)) {
                    return this.getDebugImageRegistry().get((ImageDescriptor)new PHPDebugUICompositeImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_OBJ_MEMBER_PRIVATE_ACCESS"), PHPDebugUIImages.getImageDescriptor("IMG_OVR_MEMBER_STATIC"), 0));
                }
                return PHPDebugUIImages.get("IMG_OBJ_MEMBER_PRIVATE_ACCESS");
            }
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.VIRTUAL_CLASS)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_VIRTUAL_CLASS");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.VIRTUAL_PARTITION)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_VIRTUAL_CONTAINER");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.VIRTUAL_LENGTH)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_VIRTUAL_LENGTH");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.VIRTUAL_UNINIT)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_VIRTUAL_UNINIT");
        }
        if (facetOwner.hasFacet(IVariableFacet.Facet.VIRTUAL_ARRAY_MEMBER)) {
            return PHPDebugUIImages.get("IMG_OBJ_MEMBER_VIRTUAL_ARRAY");
        }
        return null;
    }

    protected Image getLineBreakpointImage(PHPConditionalBreakpoint breakpoint) {
        try {
            if (breakpoint.isConditionEnabled()) {
                PHPBreakpointImageDescriptor descriptor = breakpoint.isEnabled() ? new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), 96) : new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 64);
                return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
            }
        }
        catch (CoreException e) {
            return null;
        }
        return null;
    }

    protected Image getExceptionBreakpointImage(IPHPExceptionBreakpoint breakpoint) {
        try {
            switch (breakpoint.getType()) {
                case EXCEPTION: {
                    if (breakpoint.isEnabled()) {
                        return PHPDebugUIImages.get("IMG_ELCL_EXCEPTION_BREAKPOINT");
                    }
                    return PHPDebugUIImages.get("IMG_DLCL_EXCEPTION_BREAKPOINT");
                }
                case ERROR: {
                    if (breakpoint.isEnabled()) {
                        return PHPDebugUIImages.get("IMG_ELCL_ERROR_BREAKPOINT");
                    }
                    return PHPDebugUIImages.get("IMG_DLCL_ERROR_BREAKPOINT");
                }
            }
            return null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    protected ImageDescriptorRegistry getDebugImageRegistry() {
        if (this.fDebugImageRegistry == null) {
            this.fDebugImageRegistry = PHPDebugUIPlugin.getImageDescriptorRegistry();
        }
        return this.fDebugImageRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getLineBreakpointText(ILineBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        IResource resource = marker.getResource();
        try {
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            String fileName = null;
            if (resource instanceof IFile) {
                fileName = resource.getFullPath().toString();
            } else if (resource instanceof IWorkspaceRoot) {
                fileName = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                if (fileName == null) {
                    return null;
                }
                IPath path = Path.fromPortableString((String)fileName);
                if (path.getDevice() == null && path.toString().startsWith("org.eclipse.dltk")) {
                    String fullPathString = path.toString();
                    String absolutePath = fullPathString.substring(fullPathString.indexOf(58) + 1);
                    path = Path.fromPortableString((String)absolutePath);
                } else {
                    path = EnvironmentPathUtils.getLocalPath((IPath)path);
                }
                NonExistingPHPFileEditorInput nonExistingEditorInput = NonExistingPHPFileEditorInput.findEditorInput((IPath)path);
                fileName = nonExistingEditorInput != null ? nonExistingEditorInput.getName() : (EnvironmentPathUtils.isFull((IPath)path) ? EnvironmentPathUtils.getLocalPathString((IPath)path) : path.toPortableString());
            }
            if (fileName == null) return null;
            return String.valueOf(fileName) + " [line: " + lineNumber.toString() + "]";
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return null;
    }

    protected String getExceptionBreakpointText(IPHPExceptionBreakpoint breakpoint) {
        switch (breakpoint.getType()) {
            case EXCEPTION: {
                return String.valueOf(breakpoint.getExceptionName()) + PHPDebugUIMessages.PHPModelPresentation_Break_on_exception;
            }
            case ERROR: {
                return String.valueOf(breakpoint.getExceptionName()) + PHPDebugUIMessages.PHPModelPresentation_Break_on_error_condition;
            }
        }
        return null;
    }

    protected String getTargetText(IDebugTarget target) {
        String label = "";
        if (target.isTerminated()) {
            label = MessageFormat.format((String)PHPDebugUIMessages.MPresentation_Terminated_1, (Object[])new Object[0]);
        }
        String name = PHPDebugUIMessages.MPresentation_PHP_APP_1;
        if (target instanceof PHPMultiDebugTarget) {
            name = String.valueOf(PHPDebugUIMessages.MPresentation_PHP_APP_1) + PHPDebugUIMessages.PHPModelPresentation_ParallelRequests;
        }
        return String.valueOf(label) + name;
    }

    protected String getThreadText(IThread thread) {
        StringBuilder buf = new StringBuilder();
        IDebugTarget target = thread.getDebugTarget();
        try {
            String targetName = target.getName();
            targetName = this.resolveUntitledEditorName(targetName);
            buf.append(targetName);
        }
        catch (DebugException e) {
            Logger.logException(e);
        }
        if (thread.isStepping()) {
            buf.append(PHPDebugUIMessages.MPresentation_Stepping_1);
        } else if (thread.isSuspended()) {
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length == 0) {
                buf.append(PHPDebugUIMessages.MPresentation_Suspended_1);
            } else {
                IBreakpoint breakpoint = breakpoints[0];
                if (breakpoint instanceof PHPLineBreakpoint) {
                    buf.append(PHPDebugUIMessages.MPresentation_SLineBreakpoint_1);
                } else if (breakpoint instanceof IPHPExceptionBreakpoint) {
                    buf.append(PHPDebugUIMessages.MPresentation_SExceptionBreakpoint_1);
                }
            }
        } else if (thread.isTerminated()) {
            buf.append(PHPDebugUIMessages.MPresentation_Terminated_1);
        }
        return buf.toString();
    }

    protected String getStackFrameText(IStackFrame frame) {
        if (frame instanceof PHPStackFrame) {
            PHPStackFrame phpStackFrame = (PHPStackFrame)frame;
            try {
                StringBuffer buffer = new StringBuffer();
                String frameName = phpStackFrame.getName();
                if (frameName != null && frameName.length() > 0) {
                    buffer.append(frameName);
                    buffer.append("(): ");
                }
                String sourceName = phpStackFrame.getSourceName();
                sourceName = this.resolveUntitledEditorName(sourceName);
                buffer.append(sourceName);
                buffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + ' ' + phpStackFrame.getLineNumber());
                return buffer.toString();
            }
            catch (DebugException e) {
                Logger.logException(e);
            }
        }
        return "";
    }

    protected IEditorInput getLineBreakpointEditorInput(Object element) {
        String location;
        block12: {
            IMarker marker;
            block11: {
                ILineBreakpoint bp = (ILineBreakpoint)element;
                marker = bp.getMarker();
                try {
                    String decodedFileName;
                    String originalURL = (String)marker.getAttribute("uriginalURL");
                    if (originalURL == null) break block11;
                    String location2 = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                    try {
                        decodedFileName = URLDecoder.decode(location2, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        decodedFileName = location2;
                    }
                    return new RemoteFileStorageEditorInput(new RemoteFileStorage(null, decodedFileName, originalURL));
                }
                catch (CoreException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
            }
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            location = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
            if (location != null) break block12;
            return null;
        }
        try {
            IPath path = Path.fromPortableString((String)location);
            NonExistingPHPFileEditorInput nonExistingEditorInput = NonExistingPHPFileEditorInput.findEditorInput((IPath)path);
            if (nonExistingEditorInput != null) {
                return nonExistingEditorInput;
            }
            HandleFactory fac = new HandleFactory();
            IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, PHPLanguageToolkit.getDefault());
            Openable openable = fac.createOpenable(path.toString(), scope);
            if (openable instanceof IStorage) {
                return new ExternalStorageEditorInput((IStorage)openable);
            }
            File localFile = new File(location);
            if (localFile.exists()) {
                return new FileStoreEditorInput((IFileStore)new LocalFile(localFile));
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    private String resolveUntitledEditorName(String location) {
        try {
            NonExistingPHPFileEditorInput nonExistingEditorInput = NonExistingPHPFileEditorInput.findEditorInput((IPath)new Path(location));
            if (nonExistingEditorInput != null) {
                location = nonExistingEditorInput.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return location;
    }

    private void addExceptionAnnotation(IEditorPart editorPart, IStackFrame frame, IPHPExceptionBreakpoint breakpoint) {
        IEditorInput editorInput;
        ITextEditor textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        Position position = null;
        int charStart = -1;
        int length = -1;
        try {
            charStart = frame.getCharStart();
            length = frame.getCharEnd() - charStart;
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (charStart < 0) {
            IDocument doc = docProvider.getDocument((Object)editorInput);
            if (doc == null) {
                return;
            }
            try {
                int lineNumber = frame.getLineNumber() - 1;
                IRegion region = doc.getLineInformation(lineNumber);
                charStart = region.getOffset();
                length = region.getLength();
            }
            catch (BadLocationException ble) {
                return;
            }
            catch (DebugException de) {
                return;
            }
        }
        if (charStart < 0) {
            return;
        }
        position = new Position(charStart, length);
        if (frame.isTerminated()) {
            return;
        }
        Annotation annotation = this.fExceptionAnnotations.remove(frame.getThread());
        if (annotation != null) {
            annModel.removeAnnotation(annotation);
        }
        annotation = new PHPExceptionBreakpointAnnotation(breakpoint);
        this.fExceptionAnnotations.put(frame.getThread(), annotation);
        annModel.addAnnotation(annotation, position);
        this.positionEditor(textEditor, frame);
    }

    private void positionEditor(ITextEditor editor, IStackFrame frame) {
        try {
            IRegion region;
            int charStart = frame.getCharStart();
            if (charStart >= 0) {
                editor.selectAndReveal(charStart, 0);
                return;
            }
            int lineNumber = frame.getLineNumber();
            if ((region = this.getLineInformation(editor, --lineNumber)) != null) {
                editor.selectAndReveal(region.getOffset(), 0);
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }
}

