/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.regex.Pattern;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;

public class MagicMemberUtil {
    public static final Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\p{javaWhitespace}+");
    public static final String VOID_RETURN_TYPE = "void";

    public static String removeParenthesis(String[] split) {
        String name = split[1];
        return name.endsWith("()") ? name.substring(0, name.length() - 2) : name;
    }

    public static String removeParenthesis2(String[] split) {
        String name = split[1];
        int index = name.indexOf(40);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name.endsWith("()") ? name.substring(0, name.length() - 2) : name;
    }

    public static MagicMethod getMagicMethod(String docValue) {
        String[] split = WHITESPACE_SEPERATOR.split(docValue = docValue.trim());
        if (split.length < 2) {
            return null;
        }
        MagicMethod mi = new MagicMethod();
        try {
            mi.returnType = split[0];
            mi.name = MagicMemberUtil.removeParenthesis(split);
            if (split.length > 1) {
                int i = 0;
                while (i < 2) {
                    docValue = docValue.substring(split[i].length()).trim();
                    ++i;
                }
                MagicMemberUtil.collectMagicMethodData(docValue, mi);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return mi;
    }

    public static MagicMethod getMagicMethod2(String docValue) {
        String[] split = WHITESPACE_SEPERATOR.split(docValue = docValue.trim());
        if (split.length < 2) {
            return null;
        }
        MagicMethod mi = new MagicMethod();
        try {
            mi.returnType = split[0];
            mi.name = MagicMemberUtil.removeParenthesis2(split);
            if (split.length > 1) {
                docValue = docValue.substring(split[0].length()).trim();
                MagicMemberUtil.collectMagicMethodData(docValue, mi);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return mi;
    }

    private static void collectMagicMethodData(String docValue, MagicMethod mi) {
        if (docValue.startsWith(mi.name)) {
            if ((docValue = docValue.substring(mi.name.length()).trim()).startsWith("(") && docValue.indexOf(41) > 0) {
                int endIndex = docValue.indexOf(41);
                String paramsString = docValue.substring(1, endIndex);
                String[] params = paramsString.split(",");
                String[] paramType = new String[params.length];
                String[] paramName = new String[params.length];
                String[] paramValue = new String[params.length];
                int i = 0;
                while (i < params.length) {
                    String[] paramPair;
                    String param = params[i];
                    String value = null;
                    int equalIndex = param.indexOf(61);
                    if (equalIndex > 0) {
                        value = param.substring(equalIndex + 1).trim();
                        param = param.substring(0, equalIndex).trim();
                    }
                    if ((paramPair = WHITESPACE_SEPERATOR.split(param.trim())).length == 1) {
                        paramName[i] = paramPair[0];
                    } else if (paramPair.length == 2) {
                        paramType[i] = paramPair[0];
                        paramName[i] = paramPair[1];
                    }
                    if (value != null) {
                        paramValue[i] = value;
                    }
                    ++i;
                }
                mi.parameterNames = paramName;
                mi.parameterTypes = paramType;
                mi.parameterInitializers = paramValue;
                mi.desc = docValue.length() > endIndex ? docValue.substring(endIndex + 1) : "";
            } else {
                mi.desc = docValue;
            }
        } else {
            mi.desc = docValue;
        }
    }

    public static MagicField getMagicPropertiesField(PHPDocTag tag) {
        if (!tag.isValidPropertiesTag()) {
            return null;
        }
        MagicField info = new MagicField();
        info.name = tag.getVariableReference().getName();
        info.type = tag.getSingleTypeReference().getName();
        info.desc = tag.getTrimmedDescText();
        return info;
    }

    public static class MagicField
    extends MagicMember {
        public String type;
    }

    public static class MagicMember {
        public String name;
        public String desc;
    }

    public static class MagicMethod
    extends MagicMember {
        public String[] parameterNames;
        public String[] parameterInitializers;
        public String[] parameterTypes;
        public String returnType;
    }
}

