/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.eclipse.dltk.ti.types.IEvaluatedType;

public class PHPNamespaceConstantType
implements IEvaluatedType {
    private String namespace;
    private String constantName;
    private IEvaluatedType valueType;
    private boolean global = false;

    public PHPNamespaceConstantType(String constantName) {
        if (constantName == null) {
            throw new IllegalArgumentException();
        }
        int i = constantName.lastIndexOf(92);
        if (i == -1) {
            this.constantName = constantName;
        } else if (i == 0) {
            this.constantName = constantName.substring(1, constantName.length());
            this.global = true;
        } else if (i > 0) {
            if (constantName.charAt(0) != '\\') {
                constantName = '\\' + constantName;
                ++i;
            }
            this.namespace = constantName.substring(0, i);
            this.constantName = constantName;
        }
    }

    public PHPNamespaceConstantType(String namespace, String typeName) {
        if (namespace == null || typeName == null) {
            throw new IllegalArgumentException();
        }
        if (namespace.length() > 0 && namespace.charAt(0) != '\\') {
            namespace = String.valueOf('\\') + namespace;
        }
        this.namespace = namespace;
        this.constantName = namespace + '\\' + typeName;
    }

    public void setValueType(IEvaluatedType valueType) {
        this.valueType = valueType;
    }

    public IEvaluatedType getValueType() {
        return this.valueType;
    }

    public String getTypeName() {
        if (this.valueType != null) {
            return this.valueType.getTypeName();
        }
        return "unknown";
    }

    public String getConstantName() {
        return this.constantName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public String getModelKey() {
        return this.constantName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.constantName == null ? 0 : this.constantName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPNamespaceConstantType other = (PHPNamespaceConstantType)obj;
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.constantName == null ? other.constantName != null : !this.constantName.equals(other.constantName));
    }
}

