/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.AbstractLanguageToolkit;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;

public class PHPLanguageToolkit
extends AbstractLanguageToolkit
implements IDLTKLanguageToolkitExtension {
    private static final IContentType PHP_CONTENT_TYPE = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
    private static PHPLanguageToolkit toolkit = new PHPLanguageToolkit();

    protected String getCorePluginID() {
        return "org.eclipse.php.core";
    }

    public String[] getLanguageFileExtensions() {
        return PHP_CONTENT_TYPE.getFileSpecs(8);
    }

    public String getLanguageName() {
        return "PHP";
    }

    public String getNatureId() {
        return "org.eclipse.php.core.PHPNature";
    }

    public String getLanguageContentType() {
        return ContentTypeIdForPHP.ContentTypeID_PHP;
    }

    public static IDLTKLanguageToolkit getDefault() {
        return toolkit;
    }

    public boolean languageSupportZIPBuildpath() {
        return true;
    }

    public IArchive openArchive(File localFile) throws IOException {
        return PHPToolkitUtil.getArchive(localFile);
    }

    public boolean isArchiveFileName(String name) {
        return PHPToolkitUtil.isPharFileName(name);
    }

    public IStatus validateSourceModule(IResource resource) {
        return PHP_CONTENT_TYPE.isAssociatedWith(resource.getName()) ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }
}

