/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IOperationNode;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class UnaryOperation
extends Expression
implements IOperationNode {
    public static final int OP_PLUS = 0;
    public static final int OP_MINUS = 1;
    public static final int OP_NOT = 2;
    public static final int OP_TILDA = 3;
    private Expression expression;
    private int operator;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(UnaryOperation.class, "expression", Expression.class, true, true);
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(UnaryOperation.class, "operator", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(EXPRESSION_PROPERTY);
        propertyList.add(OPERATOR_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public UnaryOperation(int start, int end, AST ast, Expression expr, int operator) {
        super(start, end, ast);
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expr);
        this.setOperator(operator);
    }

    public UnaryOperation(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<UnaryOperation");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(UnaryOperation.getOperator(this.operator)).append("'>\n");
        this.expression.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</UnaryOperation>");
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "!";
            }
            case 3: {
                return "~";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getType() {
        return 59;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public String getOperationString() {
        return UnaryOperation.getOperator(this.getOperator());
    }

    @Override
    public String getOperationString(int op) {
        return UnaryOperation.getOperator(op);
    }

    public final void setOperator(int value) {
        if (UnaryOperation.getOperator(value) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = value;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expression = ASTNode.copySubtree(target, this.getExpression());
        UnaryOperation result = new UnaryOperation(this.getStart(), this.getEnd(), target, expression, this.getOperator());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

