/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class SwitchCase
extends Statement {
    private Expression value;
    private ASTNode.NodeList<Statement> actions = new ASTNode.NodeList(this, ACTIONS_PROPERTY);
    private boolean isDefault;
    public static final ChildPropertyDescriptor VALUE_PROPERTY = new ChildPropertyDescriptor(SwitchCase.class, "value", Expression.class, false, true);
    public static final ChildListPropertyDescriptor ACTIONS_PROPERTY = new ChildListPropertyDescriptor(SwitchCase.class, "actions", Statement.class, true);
    public static final SimplePropertyDescriptor IS_DEFAULT_PROPERTY = new SimplePropertyDescriptor(SwitchCase.class, "isDefault", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(1);
        propertyList.add(VALUE_PROPERTY);
        propertyList.add(ACTIONS_PROPERTY);
        propertyList.add(IS_DEFAULT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public SwitchCase(int start, int end, AST ast, Expression value, List<Statement> actions2, boolean isDefault) {
        super(start, end, ast);
        if (actions2 == null) {
            throw new IllegalArgumentException();
        }
        if (value != null) {
            this.setValue(value);
        }
        this.actions.addAll(actions2);
        this.setIsDefault(isDefault);
    }

    public SwitchCase(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.value != null) {
            this.value.accept(visitor);
        }
        for (ASTNode aSTNode : this.actions) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.value != null) {
            this.value.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.actions) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.value != null) {
            this.value.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.actions) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<SwitchCase");
        this.appendInterval(buffer);
        buffer.append(" isDefault='").append(this.isDefault).append("'>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        if (this.value != null) {
            this.value.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Value>\n");
        for (ASTNode aSTNode : this.actions) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</SwitchCase>");
    }

    @Override
    public int getType() {
        return 55;
    }

    public List<Statement> actions() {
        return this.actions;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.preValueChange(IS_DEFAULT_PROPERTY);
        this.isDefault = isDefault;
        this.postValueChange(IS_DEFAULT_PROPERTY);
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        if (this.isDefault || value == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.value;
        this.preReplaceChild(oldChild, value, VALUE_PROPERTY);
        this.value = value;
        this.postReplaceChild(oldChild, value, VALUE_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_DEFAULT_PROPERTY) {
            if (get) {
                return this.isDefault();
            }
            this.setIsDefault(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == VALUE_PROPERTY) {
            if (get) {
                return this.getValue();
            }
            this.setValue((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ACTIONS_PROPERTY) {
            return this.actions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    ASTNode clone0(AST target) {
        boolean isDefault = this.isDefault();
        List<Statement> actions2 = ASTNode.copySubtrees(target, this.actions());
        Expression value = ASTNode.copySubtree(target, this.getValue());
        return new SwitchCase(this.getStart(), this.getEnd(), target, value, actions2, isDefault);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

