/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartRepresentation;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;

public class LinkRepresentation {
    private final int align;
    private final EditPart link;
    private final EditPartRepresentation target;
    private final EditPartRepresentation source;
    private EditPartRepresentation fixedEditPart = null;
    private EditPartRepresentation movedEditPart = null;
    private Point referencePoint;
    private Point movedPoint;

    public LinkRepresentation(EditPart link, EditPartRepresentation source, EditPartRepresentation target, int alignment) {
        this.link = link;
        this.target = target;
        this.source = source;
        this.align = alignment;
    }

    public EditPart getLink() {
        return this.link;
    }

    public EditPartRepresentation getSource() {
        return this.source;
    }

    public EditPartRepresentation getTarget() {
        return this.target;
    }

    public Command getCommand() {
        this.initializeReferences();
        this.buildRequest();
        CompoundCommand command = new CompoundCommand("Align with a link");
        Command cmd = this.movedEditPart.getCommand();
        if (cmd != null && cmd.canExecute()) {
            command.add(cmd);
        }
        if ((cmd = this.preserveAnchorLocationCommand()).canExecute()) {
            command.add(cmd);
        }
        SetAllBendpointRequest onlyTwoBendpoints = new SetAllBendpointRequest("set_all_connection_bendpoint", new PointList(), null, null);
        command.add(this.link.getCommand((Request)onlyTwoBendpoints));
        return command;
    }

    protected void buildRequest() {
        int shift = 0;
        PrecisionRectangle absolutePosition = this.movedEditPart.getPosition();
        PrecisionPoint oldLocation = new PrecisionPoint(absolutePosition.getTopLeft());
        PrecisionPoint newLocation = new PrecisionPoint((Point)oldLocation);
        switch (this.align) {
            case 1: {
                shift = this.referencePoint.y - this.movedPoint.y;
                this.movedPoint.y += shift;
                newLocation.setLocation(newLocation.x, newLocation.y + shift);
                break;
            }
            case 4: {
                shift = this.referencePoint.y - this.movedPoint.y;
                this.movedPoint.y += shift;
                newLocation.setLocation(newLocation.x, newLocation.y + shift);
                break;
            }
            case 8: {
                shift = this.referencePoint.x - this.movedPoint.x;
                this.movedPoint.x += shift;
                newLocation.setLocation(newLocation.x + shift, newLocation.y);
                break;
            }
            case 32: {
                shift = this.referencePoint.x - this.movedPoint.x;
                this.movedPoint.x += shift;
                newLocation.setLocation(newLocation.x + shift, newLocation.y);
            }
        }
        PrecisionRectangle parentBounds = LayoutUtils.getAbsolutePosition(this.movedEditPart.getRepresentedEditPart().getParent());
        if (this.align == 1 || this.align == 4) {
            if ((double)newLocation.y < (double)parentBounds.y + 6.0 && shift < 0) {
                newLocation.setLocation(newLocation.x, parentBounds.y + 6);
            } else if (newLocation.y + absolutePosition.height > parentBounds.getBottomLeft().y && shift > 0) {
                newLocation.setLocation(newLocation.x, parentBounds.getBottomLeft().y - (6 + absolutePosition.height));
            }
        } else if (this.align == 8 || this.align == 32) {
            if ((double)newLocation.x < (double)parentBounds.x + 6.0 && shift < 0) {
                newLocation.setLocation(parentBounds.x + 6, newLocation.y);
            } else if (newLocation.x + absolutePosition.width > parentBounds.getBottomRight().x && shift > 0) {
                newLocation.setLocation(parentBounds.getBottomRight().x - (6 + absolutePosition.width), newLocation.y);
            }
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
        req.setEditParts(this.movedEditPart.getRepresentedEditPart());
        Dimension delta = newLocation.getDifference((Point)oldLocation);
        req.setMoveDelta(new Point(delta.width, delta.height));
        req.setSizeDelta(new Dimension(0, 0));
        this.movedEditPart.setRequest(req);
        this.movedEditPart.setMoveDelta(delta);
    }

    protected void initializeReferences() {
        PrecisionRectangle absolutePositionSource = LayoutUtils.getAbsolutePosition(this.source.getRepresentedEditPart());
        PrecisionRectangle absolutePositionTarget = LayoutUtils.getAbsolutePosition(this.target.getRepresentedEditPart());
        switch (this.align) {
            case 1: {
                if (absolutePositionSource.preciseX < absolutePositionTarget.preciseX) {
                    this.fixedEditPart = this.target;
                    break;
                }
                this.fixedEditPart = this.source;
                break;
            }
            case 4: {
                if (absolutePositionSource.preciseX > absolutePositionTarget.preciseX) {
                    this.fixedEditPart = this.target;
                    break;
                }
                this.fixedEditPart = this.source;
                break;
            }
            case 8: {
                if (absolutePositionSource.preciseY < absolutePositionTarget.preciseY) {
                    this.fixedEditPart = this.target;
                    break;
                }
                this.fixedEditPart = this.source;
                break;
            }
            case 32: {
                this.fixedEditPart = absolutePositionSource.preciseY > absolutePositionTarget.preciseY ? this.target : this.source;
            }
        }
        assert (this.fixedEditPart != null);
        this.movedEditPart = this.source == this.fixedEditPart ? this.target : this.source;
        PolylineConnectionEx figure = (PolylineConnectionEx)((AbstractConnectionEditPart)this.link).getFigure();
        if (this.fixedEditPart == this.source) {
            this.referencePoint = figure.getStart();
            this.movedPoint = figure.getEnd();
        } else {
            this.referencePoint = figure.getEnd();
            this.movedPoint = figure.getStart();
        }
        Dimension delta = this.fixedEditPart.getMoveDelta();
        this.referencePoint.translate(delta);
        figure.translateToAbsolute((Translatable)this.referencePoint);
        figure.translateToAbsolute((Translatable)this.movedPoint);
    }

    public int getLinkSideOnSource() {
        PolylineConnectionEx figure = (PolylineConnectionEx)((AbstractConnectionEditPart)this.link).getFigure();
        Point sourcePoint = figure.getStart();
        figure.translateToAbsolute((Translatable)sourcePoint);
        return LayoutUtils.getAnchorPosition(this.source.getRepresentedEditPart(), sourcePoint);
    }

    public int getLinkSideOnTarget() {
        PolylineConnectionEx figure = (PolylineConnectionEx)((AbstractConnectionEditPart)this.link).getFigure();
        Point targetPoint = figure.getEnd();
        figure.translateToAbsolute((Translatable)targetPoint);
        return LayoutUtils.getAnchorPosition(this.target.getRepresentedEditPart(), targetPoint);
    }

    protected Command preserveAnchorLocationCommand() {
        CompoundCommand command = new CompoundCommand("Preserve Anchor");
        if (this.movedEditPart == this.source) {
            ReconnectRequest reconnectRequest = new ReconnectRequest();
            reconnectRequest.setType((Object)"Reconnection source");
            reconnectRequest.setConnectionEditPart((ConnectionEditPart)this.link);
            reconnectRequest.setTargetEditPart(this.source.getRepresentedEditPart());
            reconnectRequest.setLocation(this.movedPoint.getTranslated(-this.movedEditPart.getMoveDelta().width, -this.movedEditPart.getMoveDelta().height));
            Command cmd = this.source.getRepresentedEditPart().getCommand((Request)reconnectRequest);
            command.add(cmd);
            ReconnectRequest reconnectRequestTarget = new ReconnectRequest();
            reconnectRequestTarget.setType((Object)"Reconnection target");
            reconnectRequestTarget.setConnectionEditPart((ConnectionEditPart)this.link);
            reconnectRequestTarget.setTargetEditPart(this.target.getRepresentedEditPart());
            reconnectRequestTarget.setLocation(this.referencePoint.getTranslated(-this.fixedEditPart.getMoveDelta().width, -this.fixedEditPart.getMoveDelta().height));
            cmd = this.target.getRepresentedEditPart().getCommand((Request)reconnectRequestTarget);
            command.add(cmd);
        } else {
            ReconnectRequest reconnectRequest = new ReconnectRequest();
            reconnectRequest.setType((Object)"Reconnection target");
            reconnectRequest.setConnectionEditPart((ConnectionEditPart)this.link);
            reconnectRequest.setTargetEditPart(this.target.getRepresentedEditPart());
            reconnectRequest.setLocation(this.movedPoint.getTranslated(-this.movedEditPart.getMoveDelta().width, -this.movedEditPart.getMoveDelta().height));
            Command cmd = this.target.getRepresentedEditPart().getCommand((Request)reconnectRequest);
            command.add(cmd);
            ReconnectRequest reconnectRequestTarget = new ReconnectRequest();
            reconnectRequestTarget.setType((Object)"Reconnection source");
            reconnectRequestTarget.setConnectionEditPart((ConnectionEditPart)this.link);
            reconnectRequestTarget.setTargetEditPart(this.source.getRepresentedEditPart());
            reconnectRequestTarget.setLocation(this.referencePoint.getTranslated(-this.fixedEditPart.getMoveDelta().width, -this.fixedEditPart.getMoveDelta().height));
            cmd = this.source.getRepresentedEditPart().getCommand((Request)reconnectRequestTarget);
            command.add(cmd);
        }
        return command;
    }
}

