/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.papyrus.infra.nattable.celleditor.ButtonConfiguration;
import org.eclipse.papyrus.infra.nattable.widget.NatComboButton;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ComboBoxWithButtonCellEditor
extends ComboBoxCellEditor {
    private ButtonConfiguration buttonConfiguration;

    public ComboBoxWithButtonCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems, boolean freeEdit, boolean multiselect, ButtonConfiguration buttonConfig) {
        this(dataProvider, maxVisibleItems, freeEdit, buttonConfig);
        this.setMultiselect(multiselect);
    }

    public ComboBoxWithButtonCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems, boolean freeEdit, ButtonConfiguration action) {
        this(dataProvider, maxVisibleItems, action);
        this.setFreeEdit(freeEdit);
    }

    public ComboBoxWithButtonCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems, ButtonConfiguration action) {
        super(dataProvider, maxVisibleItems);
        this.buttonConfiguration = action;
    }

    public ComboBoxWithButtonCellEditor(IComboBoxDataProvider dataProvider, ButtonConfiguration action) {
        super(dataProvider);
        this.buttonConfiguration = action;
    }

    public ComboBoxWithButtonCellEditor(List<?> canonicalValues, int maxVisibleItems, boolean freeEdit, boolean multiselect, ButtonConfiguration action) {
        this(canonicalValues, maxVisibleItems, freeEdit, action);
        this.setMultiselect(multiselect);
    }

    public ComboBoxWithButtonCellEditor(List<?> canonicalValues, int maxVisibleItems, boolean freeEdit, ButtonConfiguration action) {
        this(canonicalValues, maxVisibleItems, action);
        this.setFreeEdit(freeEdit);
    }

    public ComboBoxWithButtonCellEditor(List<?> canonicalValues, int maxVisibleItems, ButtonConfiguration action) {
        super(canonicalValues, maxVisibleItems);
        this.buttonConfiguration = action;
    }

    public ComboBoxWithButtonCellEditor(List<?> canonicalValues, ButtonConfiguration action) {
        super(canonicalValues);
        this.buttonConfiguration = action;
    }

    public NatCombo createEditorControl(Composite parent) {
        int style = this.editMode == EditModeEnum.INLINE ? 0 : 2048;
        NatComboButton combo = this.iconImage == null ? new NatComboButton(parent, this.cellStyle, this.maxVisibleItems, this.freeEdit, this.multiselect, style, this.buttonConfiguration) : new NatComboButton(parent, this.cellStyle, this.maxVisibleItems, this.freeEdit, this.multiselect, style, this.iconImage, this.buttonConfiguration);
        combo.setCursor(new Cursor((Device)Display.getDefault(), 19));
        if (this.multiselect) {
            combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
            combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        }
        this.addNatComboListener(combo);
        this.buttonConfiguration.getAction().setCellLocation(this.layerCell.getColumnIndex(), this.layerCell.getRowIndex());
        this.buttonConfiguration.getAction().setNatCombo(combo);
        return combo;
    }
}

