/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class WriterMonitor
extends Writer
implements IFlushableStreamMonitor {
    private List<IStreamListener> fListeners;
    private IStreamListener[] fCachedListeners;
    private final StringBuffer fContents = new StringBuffer();
    private boolean fIsBuffered = true;

    public WriterMonitor() {
        this.fListeners = new LinkedList<IStreamListener>();
    }

    public void flushContents() {
        this.fContents.setLength(0);
    }

    public boolean isBuffered() {
        return this.fIsBuffered;
    }

    public void setBuffered(boolean buffer) {
        this.fIsBuffered = buffer;
    }

    public String getContents() {
        return this.fContents.toString();
    }

    private void notifyListeners(String newText) {
        IStreamListener[] listeners;
        IStreamListener[] iStreamListenerArray = listeners = this.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamListener listener = iStreamListenerArray[n2];
            try {
                listener.streamAppended(newText, (IStreamMonitor)this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IStreamListener[] getListeners() {
        List<IStreamListener> list = this.fListeners;
        synchronized (list) {
            if (this.fCachedListeners == null) {
                this.fCachedListeners = this.fListeners.toArray(new IStreamListener[this.fListeners.size()]);
            }
            return this.fCachedListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IStreamListener listener) {
        List<IStreamListener> list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
                this.fCachedListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IStreamListener listener) {
        List<IStreamListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(listener);
            this.fCachedListeners = null;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.fContents.append(cbuf, off, len);
        this.notifyListeners(new String(cbuf, off, len));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

