/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageServiceAccessor {
    private static Set<ProjectSpecificLanguageServerWrapper> projectServers = new HashSet<ProjectSpecificLanguageServerWrapper>();
    private static Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> providersToLSDefinitions = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    public static @NonNull Collection<LanguageServer> getLanguageServers(@NonNull IFile file, Predicate<ServerCapabilities> request) throws IOException {
        Collection<ProjectSpecificLanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(file, request);
        wrappers.forEach(w -> {
            try {
                w.connect(file.getLocation(), null);
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        });
        return wrappers.stream().map(ProjectSpecificLanguageServerWrapper::getServer).collect(Collectors.toList());
    }

    public static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), lsDefinition);
        if (wrapper != null) {
            wrapper.connect(file.getLocation(), null);
            return wrapper.getServer();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static @NonNull Collection<ProjectSpecificLanguageServerWrapper> getLSWrappers(@NonNull IFile file, @NonNull Predicate<ServerCapabilities> request) throws IOException {
        res = new LinkedHashSet<ProjectSpecificLanguageServerWrapper>();
        project = file.getProject();
        if (project == null) {
            return res;
        }
        res.addAll(LanguageServiceAccessor.getMatchingStartedWrappers(file, request));
        contentTypes = new LinkedList<IContentType>();
        addedContentTypes = new HashSet<IContentType>();
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                contents = file.getContents();
                try {
                    contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(contents, file.getName())));
                    addedContentTypes.addAll(contentTypes);
                    if (true) ** GOTO lbl48
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
            }
            catch (Throwable var7_10) {
                if (var6_6 == null) {
                    var6_6 = var7_10;
                } else if (var6_6 != var7_10) {
                    var6_6.addSuppressed(var7_10);
                }
                throw var6_6;
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            return res;
        }
        do {
            if ((contentType = (IContentType)contentTypes.poll()) == null) continue;
            for (ContentTypeToLanguageServerDefinition mapping : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                if (mapping == null || mapping.getValue() == null) continue;
                wrapper = LanguageServiceAccessor.getLSWrapperForConnection(project, (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue());
                if (request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
                res.add(wrapper);
            }
            if (contentType.getBaseType() == null || addedContentTypes.contains(contentType.getBaseType())) continue;
            addedContentTypes.add(contentType.getBaseType());
            contentTypes.add(contentType.getBaseType());
lbl48:
            // 4 sources

        } while (!contentTypes.isEmpty());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectSpecificLanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = null;
        Set<ProjectSpecificLanguageServerWrapper> set = projectServers;
        synchronized (set) {
            for (ProjectSpecificLanguageServerWrapper startedWrapper : LanguageServiceAccessor.getStartedLSWrappers(project)) {
                if (!startedWrapper.serverDefinition.equals(serverDefinition)) continue;
                wrapper = startedWrapper;
                break;
            }
            if (wrapper == null) {
                wrapper = new ProjectSpecificLanguageServerWrapper(project, serverDefinition);
                wrapper.start();
            }
            if (wrapper != null) {
                projectServers.add(wrapper);
            }
        }
        return wrapper;
    }

    private static @NonNull List<ProjectSpecificLanguageServerWrapper> getStartedLSWrappers(@NonNull IProject project) {
        return projectServers.stream().filter(wrapper -> wrapper.project.equals((Object)project)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ProjectSpecificLanguageServerWrapper> getMatchingStartedWrappers(@NonNull IFile file, @NonNull Predicate<ServerCapabilities> request) {
        IProject project = file.getProject();
        Set<ProjectSpecificLanguageServerWrapper> set = projectServers;
        synchronized (set) {
            return projectServers.stream().filter(wrapper -> wrapper.project.equals((Object)project)).filter(wrapper -> wrapper.isConnectedTo(file.getLocation())).filter(wrapper -> wrapper.getServerCapabilities() == null || request.test(wrapper.getServerCapabilities())).collect(Collectors.toList());
        }
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        ArrayList<@NonNull LanguageServer> serverInfos = new ArrayList<LanguageServer>();
        for (ProjectSpecificLanguageServerWrapper wrapper : projectServers) {
            @Nullable LanguageServer server = wrapper.getServer();
            if (server == null || request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
            serverInfos.add(server);
        }
        return serverInfos;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getLSDefinition(@NonNull StreamConnectionProvider provider) {
        return providersToLSDefinitions.get(provider);
    }

    public static @NonNull List<@NonNull LSPDocumentInfo> getLSPDocumentInfosFor(@NonNull IDocument document, @NonNull Predicate<ServerCapabilities> capabilityRequest) {
        IFile file = LSPEclipseUtils.getFile(document);
        URI fileUri = null;
        if (file != null && file.exists()) {
            fileUri = LSPEclipseUtils.toUri((IResource)file);
            ArrayList<LSPDocumentInfo> res = new ArrayList<LSPDocumentInfo>();
            try {
                for (ProjectSpecificLanguageServerWrapper wrapper : LanguageServiceAccessor.getLSWrappers(file, capabilityRequest)) {
                    wrapper.connect(file.getLocation(), document);
                    @Nullable LanguageServer server = wrapper.getServer();
                    if (server == null) continue;
                    res.add(new LSPDocumentInfo(fileUri, document, wrapper, server));
                }
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
            return res;
        }
        LanguageServerPlugin.logInfo("Non IFiles not supported yet");
        return Collections.emptyList();
    }

    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull ProjectSpecificLanguageServerWrapper wrapper;
        private final @NonNull LanguageServer server;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull ProjectSpecificLanguageServerWrapper wrapper, @NonNull LanguageServer server) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
            this.server = server;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        public @NonNull LanguageServer getLanguageClient() {
            return this.server;
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }
}

