/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleCommentHandler
extends AbstractHandler {
    private ITextOperationTarget operationTarget;

    public Object execute(ExecutionEvent event) {
        IDocument document;
        ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor == null || !editor.isEditable()) {
            return null;
        }
        this.updateOpTarget(editor);
        if (this.operationTarget == null) {
            return null;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        int operationCode = this.isSelectionCommented(selection, document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput())) ? 12 : 11;
        Shell shell = editor.getSite().getShell();
        if (!this.operationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)Localization.getString("ToggleComment_error_title"), (String)Localization.getString("ToggleComment_error_message"));
            }
            return null;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile(display, () -> this.operationTarget.doOperation(operationCode));
        return null;
    }

    public IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) throws BadLocationException {
        int start = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int end = document.getNumberOfLines() > endLine + 1 ? document.getLineOffset(endLine + 1) : document.getLength();
        return new Region(start, end - start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelectionCommented(ISelection selection, IDocument document) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)"__stp_partitioning", (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                int n = lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                assert (i < regions.length);
                assert (j < regions.length * 2);
                ++i;
                j += 2;
            }
            boolean hasComment = false;
            int i2 = 0;
            int j2 = 0;
            while (i2 < regions.length) {
                String prefix = "//";
                if (lines[j2] >= 0 && lines[j2 + 1] >= 0) {
                    if (this.isBlockCommented(lines[j2], lines[j2 + 1], prefix, document)) {
                        hasComment = true;
                    } else if (!this.isBlockEmpty(lines[j2], lines[j2 + 1], document)) {
                        return false;
                    }
                }
                ++i2;
                j2 += 2;
            }
            return hasComment;
        }
        catch (BadLocationException e) {
            ExceptionErrorDialog.openError((String)e.getLocalizedMessage(), (Exception)((Object)e));
            return false;
        }
    }

    public int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int offset = document.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = document.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException e) {
            ExceptionErrorDialog.openError((String)e.getLocalizedMessage(), (Exception)((Object)e));
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBlockEmpty(int startLine, int endLine, IDocument document) {
        try {
            int i = startLine;
            while (true) {
                if (i > endLine) {
                    return true;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                if (text.trim().length() != 0) return false;
                boolean bl = true;
                boolean isEmptyLine = bl;
                if (!isEmptyLine) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            ExceptionErrorDialog.openError((String)e.getLocalizedMessage(), (Exception)((Object)e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBlockCommented(int startLine, int endLine, String prefix, IDocument document) {
        try {
            boolean hasComment = false;
            int i = startLine;
            while (true) {
                boolean isEmptyLine;
                if (i > endLine) {
                    return hasComment;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                boolean bl = isEmptyLine = text.trim().length() == 0;
                if (!isEmptyLine) {
                    int prefixIndex = text.indexOf(prefix, 0);
                    if (prefixIndex == -1) {
                        return false;
                    }
                    String s = document.get(line.getOffset(), prefixIndex);
                    if ((s = s.trim()).length() != 0) {
                        return false;
                    }
                    hasComment = true;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            ExceptionErrorDialog.openError((String)e.getLocalizedMessage(), (Exception)((Object)e));
            return false;
        }
    }

    private void updateOpTarget(ITextEditor editor) {
        if (editor != null) {
            this.operationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
    }
}

