/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import java.util.Arrays;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelRoot;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelError;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSorting;
import org.eclipse.swt.graphics.Image;

public class UiModelRoot
implements IUiModelElement {
    private static UiModelRoot uiModelRoot = new UiModelRoot();
    private UiModelError rootError = null;
    private UiModelSession[] session = null;
    private static SortType sortType;

    protected UiModelRoot() {
    }

    public static UiModelRoot getDefault() {
        return uiModelRoot;
    }

    public void refreshModel() {
        OpModelSession[] dataModelEvents = this.getModelDataEvents();
        this.rootError = null;
        this.session = null;
        if (dataModelEvents == null || dataModelEvents.length == 0) {
            this.rootError = UiModelError.NO_SAMPLES_ERROR;
        } else {
            this.session = new UiModelSession[dataModelEvents.length];
            int i = 0;
            while (i < dataModelEvents.length) {
                this.session[i] = new UiModelSession(dataModelEvents[i]);
                ++i;
            }
        }
    }

    protected OpModelSession[] getModelDataEvents() {
        OpModelRoot modelRoot = OpModelRoot.getDefault();
        return modelRoot.getSessions();
    }

    @Override
    public String getLabelText() {
        return null;
    }

    @Override
    public IUiModelElement[] getChildren() {
        if (this.session != null && this.session.length != 0) {
            if (SortType.SESSION == UiModelRoot.getSortingType()) {
                Arrays.sort(this.session, UiModelSorting.getInstance());
                return this.session;
            }
            return this.session;
        }
        return new IUiModelElement[]{this.rootError};
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public IUiModelElement getParent() {
        return null;
    }

    @Override
    public Image getLabelImage() {
        return null;
    }

    public static void setSortingType(SortType sortType) {
        UiModelRoot.sortType = sortType;
    }

    public static SortType getSortingType() {
        return sortType;
    }

    public static enum SortType {
        DEFAULT,
        SESSION,
        EVENT,
        LIB,
        FUNCTION,
        LINE_NO;

    }
}

