/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.remote.debug.core.internal.sshprocess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.ldt.remote.debug.core.internal.sshprocess.InputStreamMonitor;
import org.eclipse.ldt.remote.debug.core.internal.sshprocess.OutputStreamMonitor;

public class StreamsProxy
implements IStreamsProxy,
IStreamsProxy2 {
    private OutputStreamMonitor fOutputMonitor;
    private OutputStreamMonitor fErrorMonitor;
    private InputStreamMonitor fInputMonitor;
    private boolean fClosed;

    public StreamsProxy(InputStream inputStream, InputStream errorStream, OutputStream outputStream, String inputEncoding, String outputEncoding) {
        this.fOutputMonitor = new OutputStreamMonitor(inputStream, inputEncoding);
        this.fErrorMonitor = new OutputStreamMonitor(errorStream, inputEncoding);
        this.fInputMonitor = new InputStreamMonitor(outputStream, outputEncoding);
        this.fOutputMonitor.startMonitoring();
        this.fErrorMonitor.startMonitoring();
        this.fInputMonitor.startMonitoring();
    }

    public void close() {
        if (!this.isClosed(true)) {
            this.fOutputMonitor.close();
            this.fErrorMonitor.close();
            this.fInputMonitor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed(boolean setClosed) {
        boolean closed;
        StreamsProxy streamsProxy = this;
        synchronized (streamsProxy) {
            closed = this.fClosed;
            if (setClosed) {
                this.fClosed = true;
            }
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        StreamsProxy streamsProxy = this;
        synchronized (streamsProxy) {
            this.fClosed = true;
        }
        this.fOutputMonitor.kill();
        this.fErrorMonitor.kill();
        this.fInputMonitor.close();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(String input) throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.write(input);
    }

    public void closeInputStream() throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.closeInputStream();
    }
}

