/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.preferences.fieldeditors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jwt.we.editors.preferences.wrappers.FontPreferenceWrapper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;

public class CustomFontFieldEditor
extends FieldEditor {
    private Button changeFontButton = null;
    private String changeButtonText;
    private FontData[] chosenFont;
    private Label valueControl;
    private DefaultPreviewer previewer;
    private FontPreferenceWrapper fontWrapper;

    protected CustomFontFieldEditor() {
    }

    public CustomFontFieldEditor(String name, Composite parent) {
        this.init(name, "");
        this.changeButtonText = JFaceResources.getString((String)"openChange");
        this.createControl(parent);
        this.fontWrapper = new FontPreferenceWrapper(name);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData data = new GridData();
        if (this.valueControl.getLayoutData() != null) {
            data = (GridData)this.valueControl.getLayoutData();
        }
        data.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)data);
    }

    protected void applyFont() {
        if (this.chosenFont != null && this.previewer != null) {
            this.previewer.setFont(this.chosenFont);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        gd = new GridData(768);
        gd.heightHint = 30;
        gd.widthHint = 20;
        this.previewer = new DefaultPreviewer("This is a preview text.", parent);
        this.previewer.getControl().setLayoutData((Object)gd);
        this.valueControl = this.getValueControl(parent);
        this.valueControl.setLayoutData((Object)gd);
        this.changeFontButton = this.getChangeControl(parent);
        gd = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.changeFontButton, 61);
        gd.widthHint = Math.max(widthHint, this.changeFontButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeFontButton.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(this.fontWrapper.get().getFontData());
    }

    protected void doLoadDefault() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(this.fontWrapper.getDefault().getFontData());
    }

    protected void doStore() {
        if (this.chosenFont != null) {
            Font newFont = new Font(null, this.chosenFont);
            this.fontWrapper.set(newFont);
        }
    }

    protected Button getChangeControl(Composite parent) {
        if (this.changeFontButton == null) {
            this.changeFontButton = new Button(parent, 8);
            if (this.changeButtonText != null) {
                this.changeFontButton.setText(this.changeButtonText);
            }
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(CustomFontFieldEditor.this.changeFontButton.getShell());
                    if (CustomFontFieldEditor.this.chosenFont != null) {
                        fontDialog.setFontList(CustomFontFieldEditor.this.chosenFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = CustomFontFieldEditor.this.chosenFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        CustomFontFieldEditor.this.setPresentsDefaultValue(false);
                        FontData[] newData = new FontData[]{font};
                        CustomFontFieldEditor.this.updateFont(newData);
                        CustomFontFieldEditor.this.fireValueChanged("field_editor_value", oldFont[0], font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CustomFontFieldEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(parent.getFont());
            this.setButtonLayoutData(this.changeFontButton);
        } else {
            this.checkParent((Control)this.changeFontButton, parent);
        }
        return this.changeFontButton;
    }

    public int getNumberOfControls() {
        return 3;
    }

    public int getPreferredPreviewHeight() {
        if (this.previewer == null) {
            return -1;
        }
        return 20;
    }

    public Control getPreviewControl() {
        if (this.previewer == null) {
            return null;
        }
        return this.previewer.getControl();
    }

    protected Label getValueControl(Composite parent) {
        if (this.valueControl == null) {
            this.valueControl = new Label(parent, 16384);
            this.valueControl.setFont(parent.getFont());
            this.valueControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CustomFontFieldEditor.this.valueControl = null;
                }
            });
        } else {
            this.checkParent((Control)this.valueControl, parent);
        }
        return this.valueControl;
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.changeButtonText = text;
        if (this.changeFontButton != null) {
            this.changeFontButton.setText(text);
        }
    }

    private void updateFont(FontData[] font) {
        FontData[] bestFont = JFaceResources.getFontRegistry().filterData(font, this.valueControl.getDisplay());
        if (bestFont == null) {
            bestFont = this.getDefaultFontData();
        }
        this.chosenFont = bestFont;
        if (this.valueControl != null) {
            this.valueControl.setText(StringConverter.asString((FontData)this.chosenFont[0]));
        }
        if (this.previewer != null) {
            this.previewer.setFont(bestFont);
        }
    }

    protected void setToDefault() {
        this.fontWrapper.setDefault();
    }

    private FontData[] getDefaultFontData() {
        return this.valueControl.getDisplay().getSystemFont().getFontData();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getChangeControl(parent).setEnabled(enabled);
        this.getValueControl(parent).setEnabled(enabled);
    }

    public void dispose() {
        super.dispose();
        this.fontWrapper = null;
    }

    private static class DefaultPreviewer {
        private Label text;
        private String string;
        private Font font;

        public DefaultPreviewer(String s, Composite parent) {
            this.string = s;
            this.text = new Label(parent, 18432);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DefaultPreviewer.this.font != null) {
                        DefaultPreviewer.this.font.dispose();
                    }
                }
            });
            if (this.string != null) {
                this.text.setText(this.string);
            }
        }

        public Control getControl() {
            return this.text;
        }

        public void setFont(FontData[] fontData) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }
}

