/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we;

import java.util.logging.ConsoleHandler;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.logging.internal.EclipseLogHandler;
import org.eclipse.jwt.we.misc.logging.internal.TextFormatter;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.osgi.framework.BundleContext;

public class Plugin
extends EclipseUIPlugin {
    private static final Logger logger = Logger.getLogger(Plugin.class);
    private static Plugin plugin;
    public static final String ICONS_BASE_PATH = "icons/";

    public Plugin() {
        java.util.logging.Logger packageLogger = java.util.logging.Logger.getLogger(Plugin.class.getPackage().getName());
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new TextFormatter());
        packageLogger.addHandler(handler);
        EclipseLogHandler eclipseLogHandler = new EclipseLogHandler((org.eclipse.core.runtime.Plugin)this);
        packageLogger.addHandler(eclipseLogHandler);
        logger.instanceCreation();
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        logger.debug("Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        logger.debug("Plugin stopped.");
    }

    public static String getId() {
        if (Plugin.getInstance() == null) {
            logger.info("Return a static plugin id, because the plugin is not yet created. It may be different from the actual plugin id.");
            return Plugin.class.getPackage().getName();
        }
        return Plugin.getInstance().getBundle().getSymbolicName();
    }

    public static Plugin getInstance() {
        return plugin;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public IFactoryRegistry getFactoryRegistry() {
        return Views.getInstance().getSelectedView().getFactoryRegistry();
    }

    public static boolean openEditor(IWorkbench workbench, URI fileUri) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = null;
        try {
            editorDescriptor = workbench.getEditorRegistry().getDefaultEditor(fileUri.toString());
            if (editorDescriptor == null) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)PluginProperties.editor_WarnNoEditor_message(fileUri.toString()));
                return false;
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)PluginProperties.editor_ErrorOpenEditor_title, (String)PluginProperties.editor_WarnNoEditor_message(fileUri.toString()));
            return false;
        }
        try {
            page.openEditor((IEditorInput)new URIEditorInput(fileUri), editorDescriptor.getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)PluginProperties.editor_ErrorOpenEditor_title, (String)exception.getMessage());
            return false;
        }
        return true;
    }
}

